/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client;

import com.direwolf20.mininggadgets.client.screens.ModificationTableScreen;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class MiningGadgetsJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("mininggadgets", "jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        IIngredientSubtypeInterpreter chargedProvider = (stack, uid) -> {
            if (!(stack.func_77973_b() instanceof MiningGadget)) {
                return "";
            }
            double energy = stack.func_196082_o().func_74769_h("energy");
            if (energy == 0.0) {
                return "empty";
            }
            if (energy == (double)((Integer)Config.MININGGADGET_MAXPOWER.get()).intValue()) {
                return "charged";
            }
            return "";
        };
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET_SIMPLE.get(), chargedProvider);
        registration.registerSubtypeInterpreter((Item)ModItems.MININGGADGET_FANCY.get(), chargedProvider);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ModificationTableScreen.class, (IGuiContainerHandler)new ModificationTableContainerHandler());
    }

    private static class ModificationTableContainerHandler
    implements IGuiContainerHandler<ModificationTableScreen> {
        private ModificationTableContainerHandler() {
        }

        public List<Rectangle2d> getGuiExtraAreas(ModificationTableScreen containerScreen) {
            return new ArrayList<Rectangle2d>(Collections.singleton(new Rectangle2d(containerScreen.field_230708_k_ / 2 - 120, containerScreen.field_230709_l_ / 2 - 5, 25, 35)));
        }
    }
}

