/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.WorldUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class TileEntityDecorationController
extends TileEntity
implements IBlueprintDataProvider {
    private static final String TAG_FACING = "facing";
    private String schematicName = "";
    private String schematicPath = "";
    private int tier = 0;
    private Direction basicFacing = Direction.NORTH;
    private BlockPos corner1 = BlockPos.field_177992_a;
    private BlockPos corner2 = BlockPos.field_177992_a;
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();

    public TileEntityDecorationController() {
        super(MinecoloniesTileEntities.DECO_CONTROLLER);
    }

    public String getSchematicPath() {
        return this.schematicPath;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String s) {
        this.schematicName = s;
    }

    public void setSchematicPath(String schematicPath) {
        this.schematicPath = schematicPath;
        if (this.field_145850_b != null) {
            this.update();
        }
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
        this.update();
    }

    public void setBasicFacing(Direction basicFacing) {
        this.basicFacing = basicFacing;
    }

    public Direction getBasicFacing() {
        return this.basicFacing;
    }

    private void update() {
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            WorldUtil.markChunkDirty(this.field_145850_b, this.field_174879_c);
        }
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        if (this.corner1 == BlockPos.field_177992_a || this.corner2 == BlockPos.field_177992_a) {
            return new Tuple((Object)this.field_174879_c, (Object)this.field_174879_c);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    public void readSchematicDataFromNBT(CompoundNBT compound) {
        super.readSchematicDataFromNBT(compound);
        if (compound.func_74764_b("name")) {
            this.schematicPath = compound.func_74779_i("name");
        }
        if (compound.func_74764_b("level")) {
            this.tier = compound.func_74762_e("level");
        }
        if (compound.func_74764_b(TAG_FACING)) {
            this.basicFacing = Direction.func_176731_b((int)compound.func_74762_e(TAG_FACING));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        super.readSchematicDataFromNBT(compound);
        this.schematicPath = compound.func_74779_i("name");
        this.tier = compound.func_74762_e("level");
        this.basicFacing = Direction.func_176731_b((int)compound.func_74762_e(TAG_FACING));
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeSchematicDataToNBT(compound);
        compound.func_74778_a("name", this.schematicPath);
        compound.func_74768_a("level", this.tier);
        compound.func_74768_a(TAG_FACING, this.basicFacing.func_176736_b());
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), compound);
    }

    public BlockPos getTilePos() {
        return this.field_174879_c;
    }
}

