/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.research;

import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.effects.ModResearchEffects;
import com.minecolonies.api.research.effects.registry.ResearchEffectEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class GlobalResearchEffect
implements IResearchEffect<Double> {
    private static final String TAG_ID = "id";
    private static final String TAG_DESC = "desc";
    private static final String TAG_SUBTITLE = "subtitle";
    private static final String TAG_EFFECT = "effect";
    private static final String TAG_DISPLAY_EFFECT = "display";
    private double effect;
    private final double displayEffect;
    private final ResourceLocation id;
    private final TranslationTextComponent desc;
    private final TranslationTextComponent subtitle;

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        this.desc = new TranslationTextComponent("com." + this.id.func_110624_b() + ".research." + this.id.func_110623_a().replaceAll("[ /:]", ".") + ".description", new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)});
        this.subtitle = new TranslationTextComponent("");
    }

    public GlobalResearchEffect(ResourceLocation id, double effect, double displayEffect, TranslationTextComponent desc, TranslationTextComponent subtitle) {
        this.id = id;
        this.effect = effect;
        this.displayEffect = displayEffect;
        this.desc = desc.func_150268_i().isEmpty() ? new TranslationTextComponent("com." + this.id.func_110623_a() + ".research." + this.id.func_110624_b().replaceAll("[ /:]", ".") + ".description", new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)}) : new TranslationTextComponent(desc.func_150268_i(), new Object[]{displayEffect, effect, Math.round(displayEffect * 100.0), Math.round(effect * 100.0)});
        this.subtitle = subtitle;
    }

    public GlobalResearchEffect(CompoundNBT nbt) {
        this.id = new ResourceLocation(nbt.func_74779_i(TAG_ID));
        this.effect = nbt.func_74769_h(TAG_EFFECT);
        this.displayEffect = nbt.func_74769_h(TAG_DISPLAY_EFFECT);
        this.desc = new TranslationTextComponent(nbt.func_74779_i(TAG_DESC), new Object[]{this.displayEffect, this.effect, Math.round(this.displayEffect * 100.0), Math.round(this.effect * 100.0)});
        this.subtitle = new TranslationTextComponent(nbt.func_74779_i(TAG_SUBTITLE));
    }

    @Override
    public Double getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(Double effect) {
        this.effect = effect;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslationTextComponent getDesc() {
        return this.desc;
    }

    @Override
    public TranslationTextComponent getSubtitle() {
        return this.subtitle;
    }

    @Override
    public boolean overrides(@NotNull IResearchEffect<?> other) {
        return Math.abs(this.effect) > Math.abs(((GlobalResearchEffect)other).effect);
    }

    @Override
    public ResearchEffectEntry getRegistryEntry() {
        return ModResearchEffects.globalResearchEffect;
    }

    @Override
    public CompoundNBT writeToNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a(TAG_ID, this.id.toString());
        nbt.func_74778_a(TAG_DESC, this.desc.func_150268_i());
        nbt.func_74778_a(TAG_SUBTITLE, this.subtitle.func_150268_i());
        nbt.func_74780_a(TAG_EFFECT, this.effect);
        nbt.func_74780_a(TAG_DISPLAY_EFFECT, this.displayEffect);
        return nbt;
    }
}

