/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderChangeMessage
extends AbstractColonyServerMessage {
    private int workOrderId;
    private int priority;
    private boolean removeWorkOrder;

    public WorkOrderChangeMessage() {
    }

    public WorkOrderChangeMessage(@NotNull IBuildingView building, int workOrderId, boolean removeWorkOrder, int priority) {
        super(building.getColony());
        this.workOrderId = workOrderId;
        this.removeWorkOrder = removeWorkOrder;
        this.priority = priority;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.workOrderId = buf.readInt();
        this.priority = buf.readInt();
        this.removeWorkOrder = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.workOrderId);
        buf.writeInt(this.priority);
        buf.writeBoolean(this.removeWorkOrder);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (this.removeWorkOrder) {
            colony.getWorkManager().removeWorkOrder(this.workOrderId);
        } else if (colony.getWorkManager().getWorkOrder(this.workOrderId) != null) {
            colony.getWorkManager().getWorkOrder(this.workOrderId).setPriority(this.priority);
        }
    }
}

