/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.combat;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.items.ItemSpear;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TridentItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class CombatUtils {
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.4;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public static AbstractArrowEntity createArrowForShooter(LivingEntity shooter) {
        AbstractArrowEntity arrowEntity = (AbstractArrowEntity)ModEntities.MC_NORMAL_ARROW.func_200721_a(shooter.field_70170_p);
        arrowEntity.func_212361_a((Entity)shooter);
        ItemStack rangedWeapon = shooter.func_184586_b(Hand.MAIN_HAND);
        Item rangedWeaponItem = rangedWeapon.func_77973_b();
        if (rangedWeaponItem instanceof BowItem) {
            arrowEntity = ((BowItem)rangedWeaponItem).customArrow(arrowEntity);
        } else if (rangedWeaponItem instanceof ItemSpear) {
            arrowEntity = (AbstractArrowEntity)ModEntities.SPEAR.func_200721_a(shooter.field_70170_p);
        } else if (rangedWeaponItem instanceof TridentItem) {
            arrowEntity = (AbstractArrowEntity)EntityType.field_203098_aL.func_200721_a(shooter.field_70170_p);
        }
        arrowEntity.func_70107_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + 1.0, shooter.func_226281_cx_());
        return arrowEntity;
    }

    public static void shootArrow(AbstractArrowEntity arrow, LivingEntity target, float hitChance) {
        double xVector = target.func_226277_ct_() - arrow.func_226277_ct_();
        double yVector = target.func_174813_aQ().field_72338_b + (double)target.func_213302_cg() / 2.0 - arrow.func_226278_cu_();
        double zVector = target.func_226281_cx_() - arrow.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(xVector * xVector + zVector * zVector));
        double dist3d = MathHelper.func_76133_a((double)(yVector * yVector + xVector * xVector + zVector * zVector));
        arrow.func_70186_c(xVector, yVector + distance * 0.18, zVector, (float)(1.4 + dist3d / 35.0), hitChance);
        target.field_70170_p.func_217376_c((Entity)arrow);
    }

    public static void notifyGuardsOfTarget(AbstractEntityCitizen user, LivingEntity target, int callRange) {
        for (ICitizenData iCitizenData : user.getCitizenData().getWorkBuilding().getAllAssignedCitizen()) {
            if (!iCitizenData.getEntity().isPresent() || iCitizenData.getEntity().get().func_70643_av() != null) continue;
            ((EntityCitizen)iCitizenData.getEntity().get()).getThreatTable().addThreat(target, 0);
        }
        if (target instanceof AbstractEntityMinecoloniesMob) {
            for (Map.Entry entry : user.getCitizenColonyHandler().getColony().getBuildingManager().getBuildings().entrySet()) {
                if (!(entry.getValue() instanceof AbstractBuildingGuards) || !(user.func_233580_cy_().func_177951_i((Vector3i)entry.getKey()) < (double)callRange)) continue;
                AbstractBuildingGuards building = (AbstractBuildingGuards)entry.getValue();
                building.setTempNextPatrolPoint(target.func_233580_cy_());
            }
        }
    }
}

