/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.sifter;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobSifter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSifter
extends AbstractEntityAICrafting<JobSifter, BuildingSifter> {
    private static final int MAX_LEVEL = 50;
    private static final int TICK_DELAY = 10;
    private static final int CHANCE_TO_DUMP_INV = 10;
    private static final int NO_MESH_DELAY = 100;
    protected int progress = 0;

    public EntityAIWorkSifter(@NotNull JobSifter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 10), new AITarget((IAIState)AIWorkerState.START_WORKING, AIWorkerState.SIFT, 1), new AITarget((IAIState)AIWorkerState.SIFT, this::sift, 10));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingSifter> getExpectedBuildingClass() {
        return BuildingSifter.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    protected IAIState sift() {
        BuildingSifter sifterBuilding = (BuildingSifter)this.building;
        if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getMaxDailyQuantity()) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ICraftingBuildingModule module = ((BuildingSifter)this.building).getFirstModuleOccurance(BuildingSifter.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        }
        if (this.currentRecipeStorage == null) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)sifterBuilding, i -> ModTags.meshes.func_230235_a_((Object)i.func_77973_b()), 1) == 0) {
                if (InventoryUtils.getItemCountInProvider((ICapabilityProvider)this.worker, i -> ModTags.meshes.func_230235_a_((Object)i.func_77973_b())) > 0) {
                    this.incrementActionsDone();
                    return AIWorkerState.INVENTORY_FULL;
                }
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.sifter.nomesh"), ChatPriority.IMPORTANT));
                    this.setDelay(100);
                }
            }
            if (!ItemStackUtils.isEmpty(this.worker.func_184614_ca()).booleanValue()) {
                this.worker.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
            if (!ItemStackUtils.isEmpty(this.worker.func_184592_cb()).booleanValue()) {
                this.worker.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
            }
            this.progress = 0;
            return AIWorkerState.START_WORKING;
        }
        ItemStack meshItem = this.currentRecipeStorage.getCraftingTools().get(0);
        ItemStack inputItem = this.currentRecipeStorage.getCleanedInput().stream().map(ItemStorage::getItemStack).filter(item -> !ItemStackUtils.compareItemStacksIgnoreStackSize(item, meshItem, false, true)).findFirst().orElse(ItemStack.field_190927_a);
        if (meshItem.func_190926_b() || inputItem.func_190926_b()) {
            this.currentRecipeStorage = null;
            return this.getState();
        }
        if (!inputItem.func_190926_b() && (ItemStackUtils.isEmpty(this.worker.func_184614_ca()).booleanValue() || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.func_184614_ca(), inputItem).booleanValue())) {
            this.worker.func_184611_a(Hand.MAIN_HAND, inputItem);
        }
        if (!meshItem.func_190926_b() && (ItemStackUtils.isEmpty(this.worker.func_184592_cb()).booleanValue() || ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.func_184592_cb(), meshItem, false, true))) {
            this.worker.func_184611_a(Hand.OFF_HAND, meshItem);
        }
        WorkerUtil.faceBlock(((BuildingSifter)this.building).getPosition(), this.worker);
        ++this.progress;
        if (this.progress > 50 - this.getEffectiveSkillLevel(this.getSecondarySkillLevel()) / 2) {
            this.progress = 0;
            sifterBuilding.setCurrentDailyQuantity(sifterBuilding.getCurrentDailyQuantity() + 1);
            if (sifterBuilding.getCurrentDailyQuantity() >= sifterBuilding.getMaxDailyQuantity() || this.worker.func_70681_au().nextInt(100) < 10) {
                this.incrementActionsDoneAndDecSaturation();
            }
            if (!this.currentRecipeStorage.fullfillRecipe(this.getLootContext(), sifterBuilding.getHandlers())) {
                this.currentRecipeStorage = null;
                return this.getState();
            }
            this.worker.decreaseSaturationForContinuousAction();
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(meshItem, sifterBuilding.getID()), (Entity)this.worker);
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(inputItem, sifterBuilding.getID().func_177977_b()), (Entity)this.worker);
        this.worker.func_184609_a(Hand.MAIN_HAND);
        SoundUtils.playSoundAtCitizen(this.world, ((BuildingSifter)this.building).getID(), SoundEvents.field_187746_da);
        return this.getState();
    }
}

