/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IGraveData;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.coremod.compatibility.journeymap.Journeymap;
import com.minecolonies.coremod.compatibility.journeymap.JourneymapOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.model.MapImage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyDeathpoints {
    private static final Map<RegistryKey<World>, Map<Integer, Map<BlockPos, Waypoint>>> overlays = new HashMap<RegistryKey<World>, Map<Integer, Map<BlockPos, Waypoint>>>();
    private static final Lazy<MapImage> deathIcon = Lazy.of(ColonyDeathpoints::loadIcon);

    private ColonyDeathpoints() {
    }

    public static void clear() {
        overlays.clear();
    }

    public static void unload(@NotNull Journeymap jmap, @NotNull RegistryKey<World> dimension) {
        for (Map waypoints : overlays.getOrDefault(dimension, Collections.emptyMap()).values()) {
            for (Map.Entry waypointEntry : waypoints.entrySet()) {
                if (waypointEntry.getValue() == null) continue;
                jmap.getApi().remove((Displayable)waypointEntry.getValue());
                waypointEntry.setValue(null);
            }
        }
    }

    public static void updateGraves(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull Set<BlockPos> graves) {
        Map waypoints = overlays.computeIfAbsent(colony.getDimension(), k -> new HashMap()).computeIfAbsent(colony.getID(), k -> new HashMap());
        boolean permitted = colony.getPermissions().hasPermission((PlayerEntity)Minecraft.func_71410_x().field_71439_g, Action.MAP_DEATHS) && JourneymapOptions.getDeathpoints(jmap.getOptions());
        Iterator iterator = waypoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry waypointEntry = iterator.next();
            if (permitted && graves.contains(waypointEntry.getKey())) continue;
            if (waypointEntry.getValue() != null) {
                jmap.getApi().remove((Displayable)waypointEntry.getValue());
            }
            iterator.remove();
        }
        if (permitted) {
            for (BlockPos grave : graves) {
                waypoints.computeIfAbsent(grave, k -> ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, k));
            }
        }
    }

    public static void updateChunk(@NotNull Journeymap jmap, @NotNull RegistryKey<World> dimension, @NotNull IChunk chunk) {
        IColonyManager colonyManager = MinecoloniesAPIProxy.getInstance().getColonyManager();
        for (Map.Entry colonyEntry : overlays.getOrDefault(dimension, Collections.emptyMap()).entrySet()) {
            IColonyView colony = colonyManager.getColonyView((Integer)colonyEntry.getKey(), dimension);
            if (colony == null) {
                for (Waypoint waypoint : ((Map)colonyEntry.getValue()).values()) {
                    if (waypoint == null) continue;
                    jmap.getApi().remove((Displayable)waypoint);
                }
                ((Map)colonyEntry.getValue()).clear();
                continue;
            }
            for (Map.Entry entry : ((Map)colonyEntry.getValue()).entrySet()) {
                if (entry.getValue() != null || !chunk.func_76632_l().equals((Object)new ChunkPos((BlockPos)entry.getKey()))) continue;
                entry.setValue(ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, chunk, (BlockPos)entry.getKey()));
            }
        }
    }

    @Nullable
    private static Waypoint tryCreatingWaypoint(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        IChunk chunk = colony.getWorld().func_217353_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222617_m, false);
        return chunk == null ? null : ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, chunk, pos);
    }

    @Nullable
    private static Waypoint tryCreatingWaypoint(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull IChunk chunk, @NotNull BlockPos pos) {
        IGraveData grave;
        if (!jmap.getApi().playerAccepts("minecolonies", DisplayType.Waypoint)) {
            return null;
        }
        TileEntity blockEntity = chunk.func_175625_s(pos);
        if (blockEntity instanceof AbstractTileEntityGrave && (grave = ((AbstractTileEntityGrave)blockEntity).getGraveData()) != null) {
            TranslationTextComponent text = grave.getCitizenJobName() == null ? new TranslationTextComponent("com.minecolonies.coremod.journeymap.deathpoint_name", new Object[]{grave.getCitizenName()}) : new TranslationTextComponent("com.minecolonies.coremod.journeymap.deathpoint_namejob", new Object[]{grave.getCitizenName(), grave.getCitizenJobName()});
            Waypoint waypoint = new Waypoint("minecolonies", text.getString(), colony.getDimension(), pos);
            ((Waypoint)waypoint.setEditable(true).setPersistent(false).setIcon((MapImage)deathIcon.get())).setColor(0x888888);
            jmap.show((Displayable)waypoint);
            return waypoint;
        }
        return null;
    }

    @NotNull
    private static MapImage loadIcon() {
        return new MapImage(new ResourceLocation("minecolonies", "textures/icons/grave_icon.png"), 16, 16);
    }
}

