/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CommandCitizenReload
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (RegistryKey<World>)((CommandSource)context.getSource()).func_197023_e().func_234923_W_());
        if (colony == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.colonyidnotfound", new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        citizenData.updateEntityIfNecessary();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("com.minecolonies.command.citizenreload.success", new Object[]{citizenData.getId()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

