/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemCrafterJobDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class StandardRequestSystemCrafterJobDataStore
implements IRequestSystemCrafterJobDataStore {
    private IToken<?> id;
    private final LinkedList<IToken<?>> queue;
    private final List<IToken<?>> tasks;

    public StandardRequestSystemCrafterJobDataStore(IToken<?> id, LinkedList<IToken<?>> queue, List<IToken<?>> tasks) {
        this.id = id;
        this.queue = queue;
        this.tasks = tasks;
    }

    public StandardRequestSystemCrafterJobDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new LinkedList(), new ArrayList());
    }

    @Override
    public LinkedList<IToken<?>> getQueue() {
        return this.queue;
    }

    @Override
    public List<IToken<?>> getAssignedTasks() {
        return this.tasks;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestSystemCrafterJobDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestSystemCrafterJobDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestSystemCrafterJobDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestSystemCrafterJobDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestSystemCrafterJobDataStore();
        }

        @Override
        @NotNull
        public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StandardRequestSystemCrafterJobDataStore standardRequestSystemCrafterJobDataStore) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("Token", (INBT)controller.serialize(standardRequestSystemCrafterJobDataStore.id));
            compound.func_218657_a("List", (INBT)standardRequestSystemCrafterJobDataStore.queue.stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("AssignedList", (INBT)standardRequestSystemCrafterJobDataStore.tasks.stream().map(controller::serialize).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardRequestSystemCrafterJobDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) throws Throwable {
            IToken token = (IToken)controller.deserialize(nbt.func_74775_l("Token"));
            LinkedList queue = NBTUtils.streamCompound(nbt.func_150295_c("List", 10)).map(CompoundNBT2 -> (IToken)controller.deserialize((CompoundNBT)CompoundNBT2)).collect(Collectors.toCollection(LinkedList::new));
            List<IToken<?>> taskList = NBTUtils.streamCompound(nbt.func_150295_c("AssignedList", 10)).map(CompoundNBT2 -> (IToken)controller.deserialize((CompoundNBT)CompoundNBT2)).collect(Collectors.toList());
            return new StandardRequestSystemCrafterJobDataStore(token, queue, taskList);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestSystemCrafterJobDataStore input, PacketBuffer packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.queue.size());
            input.queue.forEach(entry -> controller.serialize(packetBuffer, entry));
            packetBuffer.writeInt(input.tasks.size());
            input.tasks.forEach(task -> controller.serialize(packetBuffer, task));
        }

        @Override
        public StandardRequestSystemCrafterJobDataStore deserialize(IFactoryController controller, PacketBuffer buffer) throws Throwable {
            IToken id = (IToken)controller.deserialize(buffer);
            LinkedList queue = new LinkedList();
            int queueSize = buffer.readInt();
            for (int i = 0; i < queueSize; ++i) {
                queue.add((IToken<?>)controller.deserialize(buffer));
            }
            ArrayList tasks = new ArrayList();
            int tasksSize = buffer.readInt();
            for (int i = 0; i < tasksSize; ++i) {
                tasks.add((IToken<?>)controller.deserialize(buffer));
            }
            return new StandardRequestSystemCrafterJobDataStore(id, queue, tasks);
        }

        @Override
        public short getSerializationId() {
            return SerializationIdentifierConstants.STANDARD_REQUEST_SYSTEM_CRAFTER_JOB_DATASTORE_ID;
        }
    }
}

