/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSifter
extends AbstractBuilding {
    private static final double BUILDING_LEVEL_MULTIPLIER = 64.0;
    private static final String SIFTER_DESC = "sifter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private int currentDailyQuantity = 0;

    public BuildingSifter(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a(ModTags.meshes), new Tuple((Object)4, (Object)false));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SIFTER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 64.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        return compound;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

