/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.settings.PatrolModeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.StringSettingWithDesc;
import com.minecolonies.coremod.colony.buildings.moduleviews.ToolModuleView;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuardTaskSetting
extends StringSettingWithDesc {
    public static final String PATROL = "com.minecolonies.core.guard.setting.patrol";
    public static final String GUARD = "com.minecolonies.core.guard.setting.guard";
    public static final String FOLLOW = "com.minecolonies.core.guard.setting.follow";
    public static final String PATROL_MINE = "com.minecolonies.core.guard.setting.patrol_mine";

    public GuardTaskSetting() {
        super(PATROL, GUARD, FOLLOW, PATROL_MINE);
    }

    public GuardTaskSetting(String ... list) {
        super(list);
    }

    public GuardTaskSetting(List<String> settings, int currentIndex) {
        super(settings, currentIndex);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        Loader.createFromXMLFile((String)"minecolonies:gui/layouthuts/layoutguardtasksetting.xml", (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(key.getUniqueId().toString());
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.setting." + key.getUniqueId().toString()));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> settingsModuleView.trigger(key));
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, Window window) {
        String setting = this.getSettings().get(this.getCurrentIndex());
        ButtonImage targetButton = (ButtonImage)pane.findPaneOfTypeByID("setTarget", ButtonImage.class);
        Text mineLabel = (Text)pane.findPaneOfTypeByID("minePos", Text.class);
        if (setting.equals(PATROL_MINE) && building instanceof AbstractBuildingGuards.View) {
            mineLabel.setVisible(true);
            if (((AbstractBuildingGuards.View)building).getMinePos() != null) {
                mineLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.worherhuts.patrollingmine", new Object[]{((AbstractBuildingGuards.View)building).getMinePos().func_229422_x_()}));
            } else {
                mineLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.guard.assignmine"));
            }
            targetButton.setVisible(false);
        } else if (!setting.equals(FOLLOW)) {
            mineLabel.setVisible(false);
            targetButton.setVisible(true);
            if (setting.equals(PATROL)) {
                if (!settingsModuleView.getSetting(AbstractBuildingGuards.PATROL_MODE).getValue().equals(PatrolModeSetting.MANUAL)) {
                    targetButton.setVisible(false);
                } else {
                    targetButton.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.targetpatrol"));
                }
            } else {
                targetButton.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.targetguard"));
            }
            targetButton.setHandler(button -> building.getModuleView(ToolModuleView.class).getWindow().open());
        } else {
            mineLabel.setVisible(false);
            targetButton.setVisible(false);
        }
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText((IFormattableTextComponent)new TranslationTextComponent(setting));
    }

    @Override
    public void onUpdate(IBuilding building, ServerPlayerEntity sender) {
        if (building instanceof AbstractBuildingGuards && this.getValue().equals(FOLLOW)) {
            ((AbstractBuildingGuards)building).setPlayerToFollow((PlayerEntity)sender);
        }
    }
}

