/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.client.render.modeltype.CitizenModel;
import com.minecolonies.api.client.render.modeltype.CitizenPlayerModel;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.client.model.ModelEntityFemaleCitizen;
import com.minecolonies.coremod.client.render.MRenderTypes;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderBipedCitizen
extends MobRenderer<AbstractEntityCitizen, CitizenModel<AbstractEntityCitizen>> {
    private static final double SHADOW_SIZE = 0.5;
    public static boolean isItGhostTime = false;

    public RenderBipedCitizen(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new CitizenModel(0.0f), 0.5f);
        super.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new CitizenModel(0.5f), new CitizenModel(1.0f)));
        super.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
    }

    public void render(@NotNull AbstractEntityCitizen citizen, float limbSwing, float partialTicks, @NotNull MatrixStack matrixStack, @NotNull IRenderTypeBuffer renderTypeBuffer, int light) {
        this.setupMainModelFrom(citizen);
        CitizenModel citizenModel = (CitizenModel)this.field_77045_g;
        ItemStack mainHandStack = citizen.func_184614_ca();
        ItemStack offHandStack = citizen.func_184592_cb();
        BipedModel.ArmPose armPoseMainHand = this.getArmPoseFrom(citizen, mainHandStack);
        BipedModel.ArmPose armPoseOffHand = this.getArmPoseFrom(citizen, offHandStack);
        this.updateArmPose(citizen, citizenModel, armPoseMainHand, armPoseOffHand);
        if (isItGhostTime) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
            super.func_225623_a_((MobEntity)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        } else {
            super.func_225623_a_((MobEntity)citizen, limbSwing, partialTicks, matrixStack, renderTypeBuffer, light);
        }
    }

    private void setupMainModelFrom(@NotNull AbstractEntityCitizen citizen) {
        @Nullable IModelType modelType = IModelTypeRegistry.getInstance().getModelType(citizen.getModelType());
        Object object = this.field_77045_g = citizen.isFemale() ? modelType.getFemaleModel() : modelType.getMaleModel();
        if (this.field_77045_g == null) {
            CitizenModel citizenModel = this.field_77045_g = citizen.isFemale() ? new ModelEntityFemaleCitizen() : new CitizenModel(0.0f);
        }
        if (citizen.getCitizenDataView() != null && citizen.getCitizenDataView().getCustomTexture() != null) {
            this.field_77045_g = new CitizenPlayerModel(0.0f, false);
        }
        ((CitizenModel)this.field_77045_g).field_217114_e = citizen.func_70631_g_();
        ((CitizenModel)this.field_77045_g).field_217113_d = citizen.func_184187_bx() != null;
        ((CitizenModel)this.field_77045_g).field_217112_c = citizen.field_70733_aJ;
    }

    protected void renderNameTag(@NotNull AbstractEntityCitizen entityIn, @NotNull ITextComponent str, @NotNull MatrixStack matrixStack, @NotNull IRenderTypeBuffer buffer, int maxDistance) {
        double distance;
        super.func_225629_a_((Entity)entityIn, str, matrixStack, buffer, maxDistance);
        if (!Minecraft.func_71410_x().field_71474_y.field_74319_N && entityIn.getCitizenDataView() != null && entityIn.getCitizenDataView().hasVisibleInteractions() && (distance = this.field_76990_c.func_78714_a(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_())) <= 4096.0) {
            double yOffset = ((CitizenModel)this.field_77045_g).field_217114_e ? -0.3 : 0.0;
            boolean isSneaking = entityIn.func_225608_bj_();
            double height = entityIn.func_213302_cg() + 0.5f - (isSneaking ? 0.25f : 0.0f);
            double y = height + 0.3 + yOffset;
            ResourceLocation texture = entityIn.getCitizenDataView().getInteractionIcon();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, y, 0.0);
            matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            IVertexBuilder r = buffer.getBuffer(MRenderTypes.customTextRenderer(texture));
            r.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 0.0f).func_227886_a_(250).func_181675_d();
            r.func_227888_a_(matrix, 0.0f, 10.0f, 0.0f).func_225583_a_(1.0f, 0.0f).func_227886_a_(250).func_181675_d();
            r.func_227888_a_(matrix, 10.0f, 10.0f, 0.0f).func_225583_a_(1.0f, 1.0f).func_227886_a_(250).func_181675_d();
            r.func_227888_a_(matrix, 10.0f, 0.0f, 0.0f).func_225583_a_(0.0f, 1.0f).func_227886_a_(250).func_181675_d();
            matrixStack.func_227865_b_();
        }
    }

    private BipedModel.ArmPose getArmPoseFrom(@NotNull AbstractEntityCitizen citizen, ItemStack mainHandStack) {
        BipedModel.ArmPose pose = BipedModel.ArmPose.EMPTY;
        if (!mainHandStack.func_190926_b()) {
            pose = BipedModel.ArmPose.ITEM;
            if (citizen.func_184605_cv() > 0) {
                UseAction enumActionMainHand = mainHandStack.func_77975_n();
                if (enumActionMainHand == UseAction.BLOCK) {
                    pose = BipedModel.ArmPose.BLOCK;
                } else if (enumActionMainHand == UseAction.BOW) {
                    pose = BipedModel.ArmPose.BOW_AND_ARROW;
                }
            }
        }
        return pose;
    }

    private void updateArmPose(@NotNull AbstractEntityCitizen citizen, BipedModel<AbstractEntityCitizen> citizenModel, BipedModel.ArmPose armPoseMainHand, BipedModel.ArmPose armPoseOffHand) {
        if (citizen.func_184591_cq() == HandSide.RIGHT) {
            citizenModel.field_187076_m = armPoseMainHand;
            citizenModel.field_187075_l = armPoseOffHand;
        } else {
            citizenModel.field_187076_m = armPoseOffHand;
            citizenModel.field_187075_l = armPoseMainHand;
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(AbstractEntityCitizen entity) {
        if (entity.getCitizenDataView() != null && entity.getCitizenDataView().getCustomTexture() != null) {
            return entity.getCitizenDataView().getCustomTexture();
        }
        return entity.getTexture();
    }
}

