/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Text;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallColonyDelete;
import com.minecolonies.coremod.network.messages.client.CreateColonyMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WindowTownHallColonyManage
extends AbstractWindowSkeleton {
    private static final String BUTTON_CLOSE = "cancel";
    private static final String BUTTON_DELETE = "delete";
    private static final String BUTTON_CREATE = "create";
    private static final String TEXT_NEARBY = "nearbycolony";
    private static final String TEXT_OWN = "owncolony";
    private static final String TEXT_FEEDBACK = "creationpossible";
    private final BlockPos pos;

    public WindowTownHallColonyManage(PlayerEntity player, BlockPos pos, World world) {
        super("minecolonies:gui/townhall/windowcolonymanagement.xml");
        this.pos = pos;
        IColony existingColony = IColonyManager.getInstance().getIColony(world, pos);
        if (existingColony != null) {
            ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.here", new Object[]{existingColony.getName(), existingColony.getPermissions().getOwnerName()}));
        } else {
            int closeColonyID = WindowTownHallColonyManage.findNextNearbyColony(world, pos, (Integer)MineColonies.getConfig().getServer().minColonyDistance.get());
            if (closeColonyID != 0) {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.near", new Object[]{closeColonyID}));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_NEARBY, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.nonenearby"));
            }
        }
        IColony ownerColony = IColonyManager.getInstance().getIColonyByOwner(world, player);
        if (ownerColony != null) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_DELETE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.own", new Object[]{ownerColony.getCenter()}));
            if (((Boolean)MineColonies.getConfig().getServer().allowInfiniteColonies.get()).booleanValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.denied.existingandabandon"));
            } else {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.denied.existing"));
            }
        } else {
            IColony colony;
            ((Text)this.findPaneOfTypeByID(TEXT_OWN, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.none"));
            if (!(existingColony == null && IColonyManager.getInstance().isFarEnoughFromColonies(world, pos) || (colony = existingColony != null ? existingColony : IColonyManager.getInstance().getClosestColony(world, pos)) == null)) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.denied.tooclose", new Object[]{colony.getName()}));
            }
        }
        if (((Boolean)MineColonies.getConfig().getServer().restrictColonyPlacement.get()).booleanValue()) {
            double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(pos, new BlockPos(world.func_72912_H().func_76079_c(), world.func_72912_H().func_76075_d(), world.func_72912_H().func_76074_e())));
            if (spawnDistance < (double)((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.tooclose", new Object[]{MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()}));
            } else if (spawnDistance > (double)((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()).intValue()) {
                ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.toofar", new Object[]{MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get()}));
            }
        }
        if (((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).isTextEmpty()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CREATE, ButtonImage.class)).enable();
            ((Text)this.findPaneOfTypeByID(TEXT_FEEDBACK, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.colony.allowed.create"));
        }
        this.registerButton(BUTTON_CLOSE, this::close);
        this.registerButton(BUTTON_CREATE, this::onCreate);
        this.registerButton(BUTTON_DELETE, () -> new WindowTownHallColonyDelete().open());
    }

    public void onCreate() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        TranslationTextComponent colonyName = new TranslationTextComponent("com.minecolonies.coremod.gui.townhall.defaultname", new Object[]{player.func_200200_C_()});
        new VanillaParticleMessage(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), ParticleTypes.field_197616_i).onExecute(null, false);
        player.field_70170_p.func_184133_a((PlayerEntity)player, new BlockPos(Minecraft.func_71410_x().field_71439_g.func_213303_ch()), SoundEvents.field_219605_aC, SoundCategory.AMBIENT, 2.5f, 0.8f);
        Network.getNetwork().sendToServer(new CreateColonyMessage(this.pos, colonyName.getString()));
        this.close();
    }

    private static int findNextNearbyColony(World world, BlockPos start, int range) {
        int startX = start.func_177958_n() >> 4;
        int startZ = start.func_177952_p() >> 4;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                int chunkX = startX + x;
                int chunkZ = startZ + z;
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (cap == null) continue;
                if (cap.getOwningColony() != 0) {
                    return cap.getOwningColony();
                }
                if (cap.getStaticClaimColonies().isEmpty()) continue;
                return cap.getStaticClaimColonies().get(0);
            }
        }
        return 0;
    }
}

