/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.TransferItemsRequestMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowBuilderResModule
extends AbstractModuleWindow {
    public static final int RED = Color.getByName((String)"red", (int)0);
    public static final int DARKGREEN = Color.getByName((String)"darkgreen", (int)0);
    public static final int BLACK = Color.getByName((String)"black", (int)0);
    public static final int ORANGE = Color.getByName((String)"orange", (int)0);
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();
    private final BuildingResourcesModuleView moduleView;
    private int tick = 0;

    public WindowBuilderResModule(String res, IBuildingView building, BuildingResourcesModuleView moduleView) {
        super(building, res);
        this.moduleView = moduleView;
        ((Text)this.findPaneOfTypeByID("desc", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent(moduleView.getDesc().toLowerCase(Locale.US)));
        this.pullResourcesFromHut();
        this.registerButton("resourceAdd", this::transferItems);
    }

    private void pullResourcesFromHut() {
        PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.func_184812_l_();
        this.resources.clear();
        this.resources.addAll(this.moduleView.getResources().values());
        double supplied = 0.0;
        double total = 0.0;
        for (BuildingBuilderResource resource : this.resources) {
            int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack()) != false);
            resource.setPlayerAmount(amountToSet);
            supplied += (double)Math.min(resource.getAvailable(), resource.getAmount());
            total += (double)resource.getAmount();
        }
        if (total > 0.0) {
            ((Text)this.findPaneOfTypeByID("progress", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.progress.res", new Object[]{(int)(supplied / total * 100.0) + "%", this.moduleView.getProgress() + "%"}));
        }
        this.resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
    }

    public void onOpened() {
        super.onOpened();
        this.pullResourcesFromHut();
        ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowBuilderResModule.this.resources.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowBuilderResModule.this.updateResourcePane(index, rowPane);
            }
        });
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.buildingView));
        ((Text)this.findPaneOfTypeByID("constructionName", Text.class)).setText(this.moduleView.getConstructionName());
        ((Text)this.findPaneOfTypeByID("stepprogress", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.progress.step", new Object[]{this.moduleView.getCurrentStage(), this.moduleView.getTotalStages()}));
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)rowPane.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        Button addButton = (Button)rowPane.findPaneOfTypeByID("resourceAdd", Button.class);
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColors(RED);
                resourceMissingLabel.setColors(RED);
                neededLabel.setColors(RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColors(ORANGE);
                resourceMissingLabel.setColors(ORANGE);
                neededLabel.setColors(ORANGE);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColors(DARKGREEN);
                resourceMissingLabel.setColors(DARKGREEN);
                neededLabel.setColors(DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColors(BLACK);
                resourceMissingLabel.setColors(BLACK);
                neededLabel.setColors(BLACK);
            }
        }
        int buttonX = rowPane.getWidth() - addButton.getWidth() - (rowPane.getHeight() - addButton.getHeight()) / 2;
        int buttonY = rowPane.getHeight() - addButton.getHeight() - 2;
        addButton.setPosition(buttonX, buttonY);
        resourceLabel.setText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Integer.toString(missing));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(resource.getAvailable() + " / " + resource.getAmount());
        ((Text)rowPane.findPaneOfTypeByID("resourceId", Text.class)).setText(Integer.toString(index));
        ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack((IItemProvider)resource.getItem(), 1);
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(stack);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick++ == 20) {
            this.pullResourcesFromHut();
            this.tick = 0;
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
    }

    private void transferItems(@NotNull Button button) {
        View pane = button.getParent();
        button.disable();
        Text idLabel = (Text)pane.findPaneOfTypeByID("resourceId", Text.class);
        int index = Integer.parseInt(idLabel.getTextAsString());
        BuildingBuilderResource res = this.resources.get(index);
        if (res == null) {
            Log.getLogger().warn("WindowHutBuilder.transferItems: Error - Could not find the resource.");
        } else {
            @NotNull ItemStack itemStack = res.getItemStack().func_77946_l();
            itemStack.func_190920_e(1);
            Text quantityLabel = (Text)pane.findPaneOfTypeByID("resourceQuantity", Text.class);
            int quantity = Integer.parseInt(quantityLabel.getTextAsString());
            int needed = res.getAmount() - res.getAvailable();
            res.setAvailable(Math.min(res.getAmount(), res.getAvailable() + res.getPlayerAmount()));
            res.setPlayerAmount(Math.max(0, res.getPlayerAmount() - needed));
            this.resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
            Network.getNetwork().sendToServer(new TransferItemsRequestMessage(this.buildingView, itemStack, quantity, true));
        }
    }
}

