/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.DyeColor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPalette {
    public static final DyeColor[] DYES = DyeColor.values();
    public static int BUTTON_SIZE = 20;
    protected List<PaletteButton> buttons = new ArrayList<PaletteButton>();
    protected DyeColor selected = DyeColor.WHITE;
    public ChangeEvent onchange;

    public ColorPalette(int x, int y, int col, IWidgetAdder adder) {
        int topLeftX = x - col * BUTTON_SIZE / 2;
        int topLeftY = y - DYES.length / col * BUTTON_SIZE / 2;
        for (DyeColor color : DYES) {
            int posX = topLeftX + color.func_196059_a() % col * BUTTON_SIZE;
            int posY = topLeftY + BUTTON_SIZE * Math.floorDiv(color.func_196059_a(), col);
            PaletteButton button = new PaletteButton(posX, posY, BUTTON_SIZE, color);
            this.buttons.add(button);
            adder.onBuild(button);
        }
    }

    public ColorPalette(Screen gui, IWidgetAdder adder) {
        this(gui.field_230708_k_ / 2, gui.field_230709_l_ / 2, (int)Math.floor(Math.sqrt(DYES.length)), adder);
    }

    public DyeColor getSelected() {
        return this.selected;
    }

    public void setSelected(DyeColor selected) {
        this.selected = selected;
    }

    public class PaletteButton
    extends Button {
        private final DyeColor color;

        public PaletteButton(int posX, int posY, int sideLength, DyeColor color) {
            super(posX, posY, sideLength, sideLength, (ITextComponent)new StringTextComponent(""), pressed -> {});
            this.color = color;
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            this.field_230693_o_ = ColorPalette.this.selected != this.color;
            super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        }

        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            boolean pressed;
            int color = this.color.getColorValue();
            boolean bl = pressed = ColorPalette.this.selected == this.color;
            this.fillButton(stack, 0, 0, 0, 0, this.func_230449_g_() ? 0xFFFFFF : (pressed ? this.brighten(color, 0.5f) : 0));
            this.fillButton(stack, 1, 1, 1, 1, this.brighten(color, 0.8f));
            if (pressed) {
                this.fillButton(stack, 2, 2, 1, 1, this.brighten(color, 1.2f));
                this.fillButton(stack, 2, 2, 2, 2, color);
                this.fillButton(stack, 7, 7, 7, 7, 0x33000001);
            } else {
                this.fillButton(stack, 1, 1, 3, 2, this.brighten(color, 1.2f));
                this.fillButton(stack, 2, 2, 3, 2, color);
            }
        }

        public void func_230930_b_() {
            ColorPalette.this.selected = this.color;
            ColorPalette.this.onchange.onChange(ColorPalette.this.selected);
        }

        private void fillButton(MatrixStack stack, int t, int l, int b, int r, int color) {
            PaletteButton.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ + l), (int)(this.field_230691_m_ + t), (int)(this.field_230690_l_ + this.field_230688_j_ - r), (int)(this.field_230691_m_ + this.field_230689_k_ - b), (int)(color -= 0x1000000));
        }

        private int brighten(int color, float factor) {
            int r = color >> 16;
            int g = color - (r << 16) >> 8;
            int b = color - (r << 16) - (g << 8);
            r = (int)Math.min(255.0f, (float)r * factor) << 16;
            g = (int)Math.min(255.0f, (float)g * factor) << 8;
            b = (int)Math.min(255.0f, (float)b * factor);
            return r + g + b;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ChangeEvent {
        public void onChange(DyeColor var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IWidgetAdder {
        public void onBuild(Button var1);
    }
}

