/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.IColony;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MessageUtils {
    public static MessageBuilder format(String key, Object ... args) {
        return MessageUtils.format((ITextComponent)new TranslationTextComponent(key, args));
    }

    public static MessageBuilder format(ITextComponent component) {
        return new MessageBuilder(component);
    }

    private static IFormattableTextComponent getFormattableComponent(ITextComponent component) {
        if (component instanceof IFormattableTextComponent) {
            return (IFormattableTextComponent)component;
        }
        return new StringTextComponent("").func_230529_a_(component);
    }

    public static class MessageBuilderColonyPlayerSelector {
        private final IFormattableTextComponent rootComponent;
        private final IColony colony;
        private final boolean alwaysShowColony;

        public MessageBuilderColonyPlayerSelector(IFormattableTextComponent rootComponent, IColony colony, boolean alwaysShowColony) {
            this.rootComponent = rootComponent;
            this.colony = colony;
            this.alwaysShowColony = alwaysShowColony;
        }

        public void forAllPlayers() {
            this.sendInternal(this.colony.getMessagePlayerEntities());
        }

        public void forManagers() {
            this.sendInternal(this.colony.getImportantMessageEntityPlayers());
        }

        private void sendInternal(Collection<PlayerEntity> players) {
            for (PlayerEntity player : players) {
                IFormattableTextComponent fullComponent = this.rootComponent.func_230532_e_();
                if (this.alwaysShowColony || !this.colony.isCoordInColony(player.field_70170_p, player.func_233580_cy_())) {
                    fullComponent = new StringTextComponent("[" + this.colony.getName() + "] ").func_230529_a_((ITextComponent)this.rootComponent);
                }
                player.func_145747_a((ITextComponent)fullComponent, player.func_110124_au());
            }
        }
    }

    public static class MessageBuilder {
        private IFormattableTextComponent rootComponent;
        private IFormattableTextComponent currentComponent;

        MessageBuilder(ITextComponent component) {
            this.currentComponent = MessageUtils.getFormattableComponent(component);
        }

        public MessageBuilder with(Style style) {
            this.currentComponent.func_230530_a_(style.func_240717_a_(this.currentComponent.func_150256_b()));
            return this;
        }

        public MessageBuilder with(TextFormatting ... formatting) {
            this.currentComponent.func_230530_a_(this.currentComponent.func_150256_b().func_240720_a_(formatting));
            return this;
        }

        public MessageBuilder append(String key, Object ... args) {
            return this.append((ITextComponent)new TranslationTextComponent(key, args));
        }

        public MessageBuilder append(ITextComponent component) {
            this.mergeComponents();
            this.currentComponent = MessageUtils.getFormattableComponent(component);
            return this;
        }

        public IFormattableTextComponent create() {
            this.mergeComponents();
            return this.rootComponent;
        }

        public void sendTo(PlayerEntity ... players) {
            this.sendTo(Arrays.asList(players));
        }

        public void sendTo(Collection<PlayerEntity> players) {
            this.mergeComponents();
            for (PlayerEntity player : players) {
                player.func_145747_a((ITextComponent)this.rootComponent, player.func_110124_au());
            }
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony) {
            return this.sendTo(colony, false);
        }

        public MessageBuilderColonyPlayerSelector sendTo(IColony colony, boolean alwaysShowColony) {
            this.mergeComponents();
            return new MessageBuilderColonyPlayerSelector(this.rootComponent, colony, alwaysShowColony);
        }

        private void mergeComponents() {
            if (this.rootComponent == null) {
                this.rootComponent = this.currentComponent;
            } else {
                this.rootComponent.func_230529_a_((ITextComponent)this.currentComponent);
            }
            this.currentComponent = null;
        }
    }
}

