/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    private static final double SPAWN_MODIFIER = 0.8;
    private static final double SPAWN_ADDITION = 0.1;
    private static final int MAX_RANDOM_SPAWN = 21;
    private static final int MIN_RANDOM_SPAWN = 10;
    private static final double MOTION_MULTIPLIER = (double)0.05f;
    private static final double MOTION_Y_MIN = (double)0.2f;

    private InventoryUtils() {
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Block block) {
        return InventoryUtils.filterItemHandler(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block)));
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        @NotNull ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue() || !itemStackSelectionPredicate.test(stack)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    private static boolean compareItems(@Nullable ItemStack itemStack, Item targetItem) {
        return ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() == targetItem;
    }

    public static Item getItemFromBlock(Block block) {
        return Item.func_150898_a((Block)block);
    }

    @NotNull
    public static List<ItemStack> filterItemHandler(@NotNull IItemHandler itemHandler, @NotNull Item targetItem) {
        return InventoryUtils.filterItemHandler(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Block block) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, InventoryUtils.getItemFromBlock(block));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Item targetItem) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int findFirstSlotInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemStackSelectionPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static boolean shrinkItemCountInItemHandler(IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        Predicate<ItemStack> predicate = ItemStackUtils.NOT_EMPTY_PREDICATE.and(itemStackSelectionPredicate);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!predicate.test(itemHandler.getStackInSlot(slot))) continue;
            itemHandler.getStackInSlot(slot).func_190918_g(1);
            return true;
        }
        return false;
    }

    public static List<Integer> findAllSlotsInItemHandlerWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemStackSelectionPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            returnList.add(slot);
        }
        return returnList;
    }

    public static int getItemCountInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Block block) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("getItemCountInItemHandler got a null itemHandler"));
        }
        return itemHandler == null ? 0 : InventoryUtils.getItemCountInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block));
    }

    public static int getItemCountInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Item targetItem) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("getItemCountInItemHandler got a null itemHandler"));
        }
        return itemHandler == null ? 0 : InventoryUtils.getItemCountInItemHandler(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int getItemCountInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("getItemCountInItemHandler got a null itemHandler"));
        }
        return itemHandler == null ? 0 : InventoryUtils.filterItemHandler(itemHandler, itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum();
    }

    public static int getItemCountInItemHandlers(@Nullable Collection<IItemHandler> itemHandlers, @NotNull Predicate<ItemStack> itemStackPredicate) {
        int count = 0;
        if (itemHandlers != null) {
            HashSet<ItemStack> itemSet = new HashSet<ItemStack>();
            for (IItemHandler handler : itemHandlers) {
                itemSet.addAll(InventoryUtils.filterItemHandler(handler, itemStackPredicate));
            }
            for (ItemStack stack : itemSet) {
                count += stack.func_190916_E();
            }
        }
        return count;
    }

    public static boolean hasItemInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Block block) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
        }
        return itemHandler != null && InventoryUtils.hasItemInItemHandler(itemHandler, InventoryUtils.getItemFromBlock(block));
    }

    public static boolean hasItemInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Item item) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
        }
        return itemHandler != null && InventoryUtils.hasItemInItemHandler(itemHandler, (ItemStack stack) -> InventoryUtils.compareItems(stack, item));
    }

    public static boolean hasItemInItemHandler(@Nullable IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
        }
        return itemHandler != null && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(itemHandler, itemStackSelectionPredicate) > -1;
    }

    public static boolean isItemHandlerFull(@Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
        }
        return itemHandler == null || InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler) == -1;
    }

    public static int getFirstOpenSlotFromItemHandler(@Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
            return -1;
        }
        return IntStream.range(0, itemHandler.getSlots()).filter(slot -> ItemStackUtils.isEmpty(itemHandler.getStackInSlot(slot))).findFirst().orElse(-1);
    }

    public static long openSlotCount(@Nullable IItemHandler itemHandler) {
        if (itemHandler == null) {
            Log.getLogger().error("This is not supposed to happen, please notify the developers!", (Throwable)new Exception("hasItemInItemHandler got a null itemHandler"));
            return 0L;
        }
        return IntStream.range(0, itemHandler.getSlots()).filter(slot -> ItemStackUtils.isEmpty(itemHandler.getStackInSlot(slot))).count();
    }

    @Nullable
    public static ItemStack forceItemStackToItemHandler(@NotNull IItemHandler itemHandler, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        ItemStack standardInsertionResult = InventoryUtils.addItemStackToItemHandlerWithResult(itemHandler, itemStack);
        if (!ItemStackUtils.isEmpty(standardInsertionResult).booleanValue()) {
            for (int i = 0; i < itemHandler.getSlots() && !ItemStackUtils.isEmpty(standardInsertionResult).booleanValue(); ++i) {
                ItemStack localStack = itemHandler.getStackInSlot(i);
                if (!ItemStackUtils.isEmpty(localStack).booleanValue() && itemStackToKeepPredicate.test(localStack)) continue;
                ItemStack removedStack = itemHandler.extractItem(i, Integer.MAX_VALUE, false);
                ItemStack localInsertionResult = itemHandler.insertItem(i, standardInsertionResult, false);
                if (ItemStackUtils.isEmpty(localInsertionResult).booleanValue()) {
                    return removedStack.func_77946_l();
                }
                itemHandler.insertItem(i, removedStack, false);
            }
        }
        return standardInsertionResult;
    }

    public static int getAmountOfStacksInItemHandler(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.getItemHandlerAsList(itemHandler).size();
    }

    @NotNull
    public static List<ItemStack> getItemHandlerAsList(@NotNull IItemHandler itemHandler) {
        return InventoryUtils.filterItemHandler(itemHandler, (ItemStack stack) -> true);
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, Block block) {
        return InventoryUtils.filterProvider(provider, (ItemStack stack) -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block)));
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getFromProviderForAllSides(provider, itemStackSelectionPredicate);
    }

    @NotNull
    private static List<ItemStack> getFromProviderForAllSides(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> predicate) {
        HashSet<ItemStack> combinedList = new HashSet<ItemStack>();
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            if (handler == null) continue;
            combinedList.addAll(InventoryUtils.filterItemHandler(handler, predicate));
        }
        return new ArrayList<ItemStack>(combinedList);
    }

    @NotNull
    public static Set<IItemHandler> getItemHandlersFromProvider(@NotNull ICapabilityProvider provider) {
        HashSet<IItemHandler> handlerList = new HashSet<IItemHandler>();
        for (Direction side : Direction.values()) {
            provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).ifPresent(handlerList::add);
        }
        provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handlerList::add);
        return handlerList;
    }

    @NotNull
    public static List<ItemStack> filterProvider(@NotNull ICapabilityProvider provider, @Nullable Item targetItem) {
        return InventoryUtils.filterProvider(provider, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Block block) {
        return InventoryUtils.findFirstSlotInProviderWith(provider, InventoryUtils.getItemFromBlock(block));
    }

    public static int findFirstSlotInProviderWith(@NotNull ICapabilityProvider provider, Item targetItem) {
        return InventoryUtils.findFirstSlotInProviderNotEmptyWith(provider, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static Map<IItemHandler, List<Integer>> findAllSlotsInProviderWith(@NotNull ICapabilityProvider provider, Predicate<ItemStack> itemStackSelectionPredicate) {
        HashMap<IItemHandler, List<Integer>> map = new HashMap<IItemHandler, List<Integer>>();
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            List<Integer> tempList = InventoryUtils.findAllSlotsInItemHandlerWith(handler, itemStackSelectionPredicate);
            if (tempList.isEmpty()) continue;
            map.put(handler, tempList);
        }
        return map;
    }

    public static int findFirstSlotInProviderNotEmptyWith(@NotNull ICapabilityProvider provider, Predicate<ItemStack> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStackSelectionPredicate);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int findFirstSlotInProviderNotEmptyWith(@NotNull ICapabilityProvider provider, List<Predicate<ItemStack>> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStackSelectionPredicate);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    private static int findFirstSlotInItemHandlerNotEmptyWith(IItemHandler itemHandler, List<Predicate<ItemStack>> itemStackSelectionPredicate) {
        for (Predicate<ItemStack> predicate : itemStackSelectionPredicate) {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                if (!ItemStackUtils.NOT_EMPTY_PREDICATE.and(predicate).test(itemHandler.getStackInSlot(slot))) continue;
                return slot;
            }
        }
        return -1;
    }

    public static int findFirstSlotInItemHandlerNotEmptyWith(@NotNull IItemHandler itemHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        @NotNull Predicate<ItemStack> firstWorthySlotPredicate = ItemStackUtils.NOT_EMPTY_PREDICATE.and(itemStackSelectionPredicate);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!firstWorthySlotPredicate.test(itemHandler.getStackInSlot(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Block block) {
        return InventoryUtils.getItemCountInProvider(provider, InventoryUtils.getItemFromBlock(block));
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Item targetItem) {
        return InventoryUtils.getItemCountInProvider(provider, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int getItemCountInProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().filter(Objects::nonNull).mapToInt(handler -> InventoryUtils.filterItemHandler(handler, itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum()).sum();
    }

    public static int getDurabilityInProvider(@NotNull ICapabilityProvider provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().filter(Objects::nonNull).mapToInt(handler -> InventoryUtils.filterItemHandler(handler, itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getDurability).sum()).sum();
    }

    public static int hasBuildingEnoughElseCount(@NotNull IBuilding provider, @NotNull ItemStorage stack, int count) {
        int totalCount = 0;
        World world = provider.getColony().getWorld();
        for (BlockPos pos : provider.getContainers()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityRack) {
                totalCount += ((TileEntityRack)entity).getCount(stack);
            } else if (entity instanceof ChestTileEntity) {
                totalCount += InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, (ItemStack itemStack) -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack.getItemStack(), !stack.ignoreDamageValue(), !stack.ignoreNBT()));
            }
            if (totalCount <= count) continue;
            return Integer.MAX_VALUE;
        }
        return totalCount;
    }

    public static int hasBuildingEnoughElseCount(@NotNull IBuilding provider, @NotNull Predicate<ItemStack> stack, int count) {
        int totalCount = 0;
        World world = provider.getColony().getWorld();
        for (BlockPos pos : provider.getContainers()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityRack) {
                totalCount += ((TileEntityRack)entity).getItemCount(stack);
            }
            if (totalCount <= count) continue;
            return Integer.MAX_VALUE;
        }
        return totalCount;
    }

    public static int getCountFromBuilding(@NotNull IBuilding provider, @NotNull List<ItemStorage> stacks) {
        int totalCount = 0;
        for (ItemStorage stack : stacks) {
            totalCount += InventoryUtils.getCountFromBuilding(provider, stack);
        }
        return totalCount;
    }

    public static int getCountFromBuilding(@NotNull IBuilding provider, @NotNull ItemStorage stack) {
        int totalCount = 0;
        World world = provider.getColony().getWorld();
        for (BlockPos pos : provider.getContainers()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityRack) {
                totalCount += ((TileEntityRack)entity).getCount(stack);
                continue;
            }
            if (!(entity instanceof ChestTileEntity)) continue;
            totalCount += InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, (ItemStack itemStack) -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack.getItemStack()));
        }
        return totalCount;
    }

    public static int countEmptySlotsInBuilding(IBuilding ownBuilding) {
        int totalCount = 0;
        World world = ownBuilding.getColony().getWorld();
        for (BlockPos pos : ownBuilding.getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof TileEntityRack)) continue;
            totalCount += ((TileEntityRack)entity).getFreeSlots();
        }
        return totalCount;
    }

    public static int getCountFromBuilding(@NotNull IBuilding provider, @NotNull Predicate<ItemStack> predicate) {
        int totalCount = 0;
        World world = provider.getColony().getWorld();
        for (BlockPos pos : provider.getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof TileEntityRack)) continue;
            totalCount += ((TileEntityRack)entity).getItemCount(predicate);
        }
        return totalCount;
    }

    public static int getCountFromBuildingWithLimit(@NotNull IBuilding provider, @NotNull Predicate<ItemStack> predicate, Function<ItemStack, Integer> limit) {
        World world = provider.getColony().getWorld();
        HashMap<ItemStorage, Integer> allMatching = new HashMap<ItemStorage, Integer>();
        for (BlockPos pos : provider.getContainers()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof TileEntityRack)) continue;
            for (Map.Entry<ItemStorage, Integer> entry : ((TileEntityRack)entity).getAllContent().entrySet()) {
                if (!predicate.test(entry.getKey().getItemStack())) continue;
                allMatching.put(entry.getKey(), allMatching.getOrDefault(entry.getKey(), 0) + entry.getValue());
            }
        }
        int totalCount = 0;
        for (Map.Entry entry : allMatching.entrySet()) {
            totalCount += Math.min(limit.apply(((ItemStorage)entry.getKey()).getItemStack()), (Integer)entry.getValue());
        }
        return totalCount;
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Block block) {
        return InventoryUtils.hasItemInProvider(Provider, InventoryUtils.getItemFromBlock(block));
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Item item) {
        return InventoryUtils.hasItemInProvider(Provider, (ItemStack stack) -> InventoryUtils.compareItems(stack, item));
    }

    public static boolean hasItemInProvider(@NotNull ICapabilityProvider Provider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(Provider)) {
            if (InventoryUtils.findFirstSlotInItemHandlerWith(handler, itemStackSelectionPredicate) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getFirstOpenSlotFromProvider(provider) == -1;
    }

    public static int getFirstOpenSlotFromProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().mapToInt(InventoryUtils::getFirstOpenSlotFromItemHandler).filter(slotIndex -> slotIndex > -1).findFirst().orElse(-1);
    }

    public static boolean isToolInProvider(@NotNull ICapabilityProvider provider, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.hasItemInProvider(provider, (ItemStack stack) -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static boolean addItemStackToProvider(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        return InventoryUtils.getItemHandlersFromProvider(provider).stream().anyMatch(handler -> InventoryUtils.addItemStackToItemHandler(handler, itemStack));
    }

    public static boolean addItemStackToItemHandler(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (itemHandler.getSlots() == 0) {
            return false;
        }
        if (!ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack, false);
                    return true;
                }
                return false;
            }
            ItemStack resultStack = itemStack.func_77946_l();
            boolean placed = false;
            for (slot = 0; !ItemStackUtils.isEmpty(resultStack).booleanValue() && slot < itemHandler.getSlots(); ++slot) {
                if (!ItemStackUtils.isEmpty(resultStack = itemHandler.insertItem(slot, resultStack, true)).booleanValue()) continue;
                placed = true;
                break;
            }
            if (!placed) {
                return false;
            }
            resultStack = itemStack;
            for (slot = 0; !ItemStackUtils.isEmpty(resultStack).booleanValue() && slot < itemHandler.getSlots(); ++slot) {
                if (!ItemStackUtils.isEmpty(resultStack = itemHandler.insertItem(slot, resultStack, false)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static ItemStack addItemStackToProviderWithResult(@NotNull ICapabilityProvider provider, @Nullable ItemStack itemStack) {
        ItemStack activeStack = itemStack;
        if (ItemStackUtils.isEmpty(activeStack).booleanValue()) {
            return ItemStackUtils.EMPTY;
        }
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            activeStack = InventoryUtils.addItemStackToItemHandlerWithResult(handler, activeStack);
        }
        return activeStack;
    }

    public static ItemStack addItemStackToItemHandlerWithResult(@NotNull IItemHandler itemHandler, @Nullable ItemStack itemStack) {
        if (!ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            int slot;
            if (itemStack.func_77951_h()) {
                int slot2 = InventoryUtils.getFirstOpenSlotFromItemHandler(itemHandler);
                if (slot2 >= 0) {
                    itemHandler.insertItem(slot2, itemStack.func_77946_l(), false);
                    return ItemStackUtils.EMPTY;
                }
                return itemStack;
            }
            ItemStack leftOver = itemStack;
            int n = slot = itemHandler.getSlots() == 0 ? -1 : 0;
            while (!ItemStackUtils.isEmpty(leftOver).booleanValue() && slot != -1 && slot != itemHandler.getSlots()) {
                if (ItemStackUtils.isEmpty(leftOver = itemHandler.insertItem(slot, leftOver.func_77946_l(), false)).booleanValue()) continue;
                ++slot;
            }
            return leftOver;
        }
        return itemStack;
    }

    @Nullable
    public static ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack, @NotNull Predicate<ItemStack> itemStackToKeepPredicate) {
        ItemStack standardInsertionResult = InventoryUtils.addItemStackToProviderWithResult(provider, itemStack);
        if (!ItemStackUtils.isEmpty(standardInsertionResult).booleanValue()) {
            ItemStack resultStack = standardInsertionResult.func_77946_l();
            Iterator<IItemHandler> iterator = InventoryUtils.getItemHandlersFromProvider(provider).iterator();
            while (iterator.hasNext() && !ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack = InventoryUtils.forceItemStackToItemHandler(iterator.next(), resultStack, itemStackToKeepPredicate);
            }
            return resultStack;
        }
        return ItemStackUtils.EMPTY;
    }

    public static int getAmountOfStacksInProvider(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getProviderAsList(provider).size();
    }

    @NotNull
    public static List<ItemStack> getProviderAsList(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.filterProvider(provider, (ItemStack stack) -> true);
    }

    @NotNull
    public static boolean hasProviderIItemHandler(@NotNull ICapabilityProvider provider) {
        return !InventoryUtils.getItemHandlersFromProvider(provider).isEmpty();
    }

    @NotNull
    public static boolean isProviderSided(@NotNull ICapabilityProvider provider) {
        return InventoryUtils.getItemHandlersFromProvider(provider).size() > 1;
    }

    @NotNull
    public static List<ItemStack> getInventoryAsListFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), (ItemStack stack) -> true);
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Block block) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), (ItemStack stack) -> InventoryUtils.compareItems(stack, InventoryUtils.getItemFromBlock(block)));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Item targetItem, int itemDamage) {
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    @NotNull
    public static List<ItemStack> filterItemHandlerFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return Collections.emptyList();
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), itemStackSelectionPredicate);
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, InventoryUtils.getItemFromBlock(block));
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Item targetItem) {
        return InventoryUtils.findFirstSlotInProviderForSideWith(provider, facing, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int findFirstSlotInProviderForSideWith(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return -1;
        }
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), itemStackSelectionPredicate);
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Block block) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block));
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Item targetItem) {
        return InventoryUtils.getItemCountInProviderForSide(provider, facing, (ItemStack stack) -> InventoryUtils.compareItems(stack, targetItem));
    }

    public static int getItemCountInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return 0;
        }
        return InventoryUtils.filterItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), itemStackSelectionPredicate).stream().mapToInt(ItemStackUtils::getSize).sum();
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Block block) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, InventoryUtils.getItemFromBlock(block));
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Item item) {
        return InventoryUtils.hasItemInProviderForSide(provider, facing, (ItemStack stack) -> InventoryUtils.compareItems(stack, item));
    }

    public static boolean hasItemInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return false;
        }
        return InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), itemStackSelectionPredicate) > -1;
    }

    public static boolean isProviderFull(@NotNull ICapabilityProvider provider, @Nullable Direction facing) {
        return InventoryUtils.getFirstOpenSlotFromProviderForSide(provider, facing) == -1;
    }

    public static int getFirstOpenSlotFromProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return -1;
        }
        return InventoryUtils.getFirstOpenSlotFromItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null));
    }

    public static boolean isToolInProviderForSide(@NotNull ICapabilityProvider provider, @Nullable Direction facing, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        if (!provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            return false;
        }
        return InventoryUtils.isToolInItemHandler((IItemHandler)provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).orElse(null), toolType, minimalLevel, maximumLevel);
    }

    public static boolean isToolInItemHandler(@NotNull IItemHandler itemHandler, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.hasItemInItemHandler(itemHandler, (ItemStack stack) -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static void clearItemHandler(@NotNull IItemHandler itemHandler) {
        for (int slotIndex = 0; slotIndex < itemHandler.getSlots(); ++slotIndex) {
            itemHandler.extractItem(slotIndex, Integer.MAX_VALUE, false);
        }
    }

    public static int getFirstSlotOfItemHandlerContainingTool(@NotNull IItemHandler itemHandler, @NotNull IToolType toolType, int minimalLevel, int maximumLevel) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, (ItemStack stack) -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, maximumLevel));
    }

    public static boolean hasItemHandlerToolWithLevel(@NotNull IItemHandler itemHandler, IToolType toolType, int requiredLevel, int maximumLevel) {
        return InventoryUtils.findFirstSlotInItemHandlerWith(itemHandler, (ItemStack stack) -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.isTool(stack, toolType) && ItemStackUtils.verifyToolLevel(stack, ItemStackUtils.getMiningLevel(stack, toolType), requiredLevel, maximumLevel)) > -1;
    }

    public static boolean transferItemStackIntoNextFreeSlotInProvider(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull ICapabilityProvider targetProvider) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(targetProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(sourceHandler, sourceIndex, handler)) continue;
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextFreeSlotInItemHandler(@NotNull IItemHandler sourceHandler, int sourceIndex, @NotNull IItemHandler targetHandler) {
        int i;
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return true;
        }
        boolean success = false;
        for (i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, true)).booleanValue()) continue;
            success = true;
            break;
        }
        if (!success) {
            return false;
        }
        sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
        for (i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return true;
        }
        sourceHandler.insertItem(sourceIndex, sourceStack, false);
        return false;
    }

    public static boolean transferXOfItemStackIntoNextFreeSlotInItemHandler(@NotNull IItemHandler sourceHandler, int sourceIndex, int count, @NotNull IItemHandler targetHandler) {
        int i;
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, count, true);
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return true;
        }
        boolean success = false;
        for (i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, true)).booleanValue()) continue;
            success = true;
            break;
        }
        if (!success) {
            return false;
        }
        sourceStack = sourceHandler.extractItem(sourceIndex, count, false);
        for (i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return true;
        }
        sourceHandler.insertItem(sourceIndex, sourceStack, false);
        return false;
    }

    public static boolean transferItemStackIntoNextBestSlotInItemHandler(@NotNull IItemHandler sourceHandler, int sourceIndex, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return true;
        }
        if (InventoryUtils.addItemStackToItemHandler(targetHandler, sourceStack)) {
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextBestSlotInItemHandler(@NotNull IItemHandler sourceHandler, Predicate<ItemStack> predicate, @NotNull IItemHandler targetHandler) {
        for (int i = 0; i < sourceHandler.getSlots(); ++i) {
            ItemStack sourceStack;
            if (!predicate.test(sourceHandler.getStackInSlot(i)) || (sourceStack = sourceHandler.extractItem(i, Integer.MAX_VALUE, true)).func_190926_b() || !InventoryUtils.addItemStackToItemHandler(targetHandler, sourceStack)) continue;
            sourceHandler.extractItem(i, Integer.MAX_VALUE, false);
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextBestSlotInItemHandler(ItemStack stack, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferItemStackIntoNextBestSlotInItemHandlerWithResult(stack, targetHandler).func_190926_b();
    }

    public static ItemStack transferItemStackIntoNextBestSlotInItemHandlerWithResult(ItemStack stack, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = stack.func_77946_l();
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return sourceStack;
        }
        if (ItemStackUtils.isEmpty(sourceStack = InventoryUtils.mergeItemStackIntoNextBestSlotInItemHandlers(sourceStack, targetHandler)).booleanValue()) {
            return sourceStack;
        }
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (!ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return sourceStack;
        }
        return sourceStack;
    }

    public static void mergeItemStackIntoNextBestSlotInItemHandlers(@NotNull IItemHandler sourceHandler, int sourceIndex, @NotNull IItemHandler targetHandler) {
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        int amount = sourceStack.func_190916_E();
        if (ItemStackUtils.isEmpty(sourceStack).booleanValue()) {
            return;
        }
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (ItemStackUtils.isEmpty(targetHandler.getStackInSlot(i)).booleanValue() || !ItemStackUtils.compareItemStacksIgnoreStackSize(targetHandler.getStackInSlot(i), sourceStack).booleanValue() || !ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            return;
        }
        sourceHandler.extractItem(sourceIndex, amount - sourceStack.func_190916_E(), false);
    }

    public static ItemStack mergeItemStackIntoNextBestSlotInItemHandlers(ItemStack stack, @NotNull IItemHandler targetHandler) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return stack;
        }
        ItemStack sourceStack = stack.func_77946_l();
        for (int i = 0; i < targetHandler.getSlots(); ++i) {
            if (ItemStackUtils.isEmpty(targetHandler.getStackInSlot(i)).booleanValue() || !ItemStackUtils.compareItemStacksIgnoreStackSize(targetHandler.getStackInSlot(i), sourceStack).booleanValue() || !ItemStackUtils.isEmpty(sourceStack = targetHandler.insertItem(i, sourceStack, false)).booleanValue()) continue;
            return sourceStack;
        }
        return sourceStack;
    }

    public static boolean transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProvider(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull ICapabilityProvider targetProvider) {
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProviderWithResult(sourceProvider, itemStackSelectionPredicate, amount, targetProvider) == 0;
    }

    public static int transferXOfFirstSlotInProviderWithIntoNextFreeSlotInProviderWithResult(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, @NotNull int amount, @NotNull ICapabilityProvider targetProvider) {
        int currentAmount = amount;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(targetProvider)) {
            currentAmount = InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(sourceProvider, itemStackSelectionPredicate, amount, handler);
            if (currentAmount > 0) continue;
            return 0;
        }
        return currentAmount;
    }

    public static boolean transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(sourceProvider, itemStackSelectionPredicate, amount, targetHandler) == 0;
    }

    public static int transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult(@NotNull ICapabilityProvider sourceProvider, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount, @NotNull IItemHandler targetHandler) {
        int currentAmount = amount;
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            currentAmount = InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(handler, itemStackSelectionPredicate, currentAmount, targetHandler);
            if (currentAmount > 0) continue;
            return 0;
        }
        return currentAmount;
    }

    public static boolean transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandler(@NotNull IItemHandler sourceHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount, @NotNull IItemHandler targetHandler) {
        return InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(sourceHandler, itemStackSelectionPredicate, amount, targetHandler) == 0;
    }

    public static int transferXOfFirstSlotInItemHandlerWithIntoNextFreeSlotInItemHandlerWithResult(@NotNull IItemHandler sourceHandler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount, @NotNull IItemHandler targetHandler) {
        int currentAmount = amount;
        for (int slot = 0; currentAmount > 0 && slot < sourceHandler.getSlots(); ++slot) {
            int desiredItemSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(sourceHandler, itemStackSelectionPredicate::test);
            if (desiredItemSlot == -1) {
                return currentAmount;
            }
            ItemStack returnStack = sourceHandler.extractItem(desiredItemSlot, currentAmount, false);
            if (ItemStackUtils.isEmpty(returnStack).booleanValue()) continue;
            if (!InventoryUtils.addItemStackToItemHandler(targetHandler, returnStack)) {
                sourceHandler.insertItem(desiredItemSlot, returnStack, false);
                break;
            }
            currentAmount -= returnStack.func_190916_E();
        }
        return currentAmount;
    }

    public static int transferXInItemHandlerIntoSlotInItemHandler(IItemHandler sourceHandler, Predicate<ItemStack> itemStackSelectionPredicate, int amount, IItemHandler targetHandler, int slot) {
        int actualTransferred;
        int transferred;
        for (actualTransferred = 0; actualTransferred < amount && (transferred = InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler(sourceHandler, itemStackSelectionPredicate, amount - actualTransferred, targetHandler, slot)) > 0; actualTransferred += transferred) {
        }
        return actualTransferred;
    }

    public static int transferXOfFirstSlotInItemHandlerWithIntoInItemHandler(IItemHandler sourceHandler, Predicate<ItemStack> itemStackSelectionPredicate, int amount, IItemHandler targetHandler, int slot) {
        int desiredItemSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(sourceHandler, itemStackSelectionPredicate);
        if (desiredItemSlot == -1) {
            return 0;
        }
        ItemStack returnStack = sourceHandler.extractItem(desiredItemSlot, amount, false);
        if (ItemStackUtils.isEmpty(returnStack).booleanValue()) {
            return 0;
        }
        ItemStack insertResult = targetHandler.insertItem(slot, returnStack, false);
        if (!ItemStackUtils.isEmpty(insertResult).booleanValue()) {
            sourceHandler.insertItem(desiredItemSlot, insertResult, false);
            return returnStack.func_190916_E() - insertResult.func_190916_E();
        }
        return returnStack.func_190916_E();
    }

    public static boolean transferItemStackIntoNextFreeSlotFromProvider(@NotNull ICapabilityProvider sourceProvider, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(handler, sourceIndex, targetHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextFreeSlotFromItemHandler(@NotNull IItemHandler handler, @NotNull Predicate<ItemStack> stackPredicate, int count, @NotNull IItemHandler targetHandler) {
        int totalCount = count;
        int index = InventoryUtils.findFirstSlotInItemHandlerWith(handler, stackPredicate);
        while (index != -1) {
            int localCount = Math.min(totalCount, handler.getStackInSlot(index).func_190916_E());
            if (InventoryUtils.transferXOfItemStackIntoNextFreeSlotInItemHandler(handler, index, localCount, targetHandler)) {
                totalCount -= localCount;
            }
            if (totalCount <= 0) {
                return true;
            }
            index = InventoryUtils.findFirstSlotInItemHandlerWith(handler, stackPredicate);
        }
        return false;
    }

    public static boolean transferXOfItemStackIntoNextFreeSlotFromProvider(@NotNull ICapabilityProvider sourceProvider, int sourceIndex, int count, @NotNull IItemHandler targetHandler) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            if (!InventoryUtils.transferXOfItemStackIntoNextFreeSlotInItemHandler(handler, sourceIndex, count, targetHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean transferItemStackIntoNextBestSlotFromProvider(@NotNull ICapabilityProvider sourceProvider, int sourceIndex, @NotNull IItemHandler targetHandler) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(sourceProvider)) {
            if (!InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(handler, sourceIndex, targetHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean swapItemStacksInItemHandlers(@NotNull IItemHandler sourceHandler, @NotNull int sourceIndex, @NotNull IItemHandler targetHandler, @NotNull int targetIndex) {
        ItemStack targetStack = targetHandler.extractItem(targetIndex, Integer.MAX_VALUE, false);
        ItemStack sourceStack = sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, true);
        ItemStack resultSourceSimulationInsertion = targetHandler.insertItem(targetIndex, sourceStack, true);
        if (ItemStackUtils.isEmpty(resultSourceSimulationInsertion).booleanValue() || ItemStackUtils.isEmpty(targetStack).booleanValue()) {
            targetHandler.insertItem(targetIndex, sourceStack, false);
            sourceHandler.extractItem(sourceIndex, Integer.MAX_VALUE, false);
            sourceHandler.insertItem(sourceIndex, targetStack, false);
            return true;
        }
        targetHandler.insertItem(targetIndex, targetStack, false);
        return false;
    }

    public static boolean removeStacksFromProvider(ICapabilityProvider provider, List<ItemStack> input) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            if (InventoryUtils.removeStacksFromItemHandler(handler, input)) continue;
            return false;
        }
        return true;
    }

    public static boolean removeStacksFromItemHandler(IItemHandler handler, List<ItemStack> input) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int maxTries = 0;
        for (ItemStack stack : input) {
            maxTries += ItemStackUtils.getSize(stack);
            list.add(stack.func_77946_l());
        }
        boolean success = true;
        int i = 0;
        int tries = 0;
        while (i < list.size() && tries < maxTries) {
            ItemStack stack = (ItemStack)list.get(i);
            int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, (ItemStack lStack) -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, lStack));
            if (slot == -1) {
                success = false;
                ++i;
                continue;
            }
            int removedSize = ItemStackUtils.getSize(handler.extractItem(slot, ItemStackUtils.getSize(stack), false));
            if (removedSize == ItemStackUtils.getSize(stack)) {
                ++i;
            } else {
                ItemStackUtils.changeSize(stack, -removedSize);
            }
            ++tries;
        }
        return success && i >= list.size();
    }

    public static boolean tryRemoveStackFromItemHandler(IItemHandler handler, ItemStack input) {
        int amount = input.func_190916_E();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(handler.getStackInSlot(i), input).booleanValue() || (amount -= handler.extractItem(i, amount, false).func_190916_E()) != 0) continue;
            return true;
        }
        ItemStack revertStack = input.func_77946_l();
        revertStack.func_190920_e(input.func_190916_E() - amount);
        InventoryUtils.addItemStackToItemHandler(handler, revertStack);
        return false;
    }

    public static void removeStackFromItemHandler(IItemHandler handler, ItemStack input, int count) {
        ItemStack workingStack = input.func_77946_l();
        int localCount = count;
        for (int tries = 0; tries < count; ++tries) {
            int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, (ItemStack stack) -> ItemStackUtils.compareItemStacksIgnoreStackSize(workingStack, stack));
            if (slot == -1) {
                return;
            }
            int removedSize = ItemStackUtils.getSize(handler.extractItem(slot, localCount, false));
            if (removedSize == count) {
                return;
            }
            localCount -= removedSize;
        }
    }

    public static int findSlotInProviderNotFullWithItem(ICapabilityProvider provider, Item item, int amount) {
        for (IItemHandler handler : InventoryUtils.getItemHandlersFromProvider(provider)) {
            int foundSlot = InventoryUtils.findSlotInItemHandlerNotFullWithItem(handler, stack -> InventoryUtils.compareItems(stack, item), amount);
            if (foundSlot <= -1) continue;
            return foundSlot;
        }
        return -1;
    }

    public static int findSlotInItemHandlerNotFullWithItem(IItemHandler handler, @NotNull Predicate<ItemStack> itemStackSelectionPredicate, int amount) {
        boolean foundEmptySlot = false;
        boolean foundItem = false;
        int itemSlot = -1;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                foundEmptySlot = true;
            } else if (itemStackSelectionPredicate.test(stack)) {
                if (ItemStackUtils.getSize(stack) + amount <= stack.func_77976_d()) {
                    foundEmptySlot = true;
                }
                foundItem = true;
                itemSlot = slot;
            }
            if (!foundItem || !foundEmptySlot) continue;
            return itemSlot;
        }
        return -1;
    }

    public static boolean findSlotInItemHandlerNotFullWithItem(IItemHandler handler, ItemStack inStack) {
        if (handler == null) {
            return false;
        }
        boolean foundEmptySlot = false;
        boolean foundItem = false;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                foundEmptySlot = true;
            } else if (InventoryUtils.compareItems(stack, inStack.func_77973_b())) {
                if (ItemStackUtils.getSize(stack) + ItemStackUtils.getSize(inStack) <= stack.func_77976_d()) {
                    foundEmptySlot = true;
                }
                foundItem = true;
            }
            if (!foundItem || !foundEmptySlot) continue;
            return true;
        }
        return false;
    }

    public static void dropItemHandler(IItemHandler handler, World world, int x, int y, int z) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (itemstack == null) continue;
            InventoryUtils.spawnItemStack(world, x, y, z, itemstack);
        }
    }

    public static boolean transferAllItemHandler(IItemHandler origin, IItemHandler target) {
        for (int i = 0; i < origin.getSlots(); ++i) {
            ItemStack itemStack = origin.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(itemStack).booleanValue()) continue;
            if (InventoryUtils.addItemStackToItemHandler(target, itemStack)) {
                InventoryUtils.removeStackFromItemHandler(origin, itemStack, itemStack.func_190916_E());
                continue;
            }
            return false;
        }
        return true;
    }

    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        Random random = new Random();
        double spawnX = random.nextDouble() * 0.8 + 0.1;
        double spawnY = random.nextDouble() * 0.8 + 0.1;
        double spawnZ = random.nextDouble() * 0.8 + 0.1;
        while (stack.func_190916_E() > 0) {
            int randomSplitStackSize = random.nextInt(21) + 10;
            ItemEntity ItemEntity2 = new ItemEntity(worldIn, x + spawnX, y + spawnY, z + spawnZ, stack.func_77979_a(randomSplitStackSize));
            ItemEntity2.func_213293_j(random.nextGaussian() * (double)0.05f, random.nextGaussian() * (double)0.05f + (double)0.2f, random.nextGaussian() * (double)0.05f);
            worldIn.func_217376_c((Entity)ItemEntity2);
        }
    }

    public static int getItemCountInStackLick(@NotNull List<ItemStack> stacks, @NotNull Predicate<ItemStack> stackPredicate) {
        return stacks.stream().filter(ItemStackUtils::isNotEmpty).filter(stackPredicate).mapToInt(ItemStackUtils::getSize).sum();
    }

    public static boolean areAllItemsInItemHandler(@NotNull List<ItemStack> stacks, @NotNull IItemHandler handler) {
        return InventoryUtils.areAllItemsInItemHandlerList(stacks, (Collection<IItemHandler>)ImmutableList.of((Object)handler));
    }

    public static boolean areAllItemsInProvider(@NotNull List<ItemStack> stacks, @NotNull ICapabilityProvider provider) {
        return InventoryUtils.areAllItemsInItemHandlerList(stacks, InventoryUtils.getItemHandlersFromProvider(provider));
    }

    public static boolean areAllItemsInItemHandlerList(@NotNull List<ItemStack> stacks, @NotNull Collection<IItemHandler> handlers) {
        if (stacks.isEmpty()) {
            return true;
        }
        if (handlers.isEmpty()) {
            return false;
        }
        Map<ItemStack, Integer> requiredCountForStacks = InventoryUtils.getMergedCountedStacksFromList(stacks);
        return requiredCountForStacks.keySet().stream().allMatch(itemStack -> {
            int countInHandlerList = handlers.stream().mapToInt(handler -> InventoryUtils.getItemCountInItemHandler(handler, (ItemStack itemStack1) -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, itemStack1))).sum();
            return countInHandlerList >= (Integer)requiredCountForStacks.get(itemStack);
        });
    }

    public static Map<ItemStack, Integer> getMergedCountedStacksFromList(@NotNull List<ItemStack> stacks) {
        HashMap requiredCountForStacks = Maps.newHashMap();
        stacks.forEach(targetStack -> {
            Optional<ItemStack> alreadyContained = requiredCountForStacks.keySet().stream().filter(itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, targetStack)).findFirst();
            if (alreadyContained.isPresent()) {
                requiredCountForStacks.put(alreadyContained.get(), (Integer)requiredCountForStacks.get(alreadyContained.get()) + targetStack.func_190916_E());
            } else {
                requiredCountForStacks.put(targetStack, targetStack.func_190916_E());
            }
        });
        return requiredCountForStacks;
    }

    public static List<ItemStack> splitMergedCountedStacksIntoMaxContentStacks(@NotNull Map<ItemStack, Integer> mergedCountedStacks) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<ItemStack, Integer> itemStackIntegerEntry : mergedCountedStacks.entrySet()) {
            int minimalFullStacks = itemStackIntegerEntry.getValue() / itemStackIntegerEntry.getKey().func_77976_d();
            int residualStackSize = itemStackIntegerEntry.getValue() % itemStackIntegerEntry.getKey().func_77976_d();
            for (int i = 0; i < minimalFullStacks; ++i) {
                ItemStack tobeAdded = itemStackIntegerEntry.getKey().func_77946_l();
                tobeAdded.func_190920_e(tobeAdded.func_77976_d());
                list.add(tobeAdded);
            }
            if (residualStackSize <= 0) continue;
            ItemStack tobeAdded = itemStackIntegerEntry.getKey().func_77946_l();
            tobeAdded.func_190920_e(residualStackSize);
            list.add(tobeAdded);
        }
        return list;
    }

    public static List<ItemStack> getContainedFromItemHandler(@NotNull List<ItemStack> stacks, @NotNull IItemHandler handler) {
        ArrayList result = Lists.newArrayList();
        Map<ItemStack, Integer> inputCounts = InventoryUtils.getMergedCountedStacksFromList(stacks);
        Map<ItemStack, Integer> inventoryCounts = InventoryUtils.getMergedCountedStacksFromList(InventoryUtils.getItemHandlerAsList(handler));
        HashMap<ItemStack, Integer> resultingContained = new HashMap<ItemStack, Integer>();
        inputCounts.forEach((itemStack, count) -> {
            int remainingCount = count;
            for (Map.Entry entry : inventoryCounts.entrySet()) {
                ItemStack containedStack = (ItemStack)entry.getKey();
                Integer containedCount = (Integer)entry.getValue();
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, containedStack).booleanValue()) continue;
                remainingCount -= containedCount.intValue();
            }
            if (remainingCount <= 0) {
                resultingContained.put((ItemStack)itemStack, (Integer)count);
            }
        });
        resultingContained.forEach((itemStack, count) -> {
            int fullStackCount = count / itemStack.func_77976_d();
            int missingPartialCount = count % itemStack.func_77976_d();
            for (int i = 0; i < fullStackCount; ++i) {
                ItemStack targetStack = itemStack.func_77946_l();
                targetStack.func_190920_e(targetStack.func_77976_d());
                result.add(targetStack);
            }
            if (missingPartialCount != 0) {
                ItemStack targetStack = itemStack.func_77946_l();
                targetStack.func_190920_e(missingPartialCount);
                result.add(targetStack);
            }
        });
        return result;
    }

    public static List<ItemStack> processItemStackListAndMerge(@NotNull List<ItemStack> stacks) {
        return InventoryUtils.splitMergedCountedStacksIntoMaxContentStacks(InventoryUtils.getMergedCountedStacksFromList(stacks));
    }

    public static boolean moveItemStacksWithPossibleSwap(@NotNull IItemHandler targetInventory, @NotNull Collection<IItemHandler> sourceInventories, @NotNull List<ItemStack> toSwap, @NotNull Predicate<ItemStack> toKeepInTarget) {
        if (targetInventory.getSlots() < toSwap.size()) {
            return false;
        }
        Predicate<ItemStack> wantToKeep = toKeepInTarget.or(stack -> ItemStackUtils.compareItemStackListIgnoreStackSize(toSwap, stack));
        Iterator<ItemStack> iterator = toSwap.iterator();
        if (iterator.hasNext()) {
            ItemStack itemStack = iterator.next();
            for (IItemHandler sourceInventory : sourceInventories) {
                ItemStack forcingResult;
                if (!InventoryUtils.tryRemoveStackFromItemHandler(sourceInventory, itemStack) || (forcingResult = InventoryUtils.forceItemStackToItemHandler(targetInventory, itemStack, wantToKeep)) == null || forcingResult.func_190926_b()) continue;
                InventoryUtils.addItemStackToItemHandler(sourceInventory, forcingResult);
            }
            return false;
        }
        return true;
    }

    public static void reduceStackInItemHandler(IItemHandler invWrapper, ItemStack itemStack) {
        InventoryUtils.reduceStackInItemHandler(invWrapper, itemStack, 1);
    }

    public static void reduceStackInItemHandler(IItemHandler invWrapper, ItemStack itemStack, int quantity) {
        for (int i = 0; i < invWrapper.getSlots(); ++i) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(invWrapper.getStackInSlot(i), itemStack).booleanValue()) continue;
            invWrapper.getStackInSlot(i).func_190918_g(quantity);
            return;
        }
    }

    public static boolean attemptReduceStackInItemHandler(IItemHandler invWrapper, ItemStack itemStack, int quantity) {
        return InventoryUtils.attemptReduceStackInItemHandler(invWrapper, itemStack, quantity, false, false);
    }

    public static boolean attemptReduceStackInItemHandler(IItemHandler invWrapper, ItemStack itemStack, int quantity, boolean ignoreDamage, boolean ignoreNBT) {
        if (InventoryUtils.getItemCountInItemHandler(invWrapper, (ItemStack stack) -> !stack.func_190926_b() && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack, !ignoreDamage, !ignoreNBT)) < quantity) {
            return false;
        }
        int qty = quantity;
        for (int i = 0; i < invWrapper.getSlots(); ++i) {
            ItemStack stack2 = invWrapper.getStackInSlot(i);
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack2, itemStack, !ignoreDamage, !ignoreNBT)) continue;
            if (stack2.func_190916_E() >= qty) {
                invWrapper.extractItem(i, qty, false);
                return true;
            }
            qty -= stack2.func_190916_E();
            invWrapper.extractItem(i, stack2.func_190916_E(), false);
        }
        return false;
    }

    public static Map<ItemStorage, ItemStorage> getAllItemsForProviders(ICapabilityProvider provider, IItemHandler ... handlers) {
        Set<IItemHandler> providerHandlers = InventoryUtils.getItemHandlersFromProvider(provider);
        if (handlers != null) {
            providerHandlers.addAll(Arrays.asList(handlers));
        }
        return InventoryUtils.getAllItemsForProviders(providerHandlers);
    }

    public static Map<ItemStorage, ItemStorage> getAllItemsForProviders(IItemHandler ... handlers) {
        return InventoryUtils.getAllItemsForProviders(new HashSet<IItemHandler>(Arrays.asList(handlers)));
    }

    public static Map<ItemStorage, ItemStorage> getAllItemsForProviders(Set<IItemHandler> handlerList) {
        HashMap<ItemStorage, ItemStorage> storageMap = new HashMap<ItemStorage, ItemStorage>();
        for (IItemHandler handler : handlerList) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack containedStack = handler.getStackInSlot(i);
                if (ItemStackUtils.isEmpty(containedStack).booleanValue()) continue;
                ItemStorage storage = new ItemStorage(containedStack.func_77946_l(), false, false);
                if (storageMap.containsKey(storage)) {
                    ItemStorage existing = (ItemStorage)storageMap.get(storage);
                    existing.setAmount(existing.getAmount() + storage.getAmount());
                    continue;
                }
                storageMap.put(storage, storage);
            }
        }
        return storageMap;
    }

    public static boolean doStorageSetsMatch(Map<ItemStorage, ItemStorage> first, Map<ItemStorage, ItemStorage> second, boolean showTrace) {
        ItemStorage compareStorage;
        for (ItemStorage storage : first.keySet()) {
            compareStorage = second.get(storage);
            if (compareStorage != null && storage.getAmount() == compareStorage.getAmount()) continue;
            if (showTrace) {
                Log.getLogger().warn("Possible inventory issue, not matching:", (Throwable)new Exception());
            }
            return false;
        }
        for (ItemStorage storage : second.keySet()) {
            compareStorage = first.get(storage);
            if (compareStorage != null && storage.getAmount() == compareStorage.getAmount()) continue;
            if (showTrace) {
                Log.getLogger().warn("Possible inventory issue, not matching:", (Throwable)new Exception());
            }
            return false;
        }
        return true;
    }

    public static boolean transferFoodUpToSaturation(ICapabilityProvider source, IItemHandler target, int requiredSaturation, Predicate<ItemStack> foodPredicate) {
        Set<IItemHandler> handlers = InventoryUtils.getItemHandlersFromProvider(source);
        int foundSaturation = 0;
        for (IItemHandler handler : handlers) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int slot;
                ItemStack extractedFood;
                Food itemFood;
                ItemStack stack = handler.getStackInSlot(i);
                if (ItemStackUtils.isEmpty(stack).booleanValue() || !foodPredicate.test(stack) || (itemFood = stack.func_77973_b().func_219967_s()) == null) continue;
                int amount = (int)Math.round(Math.ceil((float)(requiredSaturation - foundSaturation) / (float)itemFood.func_221466_a()));
                if (amount > stack.func_190916_E()) {
                    foundSaturation = (int)((float)foundSaturation + (float)stack.func_190916_E() * itemFood.func_221469_b());
                    extractedFood = handler.extractItem(i, stack.func_190916_E(), false);
                } else {
                    extractedFood = handler.extractItem(i, amount, false);
                    foundSaturation = requiredSaturation;
                }
                if (!ItemStackUtils.isEmpty(extractedFood).booleanValue() && !InventoryUtils.addItemStackToItemHandler(target, extractedFood) && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(target, (ItemStack s) -> !foodPredicate.test((ItemStack)s))) != -1) {
                    ItemStack swappedItem = target.extractItem(slot, target.getStackInSlot(slot).func_190916_E(), false);
                    InventoryUtils.addItemStackToProvider(source, swappedItem);
                    InventoryUtils.addItemStackToItemHandler(target, extractedFood);
                }
                if (foundSaturation < requiredSaturation) continue;
                return true;
            }
        }
        return foundSaturation > 0;
    }

    public static boolean putItemToHotbarAndSelectOrDrop(ItemStack itemStack, PlayerEntity player) {
        PlayerInventory playerInv = player.field_71071_by;
        int emptySlot = playerInv.func_70447_i();
        if (emptySlot == -1) {
            player.func_71019_a(itemStack, false);
            return false;
        }
        int hotbarSlot = playerInv.func_184433_k();
        ItemStack curHotbarItem = playerInv.func_70301_a(hotbarSlot);
        if (!curHotbarItem.func_190926_b()) {
            playerInv.func_70299_a(emptySlot, curHotbarItem);
        }
        playerInv.func_70299_a(hotbarSlot, itemStack);
        playerInv.field_70461_c = hotbarSlot;
        playerInv.func_70296_d();
        InventoryUtils.updateHeldItemFromServer(player);
        return true;
    }

    public static boolean putItemToHotbarAndSelectOrDropMessage(ItemStack itemStack, PlayerEntity player) {
        boolean result = InventoryUtils.putItemToHotbarAndSelectOrDrop(itemStack, player);
        if (!result) {
            MessageUtils.format((ITextComponent)itemStack.func_151000_E().func_230532_e_()).append("com.minecolonies.coremod.playerinvfull.hotbarinsert", new Object[0]).sendTo(player);
        }
        return result;
    }

    public static ItemStack getOrCreateItemAndPutToHotbarAndSelectOrDrop(Item item, PlayerEntity player, Supplier<ItemStack> itemStackFactory, boolean messageOnDrop) {
        PlayerInventory playerInv = player.field_71071_by;
        for (int slot = 0; slot < playerInv.field_70462_a.size(); ++slot) {
            ItemStack itemSlot = playerInv.func_70301_a(slot);
            if (itemSlot.func_77973_b() != item) continue;
            if (!PlayerInventory.func_184435_e((int)slot)) {
                playerInv.func_184430_d(slot);
            } else {
                playerInv.field_70461_c = slot;
            }
            playerInv.func_70296_d();
            InventoryUtils.updateHeldItemFromServer(player);
            return itemSlot;
        }
        ItemStack newItem = itemStackFactory.get();
        if (messageOnDrop) {
            InventoryUtils.putItemToHotbarAndSelectOrDropMessage(newItem, player);
        } else {
            InventoryUtils.putItemToHotbarAndSelectOrDrop(newItem, player);
        }
        return newItem;
    }

    private static void updateHeldItemFromServer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71133_b.func_184103_al().func_72385_f((ServerPlayerEntity)player);
        }
    }

    public static boolean hasEnoughInProvider(TileEntity entity, ItemStack stack, int count) {
        if (entity instanceof TileEntityColonyBuilding) {
            return InventoryUtils.hasBuildingEnoughElseCount(((TileEntityColonyBuilding)entity).getBuilding(), new ItemStorage(stack), stack.func_190916_E()) >= count;
        }
        if (entity instanceof TileEntityRack) {
            return ((TileEntityRack)entity).getCount(stack, false, false) >= count;
        }
        return InventoryUtils.getItemCountInProvider((ICapabilityProvider)entity, (ItemStack itemStack) -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, true)) >= count;
    }
}

