/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import org.jetbrains.annotations.NotNull;

public class BlockStateUtils {
    private static final Map<String, Property<?>> propertyBlockMap = new HashMap();

    private BlockStateUtils() {
    }

    public static boolean stateEqualsStateByBlockAndProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        if (state1.func_177230_c() != state2.func_177230_c()) {
            return false;
        }
        if (BlockStateUtils.stateEqualsStateInPropertyByName(state1, state2, propertyName)) {
            return true;
        }
        return state1 == state2;
    }

    public static boolean stateEqualsStateInPropertyByName(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        Property<?> propertyOne = BlockStateUtils.getPropertyByNameFromState(state1, propertyName);
        if (propertyOne != null && state2.func_235901_b_(propertyOne)) {
            return state1.func_177229_b(propertyOne) == state2.func_177229_b(propertyOne);
        }
        Property<?> propertyTwo = BlockStateUtils.getPropertyByNameFromState(state2, propertyName);
        if (propertyOne != null && propertyTwo != null && state1.func_235901_b_(propertyOne) && state2.func_235901_b_(propertyTwo)) {
            return state1.func_177229_b(propertyOne).toString().equals(state2.func_177229_b(propertyTwo).toString());
        }
        return false;
    }

    public static Property<?> getPropertyByNameFromState(@NotNull BlockState state, @NotNull String name) {
        Property<?> property = propertyBlockMap.get(state.func_177230_c().getRegistryName().toString() + ":" + name);
        if (property != null && state.func_235901_b_(property)) {
            return property;
        }
        property = BlockStateUtils.getPropertyByName(state.func_235904_r_(), name);
        if (property != null) {
            propertyBlockMap.put(state.func_177230_c().getRegistryName().toString() + ":" + name, property);
        }
        return property;
    }

    public static Property<?> getPropertyByName(@NotNull Collection<Property<?>> properties, @NotNull String name) {
        for (Property<?> tProperty : properties) {
            if (!tProperty.func_177701_a().equals(name)) continue;
            return tProperty;
        }
        return null;
    }

    public static <T extends Comparable<T>> boolean stateEqualsStateWithoutProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull Property<T> prop) {
        if (!state1.func_235901_b_(prop) || !state2.func_235901_b_(prop)) {
            return state1 == state2;
        }
        return state1.func_206870_a(prop, state2.func_177229_b(prop)) == state2;
    }

    public static boolean stateEqualsStateInBlockAndProp(BlockState state1, BlockState state2) {
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1.func_177230_c() != state2.func_177230_c()) {
            return false;
        }
        if (state1.func_235904_r_().size() != state2.func_235904_r_().size()) {
            return false;
        }
        for (Property prop : state1.func_235904_r_()) {
            if (!state2.func_235901_b_(prop)) {
                return false;
            }
            if (state1.func_177229_b(prop) == state2.func_177229_b(prop)) continue;
            return false;
        }
        return true;
    }
}

