/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCraftingType<C extends IInventory, T extends IRecipe<C>>
extends CraftingType {
    private final IRecipeType<T> recipeType;
    private final Predicate<IRecipe<C>> predicate;

    public RecipeCraftingType(@NotNull ResourceLocation id, @NotNull IRecipeType<T> recipeType, @Nullable Predicate<IRecipe<C>> predicate) {
        super(id);
        this.recipeType = recipeType;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable World world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (IRecipe recipe : recipeManager.func_215366_a(this.recipeType).values()) {
            if (this.predicate != null && !this.predicate.test(recipe)) continue;
            RecipeCraftingType.tryAddingVanillaRecipe(recipes, recipe, world);
        }
        return recipes;
    }

    private static void tryAddingVanillaRecipe(@NotNull List<IGenericRecipe> recipes, @NotNull IRecipe<?> recipe, @Nullable World world) {
        if (recipe.func_77571_b().func_190926_b()) {
            return;
        }
        try {
            IGenericRecipe genericRecipe = GenericRecipe.of(recipe, world);
            if (genericRecipe == null || genericRecipe.getInputs().isEmpty()) {
                return;
            }
            recipes.add(genericRecipe);
        }
        catch (Exception ex) {
            Log.getLogger().warn("Error evaluating recipe " + recipe.func_199560_c() + "; ignoring.", (Throwable)ex);
        }
    }
}

