/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.CountedIngredient;
import com.minecolonies.api.items.ModItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompostRecipe
implements IRecipe<IInventory> {
    public static final ResourceLocation ID = new ResourceLocation("minecolonies", "composting");
    public static final IRecipeType<CompostRecipe> TYPE = IRecipeType.func_222147_a((String)ID.toString());
    private static final int FERMENT_TIME = 24000;
    private static final int COMPOST_RESULT = 6;
    private final ResourceLocation id;
    private final Ingredient input;
    private final ItemStack output;
    private final int strength;

    public CompostRecipe(@NotNull ResourceLocation id, @NotNull Ingredient ingredient, int strength) {
        this.id = id;
        this.input = ingredient;
        this.strength = strength;
        this.output = new ItemStack((IItemProvider)ModItems.compost, 6);
    }

    @NotNull
    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    @NotNull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getFermentTime() {
        return 24000;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return false;
    }

    @NotNull
    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @NotNull
    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.getInstance();
    }

    @NotNull
    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)new CountedIngredient(this.input, this.calculateIngredientCount()));
        return ingredients;
    }

    private int calculateIngredientCount() {
        return 64 / this.strength;
    }

    @NotNull
    public static CompostRecipe individualize(@NotNull Item item, @NotNull CompostRecipe recipe) {
        return new CompostRecipe(recipe.func_199560_c(), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), recipe.getStrength());
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CompostRecipe> {
        private static final Serializer INSTANCE = new Serializer();

        public static Serializer getInstance() {
            return INSTANCE;
        }

        private Serializer() {
        }

        @NotNull
        public CompostRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("input"));
            int strength = JSONUtils.func_151208_a((JsonObject)json, (String)"strength", (int)1);
            return new CompostRecipe(recipeId, ingredient, strength);
        }

        @Nullable
        public CompostRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int strength = buffer.func_150792_a();
            return new CompostRecipe(recipeId, ingredient, strength);
        }

        public void toNetwork(@NotNull PacketBuffer buffer, @NotNull CompostRecipe recipe) {
            recipe.getInput().func_199564_a(buffer);
            buffer.func_150787_b(recipe.getStrength());
        }
    }
}

