/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.splitting;

import com.google.common.cache.Cache;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.NetworkChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SplitPacketMessage
implements IMessage {
    private int communicationId = -1;
    private int packetIndex = -1;
    private boolean terminator = false;
    private int innerMessageId = -1;
    private byte[] payload;

    public SplitPacketMessage() {
    }

    public SplitPacketMessage(int communicationId, int packetIndex, boolean terminator, int innerMessageId, byte[] payload) {
        this.communicationId = communicationId;
        this.packetIndex = packetIndex;
        this.terminator = terminator;
        this.innerMessageId = innerMessageId;
        this.payload = payload;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.communicationId);
        buf.func_150787_b(this.packetIndex);
        buf.writeBoolean(this.terminator);
        buf.func_150787_b(this.innerMessageId);
        buf.func_179250_a(this.payload);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.communicationId = buf.func_150792_a();
        this.packetIndex = buf.func_150792_a();
        this.terminator = buf.readBoolean();
        this.innerMessageId = buf.func_150792_a();
        this.payload = buf.func_179251_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        try {
            Cache<Integer, Map<Integer, byte[]>> cache = Network.getNetwork().getMessageCache();
            synchronized (cache) {
                ((Map)Network.getNetwork().getMessageCache().get((Object)this.communicationId, Maps::newConcurrentMap)).put(this.packetIndex, this.payload);
            }
            if (!this.terminator) {
                return;
            }
            byte[] packetData = ((Map)Network.getNetwork().getMessageCache().get((Object)this.communicationId, Maps::newConcurrentMap)).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).reduce(new byte[0], (xva$0, xva$1) -> Bytes.concat((byte[][])new byte[][]{xva$0, xva$1}));
            NetworkChannel.NetworkingMessageEntry<?> messageEntry = Network.getNetwork().getMessagesTypes().get(this.innerMessageId);
            IMessage message = (IMessage)messageEntry.getCreator().get();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])packetData);
            message.fromBytes(new PacketBuffer(buffer));
            buffer.release();
            LogicalSide packetOrigin = ctxIn.getDirection().getOriginationSide();
            if (message.getExecutionSide() != null && packetOrigin.equals((Object)message.getExecutionSide())) {
                Log.getLogger().warn("Receving {} at wrong side!", (Object)message.getClass().getName());
                return;
            }
            ctxIn.enqueueWork(() -> message.onExecute(ctxIn, packetOrigin.equals((Object)LogicalSide.CLIENT)));
        }
        catch (ExecutionException e) {
            Log.getLogger().error("Failed to handle split packet.", (Throwable)e);
        }
    }
}

