/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateRequestStateMessage
extends AbstractColonyServerMessage {
    private IToken<?> token;
    private ItemStack itemStack = ItemStackUtils.EMPTY;
    private RequestState state;

    public UpdateRequestStateMessage() {
    }

    public UpdateRequestStateMessage(IColony colony, IToken<?> requestId, RequestState state, ItemStack itemStack) {
        super(colony);
        this.token = requestId;
        this.state = state;
        this.itemStack = itemStack;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
        this.state = RequestState.values()[buf.readInt()];
        if (this.state == RequestState.OVERRULED) {
            this.itemStack = buf.func_150791_c();
        }
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.func_150786_a(StandardFactoryController.getInstance().serialize(this.token));
        buf.writeInt(this.state.ordinal());
        if (this.state == RequestState.OVERRULED) {
            buf.func_150788_a(this.itemStack);
        }
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (this.state == RequestState.OVERRULED) {
            colony.getRequestManager().overruleRequest(this.token, this.itemStack);
            return;
        }
        colony.getRequestManager().updateRequestState(this.token, this.state);
    }
}

