/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class InteractionResponse
extends AbstractColonyServerMessage {
    private int citizenId;
    private ITextComponent key;
    private ITextComponent response;

    public InteractionResponse() {
    }

    public InteractionResponse(int colonyId, int citizenId, RegistryKey<World> dimension, @NotNull ITextComponent key, @NotNull ITextComponent response) {
        super(dimension, colonyId);
        this.citizenId = citizenId;
        this.key = key;
        this.response = response;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.citizenId = buf.readInt();
        this.key = buf.func_179258_d();
        this.response = buf.func_179258_d();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.citizenId);
        buf.func_179256_a(this.key);
        buf.func_179256_a(this.response);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            citizenData = colony.getVisitorManager().getVisitor(this.citizenId);
        }
        if (citizenData != null && ctxIn.getSender() != null) {
            citizenData.onResponseTriggered(this.key, this.response, (PlayerEntity)ctxIn.getSender());
        }
    }
}

