/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateClientWithRecipesMessage
implements IMessage {
    private Map<ItemStorage, RecipeStorage> recipes;

    public UpdateClientWithRecipesMessage() {
    }

    public UpdateClientWithRecipesMessage(@NotNull Map<ItemStorage, RecipeStorage> recipes) {
        this.recipes = recipes;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.recipes = new HashMap<ItemStorage, RecipeStorage>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ItemStack result = buf.func_150791_c();
            RecipeStorage storage = (RecipeStorage)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
            this.recipes.put(new ItemStorage(result), storage);
        }
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.recipes.size());
        for (Map.Entry<ItemStorage, RecipeStorage> entry : this.recipes.entrySet()) {
            buf.func_150788_a(entry.getKey().getItemStack());
            buf.func_150786_a(StandardFactoryController.getInstance().serialize(entry.getValue()));
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        FurnaceRecipes.getInstance().setMap(this.recipes);
    }
}

