/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.StopMusicMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlayAudioMessage
implements IMessage {
    private SoundEvent soundEvent;
    private SoundCategory category = SoundCategory.MUSIC;

    public PlayAudioMessage() {
    }

    public PlayAudioMessage(SoundEvent event) {
        this.soundEvent = event;
    }

    public PlayAudioMessage(SoundEvent event, SoundCategory category) {
        this.soundEvent = event;
        this.category = category;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.category.ordinal());
        buf.func_150787_b(Registry.field_212633_v.func_148757_b((Object)this.soundEvent));
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.category = SoundCategory.values()[buf.func_150792_a()];
        this.soundEvent = (SoundEvent)Registry.field_212633_v.func_148745_a(buf.func_150792_a());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new SimpleSound(this.soundEvent.func_187503_a(), this.category, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void sendToAll(IColony col, boolean important, boolean stop, PlayAudioMessage ... messages) {
        List<PlayerEntity> players = important ? col.getImportantMessageEntityPlayers() : col.getMessagePlayerEntities();
        for (PlayerEntity player : players) {
            if (stop) {
                Network.getNetwork().sendToPlayer(new StopMusicMessage(), (ServerPlayerEntity)player);
            }
            for (PlayAudioMessage pam : messages) {
                Network.getNetwork().sendToPlayer(pam, (ServerPlayerEntity)player);
            }
        }
    }
}

