/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScrollBuff
extends AbstractItemScroll {
    public ItemScrollBuff(Item.Properties properties) {
        super("scroll_buff", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, World world, ServerPlayerEntity player) {
        if (world.field_73012_v.nextInt(8) > 0) {
            for (LivingEntity entity : world.func_225317_b(EntityCitizen.class, player.func_174813_aQ().func_72314_b(15.0, 2.0, 15.0))) {
                this.addRegenerationWithParticles(entity);
            }
            this.addRegenerationWithParticles((LivingEntity)player);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ParticleTypes.field_197633_z), player);
            SoundUtils.playSoundForPlayer(player, SoundEvents.field_187802_ec, 0.2f, 1.0f);
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.failed" + (world.field_73012_v.nextInt(10) + 1)).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
            player.func_195064_c(new EffectInstance(Effects.field_76440_q, 200));
            SoundUtils.playSoundForPlayer(player, SoundEvents.field_191263_gW, 0.04f, 1.0f);
        }
        itemStack.func_190918_g(1);
        return itemStack;
    }

    private void addRegenerationWithParticles(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 1200));
        Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ParticleTypes.field_197633_z), (Entity)entity);
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        TranslationTextComponent guiHint = new TranslationTextComponent("item.minecolonies.scroll_buff.tip");
        guiHint.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)guiHint);
    }

    @Override
    protected boolean needsColony() {
        return false;
    }
}

