/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemScroll
extends AbstractItemMinecolonies {
    public static final String TAG_COLONY_DIM = "colony_dim";
    public static final String TAG_BUILDING_POS = "building_pos";
    public static final int FAIL_RESPONSES_TOTAL = 10;

    public AbstractItemScroll(String name, Item.Properties properties) {
        super(name, properties);
    }

    public int func_77626_a(ItemStack itemStack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return UseAction.BOW;
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entityLiving) {
        if (!(entityLiving instanceof ServerPlayerEntity) || world.field_72995_K) {
            return itemStack;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entityLiving;
        if (!this.needsColony()) {
            return this.onItemUseSuccess(itemStack, world, player);
        }
        IColony colony = this.getColony(itemStack);
        if (colony == null) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.needcolony"), true);
            return itemStack;
        }
        if (!colony.getPermissions().hasPermission((PlayerEntity)player, Action.RIGHTCLICK_BLOCK)) {
            MessageUtils.format("minecolonies.scroll.nopermission", new Object[0]).sendTo(new PlayerEntity[]{player});
            return itemStack;
        }
        return this.onItemUseSuccess(itemStack, world, player);
    }

    protected abstract ItemStack onItemUseSuccess(ItemStack var1, World var2, ServerPlayerEntity var3);

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.FAIL, (Object)itemStack);
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K || !ctx.func_195999_j().func_225608_bj_() || !this.needsColony()) {
            return ActionResultType.PASS;
        }
        TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        ItemStack scroll = ctx.func_195999_j().func_184586_b(ctx.func_221531_n());
        CompoundNBT compound = AbstractItemScroll.checkForCompound(scroll);
        if (te instanceof TileEntityColonyBuilding) {
            compound.func_74768_a("colony", ((AbstractTileEntityColonyBuilding)te).getColonyId());
            compound.func_74778_a(TAG_COLONY_DIM, ((AbstractTileEntityColonyBuilding)te).getColony().getWorld().func_234923_W_().func_240901_a_().toString());
            BlockPosUtil.write(compound, TAG_BUILDING_POS, ctx.func_195995_a());
            MessageUtils.format("minecolonies.scroll.registered", ((AbstractTileEntityColonyBuilding)te).getColony().getName()).sendTo(ctx.func_195999_j());
        }
        return ActionResultType.SUCCESS;
    }

    protected abstract boolean needsColony();

    private static CompoundNBT checkForCompound(ItemStack item) {
        if (!item.func_77942_o()) {
            item.func_77982_d(new CompoundNBT());
        }
        return item.func_77978_p();
    }

    protected IColony getColony(ItemStack stack) {
        if (!(stack.func_77942_o() && stack.func_77978_p().func_74764_b("colony") && stack.func_77978_p().func_74764_b(TAG_COLONY_DIM))) {
            return null;
        }
        return IColonyManager.getInstance().getColonyByDimension(stack.func_77978_p().func_74762_e("colony"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i(TAG_COLONY_DIM))));
    }

    protected IColony getColonyView(ItemStack stack) {
        if (!(stack.func_77942_o() && stack.func_77978_p().func_74764_b("colony") && stack.func_77978_p().func_74764_b(TAG_COLONY_DIM))) {
            return null;
        }
        return IColonyManager.getInstance().getColonyView(stack.func_77978_p().func_74762_e("colony"), (RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i(TAG_COLONY_DIM))));
    }
}

