/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.minecolonies.api.loot.EntityInBiomeCategory;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.loot.ResearchUnlocked;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Items;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.jetbrains.annotations.NotNull;

public class DefaultFishermanLootProvider
extends SimpleLootTableProvider {
    private static final Gson GSON = LootSerializers.func_237388_c_().create();

    public DefaultFishermanLootProvider(@NotNull DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @NotNull
    public String func_200397_b() {
        return "DefaultFishermanLootProvider";
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        this.registerStandardLoot(registrar);
        this.registerBonusLoot(registrar);
    }

    @Override
    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationTracker validationtracker) {
        ValidationTracker newTracker = new ValidationTracker(LootParameterSets.field_216266_g, conditionId -> null, lootId -> {
            if (lootId.equals((Object)LootTables.field_186390_ao) || lootId.equals((Object)LootTables.field_186388_am) || lootId.equals((Object)LootTables.field_186389_an)) {
                return LootTable.func_216119_b().func_216038_b();
            }
            return validationtracker.func_227539_c_(lootId);
        });
        super.validate(map, newTracker);
    }

    private void registerStandardLoot(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        registrar.register(ModLootTables.FISHING, LootParameterSets.field_216262_c, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ModLootTables.FISHING_JUNK).func_216086_a(10).func_216085_b(-2)).func_216045_a(TableLootEntry.func_216171_a((ResourceLocation)ModLootTables.FISHING_TREASURE).func_216086_a(5).func_216085_b(2).func_212840_b_((ILootCondition.IBuilder)Alternative.func_215960_a((ILootCondition.IBuilder[])new ILootCondition.IBuilder[]{EntityInBiomeCategory.of(Biome.Category.OCEAN), ResearchUnlocked.effect(ResearchConstants.FISH_TREASURE)}))).func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ModLootTables.FISHING_FISH).func_216086_a(85).func_216085_b(-1))));
        registrar.register(ModLootTables.FISHING_JUNK, LootParameterSets.field_216262_c, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)LootTables.field_186388_am).func_216086_a(1))));
        registrar.register(ModLootTables.FISHING_TREASURE, LootParameterSets.field_216262_c, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)LootTables.field_186389_an).func_216086_a(1))));
        registrar.register(ModLootTables.FISHING_FISH, LootParameterSets.field_216262_c, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)LootTables.field_186390_ao).func_216086_a(1))));
    }

    private void registerBonusLoot(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        boolean skillBonus = true;
        boolean spongeWeight = true;
        int shardWeight = 25;
        int crystalWeight = 25;
        LootTable.Builder noBonus = LootTable.func_216119_b();
        LootTable.Builder level3 = DefaultFishermanLootProvider.makeLoot(1000, ItemLootEntry.func_216168_a((IItemProvider)Items.field_179562_cC).func_216086_a(25).func_216085_b(1), ItemLootEntry.func_216168_a((IItemProvider)Items.field_179563_cD).func_216086_a(25).func_216085_b(1));
        LootTable.Builder level45 = DefaultFishermanLootProvider.makeLoot(1000, ItemLootEntry.func_216168_a((IItemProvider)Items.field_221646_ak).func_216086_a(1).func_216085_b(1), ItemLootEntry.func_216168_a((IItemProvider)Items.field_179562_cC).func_216086_a(25).func_216085_b(1), ItemLootEntry.func_216168_a((IItemProvider)Items.field_179563_cD).func_216086_a(25).func_216085_b(1));
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(1), LootParameterSets.field_216260_a, noBonus);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(2), LootParameterSets.field_216260_a, noBonus);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(3), LootParameterSets.field_216266_g, level3);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(4), LootParameterSets.field_216266_g, level45);
        registrar.register(ModLootTables.FISHERMAN_BONUS.get(5), LootParameterSets.field_216266_g, level45);
    }

    private static LootTable.Builder makeLoot(int emptyWeight, StandaloneLootEntry.Builder<?> ... entries) {
        LootPool.Builder pool = LootPool.func_216096_a();
        for (StandaloneLootEntry.Builder<?> entry : entries) {
            pool.func_216045_a(entry);
            emptyWeight -= DefaultFishermanLootProvider.getWeightForEntry(entry);
        }
        pool.func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(emptyWeight));
        return LootTable.func_216119_b().func_216040_a(pool);
    }

    private static int getWeightForEntry(@NotNull StandaloneLootEntry.Builder<?> entry) {
        JsonObject json = GSON.toJsonTree((Object)entry.func_216081_b()).getAsJsonObject();
        return JSONUtils.func_151208_a((JsonObject)json, (String)"weight", (int)1);
    }
}

