/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.util.MutableChunkPos;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.jetbrains.annotations.NotNull;

public class DebugRendererChunkBorder {
    private static final double LINE_SHIFT = 0.003;
    private static final int RENDER_DIST_THRESHOLD = 3;
    private static final int CHUNK_SIZE = 16;
    private static final int CHUNK_HEIGHT = 256;
    private static final int PLAYER_CHUNK_STEP = 4;
    private static Pair<BufferBuilder.DrawState, ByteBuffer> colonies = null;
    private static Pair<BufferBuilder.DrawState, ByteBuffer> chunktickets = null;
    private static ChunkPos lastPlayerChunk = null;
    private static IColonyView lastColonyView = null;

    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() != ModItems.buildTool.get()) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        IColonyView nearestColonyView = IColonyManager.getInstance().getClosestColonyView((World)world, player.func_233580_cy_());
        if (nearestColonyView == null) {
            return;
        }
        ChunkPos playerChunkPos = new ChunkPos(player.func_233580_cy_());
        int playerRenderDist = Math.max(Minecraft.func_71410_x().field_71474_y.field_151451_c - 3, 2);
        if (lastColonyView != nearestColonyView || !lastPlayerChunk.equals((Object)playerChunkPos)) {
            lastColonyView = nearestColonyView;
            lastPlayerChunk = playerChunkPos;
            HashMap<ChunkPos, Integer> coloniesMap = new HashMap<ChunkPos, Integer>();
            HashMap<ChunkPos, Integer> chunkticketsMap = new HashMap<ChunkPos, Integer>();
            int range = Math.max(Minecraft.func_71410_x().field_71474_y.field_151451_c, (Integer)MineColonies.getConfig().getServer().maxColonySize.get());
            for (int chunkX = -range; chunkX <= range; ++chunkX) {
                for (int chunkZ = -range; chunkZ <= range; ++chunkZ) {
                    Chunk chunk = world.func_212866_a_(playerChunkPos.field_77276_a + chunkX, playerChunkPos.field_77275_b + chunkZ);
                    chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).ifPresent(cap -> coloniesMap.put(chunk.func_76632_l(), cap.getOwningColony()));
                    if (nearestColonyView.getTicketedChunks().contains(chunk.func_76632_l().func_201841_a())) {
                        chunkticketsMap.put(chunk.func_76632_l(), nearestColonyView.getID());
                        continue;
                    }
                    chunkticketsMap.put(chunk.func_76632_l(), 0);
                }
            }
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            colonies = DebugRendererChunkBorder.draw(bufferbuilder, coloniesMap, nearestColonyView.getID(), playerChunkPos, playerRenderDist);
            chunktickets = DebugRendererChunkBorder.draw(bufferbuilder, chunkticketsMap, nearestColonyView.getID(), playerChunkPos, playerRenderDist);
        }
        Vector3d currView = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        MatrixStack stack = event.getMatrixStack();
        Pair<BufferBuilder.DrawState, ByteBuffer> buffer = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)341) ? chunktickets : colonies;
        stack.func_227860_a_();
        stack.func_227861_a_(-currView.field_72450_a, -currView.field_72448_b, -currView.field_72449_c);
        RenderSystem.enableDepthTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
        WorldVertexBufferUploader.func_227844_a_((ByteBuffer)((ByteBuffer)buffer.getSecond()), (int)((BufferBuilder.DrawState)buffer.getFirst()).func_227840_c_(), (VertexFormat)((BufferBuilder.DrawState)buffer.getFirst()).func_227838_a_(), (int)((BufferBuilder.DrawState)buffer.getFirst()).func_227839_b_());
        RenderSystem.popMatrix();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        stack.func_227865_b_();
    }

    private static Pair<BufferBuilder.DrawState, ByteBuffer> draw(BufferBuilder bufferbuilder, Map<ChunkPos, Integer> mapToDraw, int playerColonyId, ChunkPos playerChunkPos, int playerRenderDist) {
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        MutableChunkPos mutableChunkPos = new MutableChunkPos(0, 0);
        HashMap colonyColours = new HashMap();
        boolean useColonyColour = (Boolean)IMinecoloniesAPI.getInstance().getConfig().getClient().colonyteamborders.get();
        mapToDraw.forEach((chunkPos, colonyId) -> {
            block32: {
                int y;
                int shift;
                boolean west;
                int blue;
                int green;
                int red;
                if (colonyId == 0 || chunkPos.field_77276_a <= playerChunkPos.field_77276_a - playerRenderDist || chunkPos.field_77276_a >= playerChunkPos.field_77276_a + playerRenderDist || chunkPos.field_77275_b <= playerChunkPos.field_77275_b - playerRenderDist || chunkPos.field_77275_b >= playerChunkPos.field_77275_b + playerRenderDist) {
                    return;
                }
                boolean isPlayerChunkX = colonyId == playerColonyId && chunkPos.field_77276_a == playerChunkPos.field_77276_a;
                boolean isPlayerChunkZ = colonyId == playerColonyId && chunkPos.field_77275_b == playerChunkPos.field_77275_b;
                double minX = (double)chunkPos.func_180334_c() + 0.003;
                double maxX = (double)chunkPos.func_180332_e() + 1.0 - 0.003;
                double minZ = (double)chunkPos.func_180333_d() + 0.003;
                double maxZ = (double)chunkPos.func_180330_f() + 1.0 - 0.003;
                int alpha = 255;
                int testedColonyId = colonyId;
                if (useColonyColour) {
                    Color colour = colonyColours.computeIfAbsent(colonyId, id -> {
                        IColonyView colony = IMinecoloniesAPI.getInstance().getColonyManager().getColonyView((int)id, (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
                        TextFormatting team = colony != null ? colony.getTeamColonyColor() : (id == playerColonyId ? TextFormatting.WHITE : TextFormatting.RED);
                        return new Color(team.func_211163_e());
                    });
                    red = colour.getRed();
                    green = colour.getGreen();
                    blue = colour.getBlue();
                } else if (colonyId == playerColonyId) {
                    red = 255;
                    green = 255;
                    blue = 255;
                } else {
                    red = 255;
                    green = 70;
                    blue = 70;
                }
                mutableChunkPos.setX(chunkPos.field_77276_a);
                mutableChunkPos.setZ(chunkPos.field_77275_b - 1);
                boolean north = mapToDraw.containsKey((Object)mutableChunkPos) && (Integer)mapToDraw.get((Object)mutableChunkPos) != testedColonyId;
                mutableChunkPos.setZ(chunkPos.field_77275_b + 1);
                boolean south = mapToDraw.containsKey((Object)mutableChunkPos) && (Integer)mapToDraw.get((Object)mutableChunkPos) != testedColonyId;
                mutableChunkPos.setX(chunkPos.field_77276_a + 1);
                mutableChunkPos.setZ(chunkPos.field_77275_b);
                boolean east = mapToDraw.containsKey((Object)mutableChunkPos) && (Integer)mapToDraw.get((Object)mutableChunkPos) != testedColonyId;
                mutableChunkPos.setX(chunkPos.field_77276_a - 1);
                boolean bl = west = mapToDraw.containsKey((Object)mutableChunkPos) && (Integer)mapToDraw.get((Object)mutableChunkPos) != testedColonyId;
                if (north || west) {
                    bufferbuilder.func_225582_a_(minX, 0.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    bufferbuilder.func_225582_a_(minX, 256.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                }
                if (north || east) {
                    bufferbuilder.func_225582_a_(maxX, 0.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    bufferbuilder.func_225582_a_(maxX, 256.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                }
                if (south || west) {
                    bufferbuilder.func_225582_a_(minX, 0.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    bufferbuilder.func_225582_a_(minX, 256.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                }
                if (south || east) {
                    bufferbuilder.func_225582_a_(maxX, 0.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    bufferbuilder.func_225582_a_(maxX, 256.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                }
                if (north) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.func_225582_a_(minX + (double)shift, 0.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(minX + (double)shift, 256.0, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.func_225582_a_(minX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(maxX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.func_225582_a_(minX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(maxX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    }
                }
                if (south) {
                    if (isPlayerChunkX) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.func_225582_a_(minX + (double)shift, 0.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(minX + (double)shift, 256.0, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.func_225582_a_(minX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(maxX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.func_225582_a_(minX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(maxX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    }
                }
                if (west) {
                    if (isPlayerChunkZ) {
                        for (shift = 4; shift < 16; shift += 4) {
                            bufferbuilder.func_225582_a_(minX, 0.0, minZ + (double)shift).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(minX, 256.0, minZ + (double)shift).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                        for (y = 4; y < 256; y += 4) {
                            bufferbuilder.func_225582_a_(minX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(minX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    } else {
                        for (y = 16; y < 256; y += 16) {
                            bufferbuilder.func_225582_a_(minX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                            bufferbuilder.func_225582_a_(minX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        }
                    }
                }
                if (!east) break block32;
                if (isPlayerChunkZ) {
                    for (shift = 4; shift < 16; shift += 4) {
                        bufferbuilder.func_225582_a_(maxX, 0.0, minZ + (double)shift).func_225586_a_(red, green, blue, 255).func_181675_d();
                        bufferbuilder.func_225582_a_(maxX, 256.0, minZ + (double)shift).func_225586_a_(red, green, blue, 255).func_181675_d();
                    }
                    for (y = 4; y < 256; y += 4) {
                        bufferbuilder.func_225582_a_(maxX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        bufferbuilder.func_225582_a_(maxX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    }
                } else {
                    for (y = 16; y < 256; y += 16) {
                        bufferbuilder.func_225582_a_(maxX, (double)y, minZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                        bufferbuilder.func_225582_a_(maxX, (double)y, maxZ).func_225586_a_(red, green, blue, 255).func_181675_d();
                    }
                }
            }
        });
        bufferbuilder.func_178977_d();
        Pair preResult = bufferbuilder.func_227832_f_();
        ByteBuffer temp = GLAllocation.func_74524_c((int)((ByteBuffer)preResult.getSecond()).capacity());
        ((Buffer)preResult.getSecond()).clear();
        ((Buffer)temp).clear();
        temp.put((ByteBuffer)preResult.getSecond());
        return Pair.of((Object)preResult.getFirst(), (Object)temp);
    }
}

