/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSkillHandler;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.util.ExperienceUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenSkillHandler
implements ICitizenSkillHandler {
    public Map<Skill, Tuple<Integer, Double>> skillMap = new HashMap<Skill, Tuple<Integer, Double>>();

    @Override
    public void init(int levelCap) {
        if (levelCap <= 1) {
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)1, (Object)0.0));
            }
        } else {
            Random random = new Random();
            for (Skill skill : Skill.values()) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)(random.nextInt(levelCap - 1) + 1), (Object)0.0));
            }
        }
    }

    @Override
    public void init(@NotNull IColony colony, @Nullable ICitizenData firstParent, @Nullable ICitizenData secondParent, Random rand) {
        ICitizenData roleModelA = firstParent == null ? colony.getCitizenManager().getRandomCitizen() : firstParent;
        ICitizenData roleModelB = secondParent == null ? colony.getCitizenManager().getRandomCitizen() : secondParent;
        int levelCap = (int)colony.getOverallHappiness();
        this.init(levelCap);
        int bonusPoints = 25 + rand.nextInt(25);
        int totalPoints = 0;
        for (Skill skill : Skill.values()) {
            int firstRoleModelLevel = (Integer)roleModelA.getCitizenSkillHandler().getSkills().get((Object)skill).func_76341_a();
            int secondRoleModelLevel = (Integer)roleModelB.getCitizenSkillHandler().getSkills().get((Object)skill).func_76341_a();
            totalPoints += firstRoleModelLevel + secondRoleModelLevel;
        }
        for (Skill skill : Skill.values()) {
            double firstRoleModelLevel = ((Integer)roleModelA.getCitizenSkillHandler().getSkills().get((Object)skill).func_76341_a()).intValue();
            double secondRoleModelLevel = ((Integer)roleModelB.getCitizenSkillHandler().getSkills().get((Object)skill).func_76341_a()).intValue();
            int newPoints = (int)((firstRoleModelLevel + secondRoleModelLevel) / (double)totalPoints * (double)bonusPoints);
            this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)((Integer)this.skillMap.get((Object)skill).func_76341_a() + newPoints), (Object)0.0));
        }
    }

    @Override
    @NotNull
    public CompoundNBT write() {
        CompoundNBT compoundNBT = new CompoundNBT();
        @NotNull ListNBT levelTagList = new ListNBT();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : this.skillMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            @NotNull CompoundNBT levelCompound = new CompoundNBT();
            levelCompound.func_74768_a("skill", entry.getKey().ordinal());
            levelCompound.func_74768_a("level", ((Integer)entry.getValue().func_76341_a()).intValue());
            levelCompound.func_74780_a("experience", ((Double)entry.getValue().func_76340_b()).doubleValue());
            levelTagList.add((Object)levelCompound);
        }
        compoundNBT.func_218657_a("levelMap", (INBT)levelTagList);
        return compoundNBT;
    }

    @Override
    public void read(@NotNull CompoundNBT compoundNBT) {
        ListNBT levelTagList = compoundNBT.func_150295_c("levelMap", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            CompoundNBT levelExperienceAtJob = levelTagList.func_150305_b(i);
            this.skillMap.put(Skill.values()[levelExperienceAtJob.func_74762_e("skill")], (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, Math.min(levelExperienceAtJob.func_74762_e("level"), 99)), (Object)levelExperienceAtJob.func_74769_h("experience")));
        }
    }

    @Override
    public void tryLevelUpIntelligence(@NotNull Random random, double customChance, @NotNull ICitizenData citizen) {
        if (customChance > 0.0 && random.nextDouble() * customChance < 1.0) {
            return;
        }
        int levelCap = (int)citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony());
        if ((Integer)this.skillMap.get((Object)Skill.Intelligence).func_76341_a() < levelCap * 9) {
            this.addXpToSkill(Skill.Intelligence, 10.0, citizen);
        }
    }

    @Override
    public int getLevel(@NotNull Skill skill) {
        return (Integer)this.skillMap.get((Object)skill).func_76341_a();
    }

    @Override
    public void incrementLevel(@NotNull Skill skill, int level) {
        Tuple<Integer, Double> current = this.skillMap.get((Object)skill);
        this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, Math.max((Integer)current.func_76341_a() + level, 1)), current.func_76340_b()));
    }

    @Override
    public void addXpToSkill(Skill skill, double xp, ICitizenData data) {
        double citizenHutMaxLevel;
        Tuple<Integer, Double> tuple = this.skillMap.getOrDefault((Object)skill, (Tuple<Integer, Double>)new Tuple((Object)0, (Object)0.0));
        int level = (Integer)tuple.func_76341_a();
        double currentXp = (Double)tuple.func_76340_b();
        IBuilding home = data.getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        double d = citizenHutMaxLevel = home == null ? 5.0 : (double)home.getMaxBuildingLevel();
        if ((citizenHutLevel < citizenHutMaxLevel || citizenHutMaxLevel < 5.0) && (citizenHutLevel + 1.0) * 10.0 <= (double)level || level >= 99) {
            return;
        }
        double xpToLevelUp = Math.min(Double.MAX_VALUE, currentXp + xp);
        while (xpToLevelUp > 0.0) {
            double nextLevel = ExperienceUtils.getXPNeededForNextLevel(level);
            if (nextLevel > xpToLevelUp) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.min(99, level), (Object)xpToLevelUp));
                xpToLevelUp = 0.0;
                continue;
            }
            xpToLevelUp -= nextLevel;
            ++level;
        }
        if (level > (Integer)tuple.func_76341_a()) {
            this.levelUp(data);
            data.markDirty();
        }
    }

    @Override
    public void removeXpFromSkill(@NotNull Skill skill, double xp, @NotNull ICitizenData data) {
        Tuple<Integer, Double> tuple = this.skillMap.get((Object)skill);
        int level = (Integer)tuple.func_76341_a();
        double currentXp = (Double)tuple.func_76340_b();
        double xpToDiscount = xp;
        while (xpToDiscount > 0.0) {
            if (currentXp >= xpToDiscount || level <= 1) {
                this.skillMap.put(skill, (Tuple<Integer, Double>)new Tuple((Object)Math.max(1, level), (Object)Math.max(0.0, currentXp - xpToDiscount)));
                break;
            }
            xpToDiscount -= currentXp;
            currentXp = ExperienceUtils.getXPNeededForNextLevel(level - 1);
            --level;
        }
        if (level < (Integer)tuple.func_76341_a()) {
            data.markDirty();
        }
    }

    @Override
    public void levelUp(ICitizenData data) {
        if (data.getEntity().isPresent()) {
            AbstractEntityCitizen citizen = data.getEntity().get();
            citizen.func_184185_a(SoundEvents.field_187802_ec, 1.0f, (float)SoundUtils.getRandomPitch(citizen.func_70681_au()));
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(citizen.func_226277_ct_(), citizen.func_226278_cu_(), citizen.func_226281_cx_(), ParticleTypes.field_197632_y), (Entity)data.getEntity().get());
        }
        if (data.getJob() != null) {
            data.getJob().onLevelUp();
        }
    }

    @Override
    public double getTotalXP() {
        double totalXp = 0.0;
        for (Tuple<Integer, Double> tuple : this.skillMap.values()) {
            totalXp += ((Double)tuple.func_76340_b()).doubleValue();
        }
        return totalXp;
    }

    @Override
    public Map<Skill, Tuple<Integer, Double>> getSkills() {
        return ImmutableMap.copyOf(this.skillMap);
    }
}

