/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTable;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenDiedEvent;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.colony.jobs.JobNetherWorker;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIEatTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIMournCitizen;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISickTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISleep;
import com.minecolonies.coremod.entity.citizen.CitizenColonyHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenStatusHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MovementHandler;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.NameTagItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen
implements IThreatTableEntity {
    private static final int CALL_HELP_CD = 100;
    private static final float GUARD_BLOCK_DAMAGE = 0.5f;
    private static final double MAX_SPEED_FACTOR = 0.5;
    private static final int CALL_TO_HELP_AMOUNT = 2;
    private final ICitizenStatusHandler citizenStatusHandler;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    private ICitizenData citizenData;
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenChatHandler citizenChatHandler;
    private ICitizenItemHandler citizenItemHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private ICitizenDiseaseHandler citizenDiseaseHandler;
    private PathResult moveAwayPath;
    private boolean child = false;
    private boolean currentlyFleeing = false;
    private int callForHelpCooldown = 0;
    private float lastDistanceWalked = 0.0f;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private String cachedTeamName;
    private final ThreatTable threatTable = new ThreatTable<EntityCitizen>(this);
    private int interactionCooldown = 0;
    private ITickRateStateMachine<EntityState> entityStatemachine = new TickRateStateMachine<EntityState>(EntityState.INIT, e -> Log.getLogger().warn(e));
    private DesiredActivity desiredActivity = DesiredActivity.IDLE;

    public EntityCitizen(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
        this.field_70714_bg = new CustomGoalSelector(this.field_70714_bg);
        this.field_70715_bh = new CustomGoalSelector(this.field_70715_bh);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenChatHandler = new CitizenChatHandler(this);
        this.citizenStatusHandler = new CitizenStatusHandler(this);
        this.citizenItemHandler = new CitizenItemHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new CitizenColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
        this.field_70765_h = new MovementHandler((MobEntity)this);
        this.func_110163_bv();
        this.func_174805_g((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INIT, () -> true, this::initialize, 40));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, () -> {
            this.citizenColonyHandler.updateColonyClient();
            return false;
        }, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::refreshCitizenDataView, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateSaturation, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateVisualData, () -> null, 200));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onServerUpdateHandlers, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onTickDecrements, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::determineDesiredActivity, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INACTIVE, () -> ((EntityCitizen)this).func_70089_S(), () -> EntityState.INIT, 100));
    }

    private boolean shouldBeInactive() {
        if (this.citizenData == null && this.citizenDataView == null) {
            return true;
        }
        return !this.func_70089_S();
    }

    private EntityState initialize() {
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_())) != null) {
                this.cachedTeamName = colonyView.getTeamName();
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                if (this.citizenDataView != null) {
                    this.initTasks();
                    return EntityState.ACTIVE_CLIENT;
                }
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.citizenData != null && this.func_70089_S() && this.citizenColonyHandler.getColony() != null) {
                this.initTasks();
                return EntityState.ACTIVE_SERVER;
            }
        }
        return null;
    }

    private void initTasks() {
        int priority = 0;
        this.field_70714_bg.func_75776_a(priority, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAICitizenAvoidEntity(this, MonsterEntity.class, 5.0f, 0.8, 1.1));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAIEatTask(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAISickTask(this));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAISleep(this));
        this.field_70714_bg.func_75776_a(priority, (Goal)new EntityAIInteractToggleAble((MobEntity)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, EntityCitizen.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAIMournCitizen(this, 0.6));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new EntityAICitizenWander(this, 0.6));
        this.field_70714_bg.func_75776_a(++priority, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
    }

    @NotNull
    public ActionResultType func_233661_c_(PlayerEntity player, @NotNull Hand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)player.field_70170_p.func_234923_W_());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return ActionResultType.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.func_184586_b(hand)).booleanValue() && player.func_184586_b(hand).func_77973_b() instanceof NameTagItem) {
            return super.func_233661_c_(player, hand);
        }
        ActionResultType result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K && iColonyView != null) {
            if (player.func_225608_bj_() && !this.func_82150_aj()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.func_200200_C_().getString(), this.func_145782_y()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null && !this.func_82150_aj()) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType directPlayerInteraction(PlayerEntity player, Hand hand) {
        ItemStack usedStack = player.func_184586_b(hand);
        if (this.isInteractionItem(usedStack) && this.interactionCooldown > 0) {
            if (!this.field_70170_p.func_201670_d()) {
                this.func_184185_a(SoundEvents.field_187913_gm, 0.5f, (float)SoundUtils.getRandomPitch(this.func_70681_au()));
                MessageUtils.format("com.minecolonies.coremod.interaction.notnow", this.getCitizenData().getName()).with(TextFormatting.RED).sendTo(player);
            }
            return null;
        }
        if (usedStack.func_77973_b() == Items.field_151153_ao && this.getCitizenDiseaseHandler().isSick()) {
            usedStack.func_190918_g(1);
            player.func_184611_a(hand, usedStack);
            if (!this.field_70170_p.func_201670_d() && this.func_70681_au().nextInt(3) == 0) {
                this.getCitizenDiseaseHandler().cure();
                this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, (float)SoundUtils.getRandomPitch(this.func_70681_au()));
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ParticleTypes.field_197632_y), (Entity)this);
            }
            this.interactionCooldown = 6000;
            return ActionResultType.CONSUME;
        }
        if (this.getCitizenDiseaseHandler().isSick()) {
            return null;
        }
        if (ItemStackUtils.ISFOOD.test(usedStack) && usedStack.func_77973_b() != Items.field_151153_ao) {
            if (this.func_70631_g_()) {
                this.childFoodInteraction(usedStack, player, hand);
            } else {
                this.eatFoodInteraction(usedStack, player, hand);
            }
            return ActionResultType.CONSUME;
        }
        if (usedStack.func_77973_b() == Items.field_151122_aG && this.func_70631_g_()) {
            usedStack.func_190918_g(1);
            player.func_184611_a(hand, usedStack);
            if (!this.field_70170_p.func_201670_d()) {
                this.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, 50.0, this.getCitizenData());
            }
            this.interactionCooldown = 6000;
            return ActionResultType.CONSUME;
        }
        if (usedStack.func_77973_b() == Items.field_221774_cw) {
            usedStack.func_190918_g(1);
            player.func_184611_a(hand, usedStack);
            if (!this.field_70170_p.func_201670_d()) {
                MessageUtils.format("com.minecolonies.coremod.interaction.ouch", this.getCitizenData().getName()).sendTo(player);
                this.getNavigation().moveAwayFromLivingEntity((Entity)player, 5.0, 1.0);
                this.func_70637_d(true);
            }
            this.interactionCooldown = 6000;
            return ActionResultType.CONSUME;
        }
        if (usedStack.func_77973_b() == Items.field_151114_aO) {
            usedStack.func_190918_g(1);
            player.func_184611_a(hand, usedStack);
            if (!this.field_70170_p.func_201670_d()) {
                this.func_195064_c(new EffectInstance(Effects.field_188423_x, 3600));
            }
            this.interactionCooldown = 3600;
            return ActionResultType.CONSUME;
        }
        return null;
    }

    public boolean isInteractionItem(ItemStack stack) {
        return ItemStackUtils.ISFOOD.test(stack) || stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151153_ao || stack.func_77973_b() == Items.field_221774_cw || stack.func_77973_b() == Items.field_151114_aO;
    }

    private void childFoodInteraction(ItemStack usedStack, PlayerEntity player, Hand hand) {
        if (usedStack.func_151000_E().getString().toLowerCase(Locale.ENGLISH).contains("cookie")) {
            usedStack.func_190918_g(1);
            player.func_184611_a(hand, usedStack);
            this.interactionCooldown = 100;
            if (!this.field_70170_p.func_201670_d()) {
                double satIncrease = (double)usedStack.func_77973_b().func_219967_s().func_221466_a() * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
                this.citizenData.increaseSaturation(satIncrease / 2.0);
                this.func_195064_c(new EffectInstance(Effects.field_76424_c, 300));
                this.func_184185_a(SoundEvents.field_187537_bA, 1.5f, (float)SoundUtils.getRandomPitch(this.func_70681_au()));
                Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getRotationPitch(), this.getRotationYaw(), this.func_70047_e()), (Entity)this);
            }
        } else {
            player.field_71071_by.func_184437_d(usedStack);
            player.func_146097_a(usedStack, true, true);
            if (!this.field_70170_p.func_201670_d()) {
                this.func_184185_a(SoundEvents.field_187913_gm, 1.0f, (float)SoundUtils.getRandomPitch(this.func_70681_au()));
                MessageUtils.format("com.minecolonies.coremod.interaction.nocookie", this.getCitizenData().getName()).with(TextFormatting.RED).sendTo(player);
            }
        }
    }

    private void eatFoodInteraction(ItemStack usedStack, PlayerEntity player, Hand hand) {
        usedStack.func_190918_g(1);
        player.func_184611_a(hand, usedStack);
        this.interactionCooldown = 100;
        if (!this.field_70170_p.func_201670_d()) {
            double satIncrease = (double)usedStack.func_77973_b().func_219967_s().func_221466_a() * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
            this.citizenData.increaseSaturation(satIncrease / 2.0);
            this.func_184185_a(SoundEvents.field_187537_bA, 1.5f, (float)SoundUtils.getRandomPitch(this.func_70681_au()));
            Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getRotationPitch(), this.getRotationYaw(), this.func_70047_e()), (Entity)this);
        }
    }

    public String func_195047_I_() {
        return this.func_200200_C_().getString() + " (" + this.getCivilianID() + ")";
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("status", this.citizenStatusHandler.getStatus().ordinal());
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.func_74768_a("colony", this.citizenColonyHandler.getColony().getID());
            compound.func_74768_a("citizen", this.citizenData.getId());
        }
        this.citizenDiseaseHandler.write(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.citizenStatusHandler.setStatus(Status.values()[compound.func_74762_e("status")]);
        this.citizenColonyHandler.setColonyId(compound.func_74762_e("colony"));
        this.citizenId = compound.func_74762_e("citizen");
        this.citizenDiseaseHandler.read(compound);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.entityStatemachine.tick();
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
    }

    public boolean refreshCitizenDataView() {
        IColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_())) != null) {
            this.citizenDataView = colonyView.getCitizen(this.citizenId);
            this.getNavigation().getPathingOptions().setCanUseRails(this.canPathOnRails());
            this.getNavigation().getPathingOptions().setCanClimbVines(this.canClimbVines());
        }
        return false;
    }

    private boolean onTickDecrements() {
        this.decrementCallForHelpCooldown();
        this.decreaseWalkingSaturation();
        return false;
    }

    private boolean onServerUpdateHandlers() {
        this.citizenExperienceHandler.gatherXp();
        this.citizenItemHandler.pickupItems();
        this.citizenData.setLastPosition(this.func_233580_cy_());
        this.citizenDiseaseHandler.tick();
        this.onLivingSoundUpdate();
        return false;
    }

    private boolean updateVisualData() {
        ItemStack hat = this.func_184582_a(EquipmentSlotType.HEAD);
        if (LocalDate.now(Clock.systemDefaultZone()).getMonth() == Month.DECEMBER && ((Boolean)MineColonies.getConfig().getServer().holidayFeatures.get()).booleanValue() && !(this.getCitizenJobHandler().getColonyJob() instanceof JobStudent) && !(this.getCitizenJobHandler().getColonyJob() instanceof JobNetherWorker)) {
            if (hat.func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.santaHat));
            }
        } else if (!hat.func_190926_b() && hat.func_77973_b() == ModItems.santaHat) {
            this.func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
        }
        this.func_174805_g((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        if (!this.citizenColonyHandler.getColony().getTextureStyleId().equals(this.func_184212_Q().func_187225_a(DATA_STYLE))) {
            this.func_184212_Q().func_187227_b(DATA_STYLE, (Object)this.citizenColonyHandler.getColony().getTextureStyleId());
        }
        if (!this.citizenData.getTextureSuffix().equals(this.func_184212_Q().func_187225_a(DATA_TEXTURE_SUFFIX))) {
            this.func_184212_Q().func_187227_b(DATA_TEXTURE_SUFFIX, (Object)this.citizenData.getTextureSuffix());
        }
        return false;
    }

    private boolean updateSaturation() {
        this.checkHeal();
        if (this.citizenData.getSaturation() <= 0.0) {
            if (this.func_70660_b(Effects.field_76421_d) == null) {
                this.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
            }
        } else {
            this.func_195063_d(Effects.field_76421_d);
        }
        return false;
    }

    private void decrementCallForHelpCooldown() {
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
    }

    public boolean canPathOnRails() {
        if (this.field_70170_p.field_72995_K) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
    }

    public boolean canClimbVines() {
        if (this.field_70170_p.field_72995_K) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
    }

    private void decreaseWalkingSaturation() {
        if (this.field_70140_Q - this.lastDistanceWalked > 25.0f) {
            this.lastDistanceWalked = this.field_70140_Q;
            this.decreaseSaturationForContinuousAction();
        }
    }

    private void checkHeal() {
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            double healAmount;
            double limitDecrease = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
            if (this.citizenData.getSaturation() >= 20.0 + limitDecrease) {
                healAmount = 2.0 * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            } else {
                if (this.citizenData.getSaturation() < 6.0) {
                    return;
                }
                healAmount = 1.0 * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            }
            this.func_70691_i((float)healAmount);
            if (healAmount > 0.1) {
                this.citizenData.markDirty();
            }
        }
    }

    private void onLivingSoundUpdate() {
        if (WorldUtil.isDayTime(this.field_70170_p) && !this.func_174814_R()) {
            SoundUtils.playRandomSound(this.field_70170_p, this.func_233580_cy_(), this.citizenData);
        }
    }

    public boolean func_70631_g_() {
        return this.child;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.field_70180_af.func_187214_a(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        if (this.citizenJobHandler.getColonyJob() != null && ((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
            this.func_200203_b((ITextComponent)new StringTextComponent(this.citizenData.getName() + " (" + (Object)((Object)this.citizenStatusHandler.getStatus()) + ")[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]"));
        }
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Override
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null) {
            this.citizenData = (ICitizenData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @Override
    public void setCitizensize(@NotNull float width, @NotNull float height) {
        this.field_213325_aI = new EntitySize(width, height, false);
    }

    @Override
    public void setIsChild(boolean isChild) {
        if (isChild && !this.child) {
            this.field_70714_bg.func_75776_a(50, (Goal)new EntityAICitizenChild(this));
            this.setCitizensize(0.3f, 0.9f);
        } else {
            if (!isChild && this.child) {
                this.getCitizenJobHandler().setModelDependingOnJob(this.citizenJobHandler.getColonyJob());
            }
            this.setCitizensize(0.6f, 1.8f);
        }
        this.child = isChild;
        this.func_184212_Q().func_187227_b(DATA_IS_CHILD, (Object)isChild);
        this.markDirty();
    }

    @Override
    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(this.field_70170_p, this.func_233580_cy_(), EventType.DANGER, this.getCitizenData());
        }
    }

    @Override
    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    @Override
    public ICitizenStatusHandler getCitizenStatusHandler() {
        return this.citizenStatusHandler;
    }

    @Override
    public ICitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void setCitizenDiseaseHandler(ICitizenDiseaseHandler citizenDiseaseHandler) {
        this.citizenDiseaseHandler = citizenDiseaseHandler;
    }

    @Override
    public boolean isOkayToEat() {
        return !this.getCitizenSleepHandler().isAsleep() && this.getDesiredActivity() != DesiredActivity.SLEEP && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().canAIBeInterrupted());
    }

    @Override
    public boolean shouldBeFed() {
        return this.getCitizenData() != null && this.getCitizenData().getSaturation() <= 10.0 && !this.getCitizenData().justAte() && this.isOkayToEat();
    }

    @Override
    public boolean isIdlingAtJob() {
        return this.isOkayToEat() && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().isIdling());
    }

    private boolean determineDesiredActivity() {
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        if (this.getCitizenColonyHandler().getColony().getRaiderManager().isRaided()) {
            this.citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.raid"), ChatPriority.IMPORTANT));
            this.setVisibleStatusIfNone(VisibleCitizenStatus.RAIDED);
            this.desiredActivity = DesiredActivity.SLEEP;
            return false;
        }
        if (!WorldUtil.isPastTime(CompatibilityUtils.getWorldFromCitizen(this), 10600)) {
            if (this.desiredActivity == DesiredActivity.SLEEP) {
                this.setVisibleStatusIfNone(VisibleCitizenStatus.SLEEP);
                return false;
            }
            if (this.citizenSleepHandler.shouldGoSleep()) {
                this.citizenData.onGoSleep();
                this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() * 2.0);
                this.citizenData.markDirty();
                this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.sleeping")});
                this.desiredActivity = DesiredActivity.SLEEP;
                return false;
            }
        }
        if (this.citizenData.getCitizenMournHandler().isMourning() && this.citizenData.getCitizenMournHandler().shouldMourn()) {
            if (!this.getCitizenColonyHandler().getColony().getRaiderManager().isRaided()) {
                this.citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.mourning", new Object[]{this.citizenData.getCitizenMournHandler().getDeceasedCitizens().iterator().next()}), (ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.mourning"), ChatPriority.IMPORTANT));
            }
            this.setVisibleStatusIfNone(VisibleCitizenStatus.MOURNING);
            this.desiredActivity = DesiredActivity.MOURN;
            return false;
        }
        if (this.citizenSleepHandler.isAsleep() && !this.citizenDiseaseHandler.isSick()) {
            this.citizenSleepHandler.onWakeUp();
        }
        if (CompatibilityUtils.getWorldFromCitizen(this).func_72896_J() && !this.shouldWorkWhileRaining() && !WorldUtil.isNetherType(this.field_70170_p)) {
            this.citizenStatusHandler.setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.waiting"), new TranslationTextComponent("com.minecolonies.coremod.status.rainStop")});
            this.setVisibleStatusIfNone(VisibleCitizenStatus.BAD_WEATHER);
            if (!this.citizenData.getColony().getRaiderManager().isRaided() && !this.citizenData.getCitizenMournHandler().isMourning()) {
                this.citizenData.triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.raining"), ChatPriority.HIDDEN));
            }
            this.desiredActivity = DesiredActivity.SLEEP;
            return false;
        }
        if (this.func_70631_g_() && this.getCitizenJobHandler().getColonyJob() instanceof JobPupil && this.field_70170_p.func_72820_D() % 24000L > 6000L) {
            this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
            this.desiredActivity = DesiredActivity.IDLE;
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
        this.desiredActivity = DesiredActivity.IDLE;
        return false;
    }

    private void setVisibleStatusIfNone(VisibleCitizenStatus status) {
        if (this.getCitizenData().getStatus() == null) {
            this.getCitizenData().setVisibleStatus(status);
        }
    }

    @Override
    @NotNull
    public DesiredActivity getDesiredActivity() {
        return this.desiredActivity;
    }

    private boolean shouldWorkWhileRaining() {
        return (Boolean)MineColonies.getConfig().getServer().workersAlwaysWorkInRain.get() != false || this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORKING_IN_RAIN) > 0.0 || this.citizenColonyHandler.getWorkBuilding() != null && this.citizenColonyHandler.getWorkBuilding().hasModule(WorkerBuildingModule.class) && this.citizenColonyHandler.getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class).canWorkDuringTheRain();
    }

    @Override
    public float getRotationYaw() {
        return this.field_70177_z;
    }

    @Override
    public float getRotationPitch() {
        return this.field_70125_A;
    }

    @Override
    public boolean isDead() {
        return !this.func_70089_S();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
        this.citizenSleepHandler = citizenSleepHandler;
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenItemHandler(ICitizenItemHandler citizenItemHandler) {
        this.citizenItemHandler = citizenItemHandler;
    }

    @Override
    public void setCitizenChatHandler(ICitizenChatHandler citizenChatHandler) {
        this.citizenChatHandler = citizenChatHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    public boolean func_70097_a(@NotNull DamageSource damageSource, float damage) {
        if (this.handleInWallDamage(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.func_76346_g();
        if (!this.checkIfValidDamageSource(damageSource, damage)) {
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null && this.getCitizenJobHandler().getColonyJob().ignoresDamage(damageSource)) {
            return false;
        }
        return this.handleDamagePerformed(damageSource, damage, sourceEntity);
    }

    private boolean handleInWallDamage(@NotNull DamageSource damageSource) {
        if (damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l())) {
            TeleportHelper.teleportCitizen(this, this.field_70170_p, this.func_233580_cy_().func_177982_a(0, 1, 0));
            return true;
        }
        return damageSource.func_76355_l().equals(DamageSource.field_76368_d.func_76355_l()) && this.citizenSleepHandler.isAsleep() || Compatibility.isDynTreePresent() && damageSource.field_76373_n.equals(Compatibility.getDynamicTreeDamage()) || this.func_190530_aW();
    }

    private boolean checkIfValidDamageSource(DamageSource source, float damage) {
        Entity sourceEntity = source.func_76346_g();
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return false;
            }
            IColony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColony();
            if (attackerColony != null && this.citizenColonyHandler.getColony() != null) {
                IPermissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColony().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), permission.getRank(4));
            }
        }
        if (sourceEntity instanceof PlayerEntity) {
            if (sourceEntity instanceof ServerPlayerEntity) {
                if (this.citizenColonyHandler.getColony().getRaiderManager().isRaided()) {
                    return false;
                }
                if (damage > 1.0f && !this.getCitizenColonyHandler().getColony().getPermissions().hasPermission((PlayerEntity)sourceEntity, Action.HURT_CITIZEN)) {
                    return false;
                }
                if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                    return IGuardBuilding.checkIfGuardShouldTakeDamage(this, (PlayerEntity)sourceEntity);
                }
            } else {
                IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (RegistryKey<World>)this.field_70170_p.func_234923_W_());
                return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((PlayerEntity)sourceEntity, Action.HURT_CITIZEN);
            }
        }
        return true;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        if (pos.field_72450_a != 0.0 || pos.field_72449_c != 0.0) {
            if (this.getCitizenData() != null && this.getCitizenData().isAsleep()) {
                this.getCitizenSleepHandler().onWakeUp();
            } else if (this.func_213283_Z() == Pose.SLEEPING) {
                this.updatePose(Pose.STANDING);
            }
        }
        super.func_213315_a(typeIn, pos);
    }

    public float func_70689_ay() {
        return (float)Math.min(0.5, (double)super.func_70689_ay());
    }

    private boolean handleDamagePerformed(@NotNull DamageSource damageSource, float damage, Entity sourceEntity) {
        boolean result;
        float damageInc = Math.min(damage, this.func_110138_aP() * 0.2f);
        if (this.citizenJobHandler.getColonyJob() instanceof JobNetherWorker && this.citizenData != null && damageSource.field_76373_n == "nether") {
            damageInc = damage;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_82150_aj()) {
            this.performMoveAway(sourceEntity);
        }
        this.func_130011_c(damageSource.func_76346_g());
        if (!this.field_70170_p.field_72995_K && this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenData != null) {
            if (this.citizenJobHandler.getColonyJob() instanceof JobKnight && this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS) > 0.0 && this.func_70681_au().nextDouble() < this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS)) {
                return false;
            }
            if (this.citizenData.getWorkBuilding() instanceof AbstractBuildingGuards && ((AbstractBuildingGuards)this.citizenData.getWorkBuilding()).shallRetrieveOnLowHealth() && (double)this.func_110143_aJ() < (double)((int)this.func_110138_aP()) * 0.2) {
                damageInc = (float)((double)damageInc * (1.0 - this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_DAMAGE)));
            }
        }
        if ((result = super.func_70097_a(damageSource, damageInc)) && damageSource.func_76346_g() instanceof LivingEntity) {
            this.threatTable.addThreat((LivingEntity)damageSource.func_76346_g(), (int)damageInc);
        }
        if (damageSource.func_82725_o() || damageSource.func_76347_k()) {
            return result;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.citizenItemHandler.updateArmorDamage(damageInc);
            if (this.citizenData != null) {
                this.getCitizenData().getCitizenHappinessHandler().getModifier("damage").reset();
            }
        }
        return result;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        this.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.avoiding")});
        if (!(attacker instanceof LivingEntity)) {
            if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
                this.moveAwayPath = this.getNavigation().moveAwayFromLivingEntity((Entity)this, 5.0, 1.1);
            }
            return;
        }
        this.currentlyFleeing = true;
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.callForHelp(attacker, 90000);
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.moveAwayPath = this.getNavigation().moveAwayFromLivingEntity(attacker, 15.0, 1.1);
        }
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof LivingEntity) || !((Boolean)MineColonies.getConfig().getServer().citizenCallForHelp.get()).booleanValue() || this.callForHelpCooldown != 0) {
            return;
        }
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenJobHandler.getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return;
        }
        this.callForHelpCooldown = 100;
        ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
        for (ICitizenData entry : this.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens()) {
            if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || entry.getId() == this.citizenData.getId() || BlockPosUtil.getDistanceSquared(entry.getEntity().get().func_233580_cy_(), this.func_233580_cy_()) >= (long)guardHelpRange || entry.getJob().getWorkerAI() == null) continue;
            ThreatTable table = ((EntityCitizen)entry.getEntity().get()).getThreatTable();
            table.addThreat((LivingEntity)attacker, 0);
            if (!((AbstractEntityAIGuard)((Object)entry.getJob().getWorkerAI())).canHelp()) continue;
            possibleGuards.add(entry.getEntity().get());
        }
        Collections.sort(possibleGuards, Comparator.comparingInt(guard -> (int)this.func_233580_cy_().func_177951_i((Vector3i)guard.func_233580_cy_())));
        for (int i = 0; i < possibleGuards.size() && i <= 2; ++i) {
            ((AbstractEntityAIGuard)((Object)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI())).startHelpCitizen((LivingEntity)attacker);
        }
    }

    protected void func_82167_n(Entity entity) {
        if (!this.citizenSleepHandler.isAsleep()) {
            super.func_82167_n(entity);
        }
        if (!this.field_70170_p.field_72995_K && entity instanceof AbstractEntityCitizen) {
            this.getCitizenDiseaseHandler().onCollission((AbstractEntityCitizen)entity);
        }
    }

    @Override
    public void onPlayerCollide(PlayerEntity player) {
        super.onPlayerCollide(player);
        if (this.citizenJobHandler.getColonyJob() != null && this.citizenJobHandler.getColonyJob().getWorkerAI() instanceof AbstractEntityAIBasic) {
            ((AbstractEntityAIBasic)((Object)this.citizenJobHandler.getColonyJob().getWorkerAI())).setDelay(60);
        }
    }

    public void func_70645_a(@NotNull DamageSource damageSource) {
        this.currentlyFleeing = false;
        if (this.citizenColonyHandler.getColony() != null && this.getCitizenData() != null) {
            this.citizenColonyHandler.getColony().getRaiderManager().onLostCitizen(this.getCitizenData());
            this.citizenExperienceHandler.dropExperience();
            this.func_70106_y();
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColony().getCitizenManager().updateModifier("death");
            }
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            this.citizenChatHandler.notifyDeath(damageSource);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColony().getCitizenManager().updateCitizenMourn(this.citizenData, true);
            }
            if (!this.func_82150_aj()) {
                if (this.citizenColonyHandler.getColony().isCoordInColony(this.field_70170_p, this.func_233580_cy_())) {
                    this.getCitizenColonyHandler().getColony().getGraveManager().createCitizenGrave(this.field_70170_p, this.func_233580_cy_(), this.citizenData);
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.citizenData.getInventory(), this.field_70170_p, (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_());
                }
            }
            if (this.citizenData.getJob() != null) {
                this.citizenData.getJob().onRemoval();
            }
            this.citizenColonyHandler.getColony().getCitizenManager().removeCivilian(this.getCitizenData());
            String deathCause = new StringTextComponent(damageSource.func_151519_b((LivingEntity)this).getString()).getString().replaceFirst(this.func_145748_c_().getString(), "Citizen");
            this.citizenColonyHandler.getColony().getEventDescriptionManager().addEventDescription(new CitizenDiedEvent(this.func_233580_cy_(), this.citizenData.getName(), deathCause));
        }
        super.func_70645_a(damageSource);
    }

    private void triggerDeathAchievement(DamageSource source, IJob<?> job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    protected void func_213337_cE() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }

    public int func_70658_aO() {
        if (this.citizenJobHandler.getColonyJob() instanceof JobKnight) {
            return (int)((double)super.func_70658_aO() * (1.0 + this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_ARMOR)));
        }
        if (this.citizenJobHandler.getColonyJob() instanceof JobRanger) {
            return (int)((double)super.func_70658_aO() * (1.0 + this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_ARMOR)));
        }
        return super.func_70658_aO();
    }

    protected void func_184590_k(float damage) {
        if (this.func_184586_b(this.func_184600_cs()).func_77973_b() instanceof ShieldItem) {
            if (this.func_110143_aJ() > damage * 0.5f) {
                float blockDamage = CombatRules.func_189427_a((float)(damage * 0.5f), (float)this.func_70658_aO(), (float)((float)this.func_110148_a(Attributes.field_233827_j_).func_111126_e()));
                this.func_70606_j(this.func_110143_aJ() - Math.max(0.5f, blockDamage));
            }
            this.citizenItemHandler.damageItemInHand(this.func_184600_cs(), (int)(damage * 0.5f));
        }
        super.func_184590_k(damage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ICitizenData data = this.getCitizenData();
            if (data == null) {
                return super.getCapability(capability, facing);
            }
            InventoryCitizen inv = data.getInventory();
            return LazyOptional.of(() -> inv);
        }
        return super.getCapability(capability, facing);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)obj;
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public void func_70106_y() {
        this.citizenColonyHandler.onCitizenRemoved();
        super.func_70106_y();
    }

    public Team func_96124_cp() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K && this.cachedTeamName == null) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            return this.field_70170_p.func_96441_U().func_96508_e(this.cachedTeamName);
        }
        return this.field_70170_p.func_96441_U().func_96508_e(this.func_195047_I_());
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColony() != null && name != null) {
            if (!name.getString().contains(this.citizenData.getName()) && (Integer)MineColonies.getConfig().getServer().allowGlobalNameChanges.get() >= 0) {
                if ((Integer)MineColonies.getConfig().getServer().allowGlobalNameChanges.get() == 0 && ((List)MineColonies.getConfig().getServer().specialPermGroup.get()).stream().noneMatch(owner -> owner.equals(this.citizenColonyHandler.getColony().getPermissions().getOwnerName()))) {
                    MessageUtils.format("com.minecolonies.coremod.citizen.rename.notallowed", new Object[0]).sendTo(this.citizenColonyHandler.getColony()).forAllPlayers();
                    return;
                }
                if (this.citizenColonyHandler.getColony() != null) {
                    for (ICitizenData citizen : this.citizenColonyHandler.getColony().getCitizenManager().getCitizens()) {
                        if (!citizen.getName().equals(name.getString())) continue;
                        MessageUtils.format("com.minecolonies.coremod.citizen.rename.same", new Object[0]).sendTo(this.citizenColonyHandler.getColony()).forAllPlayers();
                        return;
                    }
                    this.citizenData.setName(name.getString());
                    this.citizenData.markDirty();
                    super.func_200203_b(name);
                }
                return;
            }
            super.func_200203_b(name);
        }
    }

    public void func_70656_aK() {
        super.func_70656_aK();
    }

    protected void func_175445_a(ItemEntity itemEntity) {
    }

    public boolean func_213392_I() {
        return true;
    }

    @NotNull
    public BlockPos func_213384_dI() {
        @Nullable IBuilding homeBuilding = this.citizenColonyHandler.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getPosition();
        }
        if (this.citizenColonyHandler.getColony() != null && this.citizenColonyHandler.getColony().getBuildingManager().getTownHall() != null) {
            return this.citizenColonyHandler.getColony().getBuildingManager().getTownHall().getPosition();
        }
        return super.func_213384_dI();
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        if (entity instanceof SittingEntity || force) {
            return super.func_184205_a(entity, force);
        }
        return false;
    }

    @Override
    public boolean isCurrentlyFleeing() {
        return this.currentlyFleeing;
    }

    @Override
    public void setFleeingState(boolean fleeing) {
        this.currentlyFleeing = fleeing;
    }

    @Nullable
    public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
        return new ContainerCitizenInventory(id, inv, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    @Override
    public void setTexture() {
        super.setTexture();
    }

    @Override
    public void updatePose(Pose pose) {
        this.func_213301_b(pose);
    }

    public void func_213323_x_() {
        EntitySize afterEventSize;
        EntitySize oldSize = this.field_213325_aI;
        Pose pose = this.func_213283_Z();
        EntitySize newSize = this.func_213305_a(pose);
        EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)pose, (EntitySize)newSize, (float)this.func_213316_a(pose, newSize));
        this.field_213325_aI = afterEventSize = sizeEvent.getNewSize();
        this.field_213326_aJ = sizeEvent.getNewEyeHeight();
        if (afterEventSize.field_220315_a < oldSize.field_220315_a) {
            double d0 = (double)afterEventSize.field_220315_a / 2.0;
            this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - d0, this.func_226278_cu_(), this.func_226281_cx_() - d0, this.func_226277_ct_() + d0, this.func_226278_cu_() + (double)afterEventSize.field_220316_b, this.func_226281_cx_() + d0));
        } else {
            AxisAlignedBB axisalignedbb = this.func_174813_aQ();
            this.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)afterEventSize.field_220315_a, axisalignedbb.field_72338_b + (double)afterEventSize.field_220316_b, axisalignedbb.field_72339_c + (double)afterEventSize.field_220315_a));
            if (afterEventSize.field_220315_a > oldSize.field_220315_a && !this.field_70148_d && !this.field_70170_p.field_72995_K) {
                float f = oldSize.field_220315_a - afterEventSize.field_220315_a;
                this.func_213315_a(MoverType.SELF, new Vector3d((double)f, 0.0, (double)f));
            }
        }
    }

    public boolean isActive() {
        return this.field_70170_p.field_72995_K ? this.entityStatemachine.getState() == EntityState.ACTIVE_CLIENT : this.entityStatemachine.getState() == EntityState.ACTIVE_SERVER;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    private static enum EntityState implements IState
    {
        INIT,
        ACTIVE_SERVER,
        ACTIVE_CLIENT,
        INACTIVE;

    }
}

