/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.StringUtils;

public class EntityAIMournCitizen
extends Goal {
    private final TickRateStateMachine<MourningState> stateMachine;
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;
    private BlockPos graveyard;
    private BlockPos gravePos;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<MourningState>(MourningState.IDLE, e -> Log.getLogger().warn("Mourning AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.IDLE, () -> true, () -> MourningState.DECIDE, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.DECIDE, () -> true, this::decide, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDERING, () -> true, this::wander, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.STARING, () -> true, this::stare, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_GRAVEYARD, () -> true, this::walkToGraveyard, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDER_AT_GRAVEYARD, () -> true, this::wanderAtGraveyard, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALK_TO_GRAVE, () -> true, this::walkToGrave, 20));
    }

    private boolean shouldMourn() {
        boolean shouldMourn;
        boolean bl = shouldMourn = this.citizen.getDesiredActivity() == DesiredActivity.MOURN;
        if (shouldMourn && this.citizen.func_70681_au().nextInt(300) < 1) {
            this.citizen.getCitizenData().getCitizenMournHandler().clearDeceasedCitizen();
            this.citizen.getCitizenData().getCitizenMournHandler().setMourning(false);
            this.citizen.getCitizenData().setVisibleStatus(null);
        }
        return shouldMourn;
    }

    private MourningState walkToTownHall() {
        BlockPos pos = this.getMournLocation();
        this.citizen.getNavigation().moveToXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.speed);
        return MourningState.IDLE;
    }

    private MourningState walkToGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.graveyard, 3)) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        return MourningState.WANDER_AT_GRAVEYARD;
    }

    private MourningState wanderAtGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.shouldMourn()) {
            return MourningState.IDLE;
        }
        IBuilding graveyardBuilding = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(this.graveyard);
        if (!(graveyardBuilding instanceof BuildingGraveyard)) {
            this.graveyard = null;
            return MourningState.DECIDE;
        }
        if (!this.citizen.getNavigation().func_75500_f()) {
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        if (MathUtils.RANDOM.nextInt(100) < 90) {
            this.citizen.getNavigation().moveToRandomPos(10, 0.6, graveyardBuilding.getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        Set<Tuple<BlockPos, Direction>> gravePositions = ((BuildingGraveyard)graveyardBuilding).getGravePositions();
        for (Tuple<BlockPos, Direction> gravePos : gravePositions) {
            Iterator<String> iterator;
            TileEntity blockEntity;
            if (!WorldUtil.isBlockLoaded((IWorld)this.citizen.field_70170_p, gravePos.getA()) || !((blockEntity = this.citizen.field_70170_p.func_175625_s(gravePos.getA())) instanceof TileEntityNamedGrave) || !(iterator = this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens().iterator()).hasNext()) continue;
            String deathBud = iterator.next();
            String firstName = StringUtils.split((String)deathBud)[0];
            String lastName = deathBud.replaceFirst(firstName, "");
            ArrayList<String> graveNameList = ((TileEntityNamedGrave)blockEntity).getTextLines();
            if (graveNameList.isEmpty() || !graveNameList.contains(firstName) || !graveNameList.contains(lastName)) continue;
            this.gravePos = gravePos.getA();
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private MourningState walkToGrave() {
        if (this.gravePos == null) {
            return MourningState.DECIDE;
        }
        if (!this.shouldMourn()) {
            return MourningState.IDLE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.gravePos, 3)) {
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private MourningState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return MourningState.IDLE;
    }

    private MourningState stare() {
        if (this.citizen.func_70681_au().nextInt(200) < 1) {
            this.closestEntity = null;
            return MourningState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.field_70170_p.func_217360_a(EntityCitizen.class, EntityPredicate.field_221016_a, (LivingEntity)this.citizen, this.citizen.func_226277_ct_(), this.citizen.func_226278_cu_(), this.citizen.func_226281_cx_(), this.citizen.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return MourningState.IDLE;
            }
        }
        this.citizen.func_70671_ap().func_75650_a(this.closestEntity.func_226277_ct_(), this.closestEntity.func_226278_cu_() + (double)this.closestEntity.func_70047_e(), this.closestEntity.func_226281_cx_(), (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        return MourningState.STARING;
    }

    private MourningState decide() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN) {
            return MourningState.IDLE;
        }
        if (!this.citizen.getNavigation().func_75500_f()) {
            return MourningState.IDLE;
        }
        if (this.citizen.getCitizenStatusHandler().getStatus() != Status.MOURN) {
            this.citizen.getCitizenItemHandler().removeHeldItem();
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.MOURNING);
            this.citizen.getCitizenStatusHandler().setStatus(Status.MOURN);
        }
        if (this.citizen.func_70681_au().nextBoolean()) {
            return MourningState.STARING;
        }
        if (this.graveyard == null) {
            this.graveyard = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getFirstBuildingMatching(b -> b instanceof BuildingGraveyard && b.getFirstModuleOccurance(GraveyardManagementModule.class).hasRestingCitizen(this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens()));
        }
        if (this.graveyard != null) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        this.citizen.func_70671_ap().func_75650_a(this.citizen.func_226277_ct_(), this.citizen.func_226278_cu_() - 10.0, this.citizen.func_226281_cx_(), (float)this.citizen.func_184649_cE(), (float)this.citizen.func_70646_bf());
        if (BlockPosUtil.getDistance2D(this.citizen.func_233580_cy_(), this.getMournLocation()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        return MourningState.WANDERING;
    }

    public boolean func_75250_a() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.MOURN && MathUtils.RANDOM.nextInt(20) < 1) {
            return this.shouldMourn();
        }
        return this.citizen.getDesiredActivity() == DesiredActivity.MOURN;
    }

    public void func_75246_d() {
        this.stateMachine.tick();
    }

    public void func_75251_c() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.graveyard = null;
        this.gravePos = null;
    }

    protected BlockPos getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return this.citizen.func_213384_dI();
        }
        return colony.getBuildingManager().getTownHall().getPosition();
    }

    public static enum MourningState implements IState
    {
        IDLE,
        DECIDE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING,
        WALKING_TO_GRAVEYARD,
        WANDER_AT_GRAVEYARD,
        WALK_TO_GRAVE;

    }
}

