/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.undertaker;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.UndertakerConstants;
import com.minecolonies.coremod.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.coremod.colony.jobs.JobUndertaker;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkUndertaker
extends AbstractEntityAIInteract<JobUndertaker, BuildingGraveyard> {
    private Random random = new Random();
    private int effortCounter = 0;
    private boolean shouldDumpInventory = false;
    private BlockPos wanderPos = null;
    private Tuple<BlockPos, Direction> burialPos = null;

    public EntityAIWorkUndertaker(@NotNull JobUndertaker job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 60), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorking, 5), new AITarget((IAIState)AIWorkerState.WANDER, this::wander, 5), new AITarget((IAIState)AIWorkerState.EMPTY_GRAVE, this::emptyGrave, 5), new AITarget((IAIState)AIWorkerState.TRY_RESURRECT, this::tryResurrect, 5), new AITarget((IAIState)AIWorkerState.DIG_GRAVE, this::digGrave, 5), new AITarget((IAIState)AIWorkerState.BURY_CITIZEN, this::buryCitizen, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingGraveyard> getExpectedBuildingClass() {
        return BuildingGraveyard.class;
    }

    @NotNull
    private IAIState startWorking() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        this.worker.getCitizenData().setIdleAtJob(false);
        @Nullable BlockPos currentGrave = ((BuildingGraveyard)this.building).getGraveToWorkOn();
        if (currentGrave != null) {
            if (this.walkToBuilding()) {
                return this.getState();
            }
            TileEntity entity = this.world.func_175625_s(currentGrave);
            if (entity instanceof TileEntityGrave) {
                ((BuildingGraveyard)this.building).getFirstModuleOccurance(GraveyardManagementModule.class).setLastGraveData((GraveData)((TileEntityGrave)entity).getGraveData());
                return AIWorkerState.EMPTY_GRAVE;
            }
            ((BuildingGraveyard)this.building).ClearCurrentGrave();
        }
        return AIWorkerState.WANDER;
    }

    @NotNull
    private IAIState wander() {
        if (this.worker.getNavigation().func_75500_f()) {
            if (((BuildingGraveyard)this.building).isInBuilding(this.worker.func_233580_cy_())) {
                this.worker.getNavigation().moveToRandomPos(10, 0.6, ((BuildingGraveyard)this.building).getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            } else {
                this.walkToBuilding();
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState emptyGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (buildingGraveyard == null || this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.EMPTYING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.gui.visiblestatus.emptying")});
        this.worker.func_70031_b(this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (((TileEntityGrave)entity).isEmpty()) {
                return AIWorkerState.TRY_RESURRECT;
            }
            if (this.worker.getInventoryCitizen().isFull()) {
                return AIWorkerState.INVENTORY_FULL;
            }
            if (this.effortCounter < 100) {
                this.worker.func_184609_a(Hand.MAIN_HAND);
                this.effortCounter += this.getPrimarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            if (InventoryUtils.transferAllItemHandler((IItemHandler)((TileEntityGrave)entity).getInventory(), (IItemHandler)this.worker.getInventoryCitizen())) {
                return AIWorkerState.TRY_RESURRECT;
            }
        }
        return AIWorkerState.IDLE;
    }

    private IAIState digGrave() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.DIGGING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.gui.visiblestatus.digging")});
        this.worker.func_70031_b(this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.UNDERTAKER_RUN) > 0.0);
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        this.worker.func_70031_b(false);
        TileEntity entity = this.world.func_175625_s(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (!this.digIfAble(gravePos)) {
                return this.getState();
            }
            this.worker.decreaseSaturationForAction();
            this.worker.getCitizenData().getCitizenSkillHandler().addXpToSkill(this.getModuleForJob().getPrimarySkill(), 7.5, this.worker.getCitizenData());
            return AIWorkerState.BURY_CITIZEN;
        }
        return AIWorkerState.IDLE;
    }

    private boolean digIfAble(BlockPos position) {
        if (!this.checkForToolOrWeapon(ToolType.SHOVEL)) {
            this.equipShovel();
            this.worker.func_184609_a(this.worker.func_184600_cs());
            if (this.mineBlock(position)) {
                this.world.func_175656_a(position, Blocks.field_150350_a.func_176223_P());
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                ((BuildingGraveyard)this.building).ClearCurrentGrave();
                return true;
            }
        }
        return false;
    }

    private IAIState tryResurrect() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).getLastGraveData() == null || buildingGraveyard.getGraveToWorkOn() == null) {
            return AIWorkerState.IDLE;
        }
        this.unequip();
        @Nullable BlockPos gravePos = buildingGraveyard.getGraveToWorkOn();
        if (gravePos == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(gravePos, 3)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(gravePos);
        if (entity instanceof TileEntityGrave) {
            if (this.effortCounter < 400) {
                this.worker.func_184609_a(Hand.MAIN_HAND);
                this.effortCounter += this.getSecondarySkillLevel();
                return this.getState();
            }
            this.effortCounter = 0;
            this.shouldDumpInventory = true;
            double chance = this.getResurrectChance(buildingGraveyard);
            if (this.getTotemResurrectChance() > 0.0 && this.random.nextDouble() <= 0.01) {
                this.worker.getInventoryCitizen().extractItem(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.field_190929_cY), 1, false);
                this.worker.func_184185_a(SoundEvents.field_191263_gW, 1.0f, 1.0f);
            }
            if (chance >= this.random.nextDouble()) {
                ICitizenData citizenData = buildingGraveyard.getColony().getCitizenManager().resurrectCivilianData(buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).getLastGraveData().getCitizenDataNBT(), true, this.world, gravePos);
                MessageUtils.format("com.minecolonies.coremod.resurrect", citizenData.getName()).sendTo(buildingGraveyard.getColony()).forManagers();
                this.worker.getCitizenColonyHandler().getColony().getCitizenManager().updateCitizenMourn(citizenData, false);
                AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.CITIZEN_RESURRECT.trigger((ServerPlayerEntity)playerMP));
                buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class).setLastGraveData(null);
                this.world.func_175656_a(gravePos, Blocks.field_150350_a.func_176223_P());
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        return AIWorkerState.DIG_GRAVE;
    }

    private double getResurrectChance(@NotNull BuildingGraveyard buildingGraveyard) {
        double cap;
        double totemChance = this.getTotemResurrectChance();
        double chance = (double)buildingGraveyard.getBuildingLevel() * 0.005 + (double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Mana) * 0.00125 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RESURRECT_CHANCE) + totemChance;
        if (chance > (cap = 0.025 + (double)this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getMysticalSiteMaxBuildingLevel() * 0.005 + totemChance)) {
            chance = cap;
        }
        return chance;
    }

    private double getTotemResurrectChance() {
        int totems = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_190929_cY);
        if (totems > 0) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.UNDERTAKER_TOTEM.trigger((ServerPlayerEntity)playerMP));
        }
        if (this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.USE_TOTEM) > 0.0) {
            if (totems == 1) {
                return 0.05;
            }
            if (totems > 1) {
                return 0.075;
            }
        }
        return 0.0;
    }

    private IAIState buryCitizen() {
        @Nullable BuildingGraveyard buildingGraveyard = (BuildingGraveyard)this.building;
        GraveyardManagementModule module = buildingGraveyard.getFirstModuleOccurance(GraveyardManagementModule.class);
        if (this.checkForToolOrWeapon(ToolType.SHOVEL) || module.getLastGraveData() == null) {
            return AIWorkerState.IDLE;
        }
        this.worker.getCitizenData().setVisibleStatus(UndertakerConstants.BURYING_ICON);
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.burying")});
        if (this.burialPos == null || !this.world.func_180495_p(this.burialPos.getA()).func_196958_f()) {
            this.burialPos = ((BuildingGraveyard)this.building).getRandomFreeVisualGravePos();
        }
        if (this.burialPos == null || this.burialPos.getA() == null) {
            this.worker.getCitizenChatHandler().sendLocalizedChat((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.nospaceforgrave", new Object[]{module.getLastGraveData().getCitizenName()}));
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(this.burialPos.getA(), 3)) {
            return this.getState();
        }
        if (this.effortCounter < 400) {
            this.equipShovel();
            this.worker.func_184609_a(Hand.MAIN_HAND);
            this.effortCounter += this.getPrimarySkillLevel();
            return this.getState();
        }
        this.effortCounter = 0;
        this.unequip();
        module.buryCitizenHere(this.burialPos);
        AdvancementUtils.TriggerAdvancementPlayersForColony(this.worker.getCitizenColonyHandler().getColony(), playerMP -> AdvancementTriggers.CITIZEN_BURY.trigger((ServerPlayerEntity)playerMP));
        module.setLastGraveData(null);
        this.burialPos = null;
        this.shouldDumpInventory = true;
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory) {
            this.shouldDumpInventory = false;
            return true;
        }
        return false;
    }

    private void equipShovel() {
        this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, this.getShovelSlot());
    }

    private void unequip() {
        this.worker.getCitizenItemHandler().removeHeldItem();
    }

    private int getShovelSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.SHOVEL, 0, ((BuildingGraveyard)this.building).getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

