/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder, BuildingBuilder> {
    private static final int DEPTH_LEVEL_0 = 60;
    private static final int DEPTH_LEVEL_1 = 30;
    private static final int DEPTH_LEVEL_2 = 15;
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int SPEED_BUFF_1 = 2;
    private static final int SPEED_BUFF_2 = 4;
    private static final int ACTIONS_UNTIL_DUMP = 4096;
    private static final int LEVEL_TO_PURGE_MOBS = 4;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 100), new AITarget(AIWorkerState.START_WORKING, this::checkForWorkOrder, this::startWorkingAtOwnBuilding, 100));
        this.worker.func_98053_h(true);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public Class<BuildingBuilder> getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            ((BuildingBuilder)this.building).searchWorkOrder();
            ((BuildingBuilder)this.building).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return false;
        }
        IWorkOrder wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            ((BuildingBuilder)this.building).setProgressPos(null, null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
        if (building == null && wo instanceof WorkOrderBuilding && wo.getWorkOrderType() != WorkOrderType.REMOVE) {
            ((JobBuilder)this.job).complete();
            return false;
        }
        return true;
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobBuilder, BuildingBuilder> structure) {
        if (((JobBuilder)this.job).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((JobBuilder)this.job).getWorkOrder().setIteratorType(mode);
        }
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobBuilder, BuildingBuilder>>(new StructurePlacer(structure, ((JobBuilder)this.job).getWorkOrder().getIteratorType()), structure);
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return !this.checkForWorkOrder();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    private void killMobs() {
        if (((BuildingBuilder)this.building).getBuildingLevel() >= 4 && ((JobBuilder)this.job).getWorkOrder().getWorkOrderType() == WorkOrderType.BUILD) {
            BlockPos buildingPos = ((JobBuilder)this.job).getWorkOrder().getLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                WorldUtil.getEntitiesWithinBuilding(this.world, MonsterEntity.class, building, null).forEach(Entity::func_70106_y);
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!((BuildingBuilder)this.building).hasPurgedMobsToday()) {
            this.killMobs();
            ((BuildingBuilder)this.building).setPurgedMobsToday(true);
        }
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.findRandomPositionToWalkTo(5, currentBlock);
            if (this.workFrom == null && this.pathBackupFactor > 10) {
                this.workFrom = this.worker.func_233580_cy_();
            }
            return false;
        }
        if (this.walkToBlock(this.workFrom)) {
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.func_233580_cy_(), currentBlock) > 5L + (long)this.pathBackupFactor * 5L) {
            this.workFrom = null;
            return false;
        }
        if (this.pathBackupFactor > 1) {
            --this.pathBackupFactor;
        }
        return true;
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return false;
    }

    @Override
    public BlockState getSolidSubstitution(@NotNull BlockPos location) {
        return BlockUtils.getSubstitutionBlockAtWorld((World)this.world, (BlockPos)location).getBlockState();
    }

    @Override
    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        int initialDelay = super.getBlockMiningDelay(state, pos);
        if (pos.func_177956_o() > 60 || !((Boolean)MineColonies.getConfig().getServer().restrictBuilderUnderground.get()).booleanValue()) {
            return (int)((double)initialDelay * 0.5);
        }
        if (pos.func_177956_o() > 30) {
            return initialDelay;
        }
        if (pos.func_177956_o() < 15) {
            return initialDelay * 4;
        }
        return initialDelay * 2;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 4096;
    }

    @Override
    protected void sendCompletionMessage(IWorkOrder wo) {
        TranslationTextComponent message;
        super.sendCompletionMessage(wo);
        BlockPos position = wo.getLocation();
        boolean showManualSuffix = false;
        if (((BuildingBuilder)this.building).getManualMode()) {
            showManualSuffix = true;
            for (IWorkOrder workorder : ((BuildingBuilder)this.building).getColony().getWorkManager().getWorkOrders().values()) {
                if (workorder.getID() == wo.getID() || !workorder.isClaimedBy(this.worker.getCitizenData())) continue;
                showManualSuffix = false;
            }
        }
        switch (wo.getWorkOrderType()) {
            case REPAIR: {
                message = new TranslationTextComponent("entity.builder.messagerepaircomplete", new Object[]{wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
                break;
            }
            case REMOVE: {
                message = new TranslationTextComponent("entity.builder.messageremovalcomplete", new Object[]{wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
                break;
            }
            default: {
                message = new TranslationTextComponent("entity.builder.messagebuildcomplete", new Object[]{wo.getDisplayName(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
        }
        if (showManualSuffix) {
            message.func_230529_a_((ITextComponent)new TranslationTextComponent("entity.builder.messagebuildmanualfinish"));
        }
        this.worker.getCitizenChatHandler().sendLocalizedChat((ITextComponent)message);
    }
}

