/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.alchemist;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingAlchemist;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobAlchemist;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.BlockParticleEffectMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.AirBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BrewingStandBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkAlchemist
extends AbstractEntityAICrafting<JobAlchemist, BuildingAlchemist> {
    private static final double BASE_XP_GAIN = 5.0;
    private static final int DELAY_TO_HARVEST_NETHERWART = 30;
    private static final int DELAY_TO_HARVEST_MISTLETOE = 30;
    private BlockPos fuelPos = null;
    private IAIState preFuelState = null;
    private BlockPos walkTo;

    public EntityAIWorkAlchemist(@NotNull JobAlchemist alchemistJob) {
        super(alchemistJob);
        super.registerTargets(new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::isFuelNeeded, this::checkBrewingStandFuel, 200), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.EVENT, this::accelerateBrewingStand, this::getState, 20), new AITarget((IAIState)AIWorkerState.START_USING_BREWINGSTAND, this::fillUpBrewingStand, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD, this::retrieveBrewableFromBrewingStand, 20), new AITarget((IAIState)AIWorkerState.RETRIEVING_USED_FUEL_FROM_BREWINGSTAND, this::retrieveUsedFuel, 20), new AITarget((IAIState)AIWorkerState.ADD_FUEL_TO_BREWINGSTAND, this::addFuelToBrewingStand, 20), new AITarget((IAIState)AIWorkerState.HARVEST_MISTLETOE, this::harvestMistleToe, 20), new AITarget((IAIState)AIWorkerState.HARVEST_NETHERWART, this::harvestNetherWart, 20));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState harvestNetherWart() {
        if (this.walkTo == null) {
            List<BlockPos> soilList = ((BuildingAlchemist)this.building).getAllSoilPositions();
            if (soilList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomSoil = soilList.get(this.worker.func_70681_au().nextInt(soilList.size()));
            if (!WorldUtil.isBlockLoaded((IWorld)this.world, randomSoil)) return AIWorkerState.HARVEST_NETHERWART;
            if (this.world.func_180495_p(randomSoil).func_177230_c() == Blocks.field_150425_aM) {
                if (this.world.func_180495_p(randomSoil.func_177984_a()).func_177230_c() == Blocks.field_150388_bm) {
                    this.walkTo = randomSoil;
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.world.func_175623_d(randomSoil.func_177984_a()) && !this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((IItemProvider)Items.field_151075_bm, 1), 16, 1)) {
                    return AIWorkerState.IDLE;
                }
                this.walkTo = randomSoil;
                return AIWorkerState.HARVEST_NETHERWART;
            } else {
                ((BuildingAlchemist)this.building).removeSoilPosition(randomSoil);
            }
            return AIWorkerState.HARVEST_NETHERWART;
        }
        if (WorldUtil.isBlockLoaded((IWorld)this.world, this.walkTo) && this.world.func_180495_p(this.walkTo).func_177230_c() == Blocks.field_150425_aM) {
            if (this.walkToBlock(this.walkTo)) {
                return AIWorkerState.HARVEST_NETHERWART;
            }
            BlockState aboveState = this.world.func_180495_p(this.walkTo.func_177984_a());
            if (!(aboveState.func_177230_c() instanceof AirBlock)) {
                if (aboveState.func_177230_c() == Blocks.field_150388_bm && (Integer)aboveState.func_177229_b((Property)NetherWartBlock.field_176486_a) < 2) {
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                if (!this.mineBlock(this.walkTo.func_177984_a())) return AIWorkerState.HARVEST_NETHERWART;
                this.walkTo = null;
                this.worker.decreaseSaturationForContinuousAction();
                return AIWorkerState.IDLE;
            }
            if (!this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((IItemProvider)Items.field_151075_bm, 1), 16, 1)) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(Items.field_151075_bm);
            if (slot == -1) {
                this.walkTo = null;
                return AIWorkerState.IDLE;
            }
            this.world.func_175656_a(this.walkTo.func_177984_a(), Blocks.field_150388_bm.func_176223_P());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        this.walkTo = null;
        return AIWorkerState.IDLE;
    }

    private IAIState harvestMistleToe() {
        if (this.checkForToolOrWeapon(ToolType.SHEARS)) {
            return AIWorkerState.IDLE;
        }
        if (this.walkTo == null) {
            List<BlockPos> leaveList = ((BuildingAlchemist)this.building).getAllLeavePositions();
            if (leaveList.isEmpty()) {
                return AIWorkerState.IDLE;
            }
            BlockPos randomLeaf = leaveList.get(this.worker.func_70681_au().nextInt(leaveList.size()));
            if (WorldUtil.isBlockLoaded((IWorld)this.world, randomLeaf)) {
                if (this.world.func_180495_p(randomLeaf).func_177230_c() instanceof LeavesBlock) {
                    this.walkTo = randomLeaf;
                } else {
                    ((BuildingAlchemist)this.building).removeLeafPosition(randomLeaf);
                }
            }
            return AIWorkerState.HARVEST_MISTLETOE;
        }
        if (WorldUtil.isBlockLoaded((IWorld)this.world, this.walkTo) && this.world.func_180495_p(this.walkTo).func_177230_c() instanceof LeavesBlock) {
            if (this.walkToBlock(this.walkTo)) {
                return AIWorkerState.HARVEST_MISTLETOE;
            }
            BlockState state = this.world.func_180495_p(this.walkTo);
            int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack.func_77973_b() instanceof ShearsItem);
            this.worker.getCitizenItemHandler().setHeldItem(Hand.MAIN_HAND, slot);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            this.world.func_184133_a(null, this.walkTo, state.getSoundType((IWorldReader)this.world, this.walkTo, (Entity)this.worker).func_185845_c(), SoundCategory.BLOCKS, state.getSoundType((IWorldReader)this.world, this.walkTo, (Entity)this.worker).func_185843_a(), state.getSoundType((IWorldReader)this.world, this.walkTo, (Entity)this.worker).func_185847_b());
            Network.getNetwork().sendToTrackingEntity(new BlockParticleEffectMessage(this.walkTo, state, this.worker.func_70681_au().nextInt(7) - 1), (Entity)this.worker);
            if (this.worker.func_70681_au().nextInt(120) < 1) {
                this.worker.decreaseSaturationForContinuousAction();
                InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((IItemProvider)ModItems.mistletoe, 1));
                this.walkTo = null;
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
                return AIWorkerState.INVENTORY_FULL;
            }
        } else {
            this.walkTo = null;
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.HARVEST_MISTLETOE;
    }

    @Override
    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((JobAlchemist)this.job).getTaskQueue().isEmpty() || ((JobAlchemist)this.job).getCurrentTask() == null) {
            if (this.worker.getNavigation().func_75500_f()) {
                if (this.worker.func_70681_au().nextInt(30) < 1) {
                    return AIWorkerState.HARVEST_NETHERWART;
                }
                if (this.worker.func_70681_au().nextInt(30) < 1) {
                    return AIWorkerState.HARVEST_MISTLETOE;
                }
                if (((BuildingAlchemist)this.building).isInBuilding(this.worker.func_233580_cy_())) {
                    this.worker.getNavigation().moveToRandomPos(10, 0.6, ((BuildingAlchemist)this.building).getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobAlchemist)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    @Override
    public Class<BuildingAlchemist> getExpectedBuildingClass() {
        return BuildingAlchemist.class;
    }

    @Override
    protected int getExtendedCount(ItemStack stack) {
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.field_150382_bo) {
            int count = 0;
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                if (!WorldUtil.isBlockLoaded((IWorld)this.world, pos)) continue;
                TileEntity entity = this.world.func_175625_s(pos);
                if (entity instanceof BrewingStandTileEntity) {
                    BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
                    for (int slot = 0; slot < 4; ++slot) {
                        ItemStack stackInSlot = brewingStand.func_70301_a(slot);
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, stackInSlot).booleanValue()) continue;
                        count += stackInSlot.func_190916_E();
                    }
                    continue;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
            return count;
        }
        return 0;
    }

    @Override
    protected IAIState getRecipe() {
        IRequest currentTask = ((JobAlchemist)this.job).getCurrentTask();
        if (currentTask == null) {
            this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)currentTask.getRequest()).getCount());
        BlockPos brewingStandPos = this.getPositionOfBrewingStandToRetrieveFrom();
        if (brewingStandPos != null) {
            this.currentRequest = currentTask;
            this.walkTo = brewingStandPos;
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() == Blocks.field_150382_bo) {
            for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
                TileEntity entity = this.world.func_175625_s(pos);
                if (entity instanceof BrewingStandTileEntity) {
                    BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
                    if (brewingStand.field_145946_k <= 0 && ItemStackUtils.isEmpty(brewingStand.func_70301_a(3)).booleanValue()) continue;
                    return AIWorkerState.CRAFT;
                }
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
            }
        }
        return super.getRecipe();
    }

    private int countOfBubblingBrewingStands() {
        int count = 0;
        World world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof BrewingStandTileEntity) {
                BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
                if (brewingStand.field_145946_k <= 0) continue;
                ++count;
                continue;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return count;
    }

    private boolean accelerateBrewingStand() {
        int accelerationTicks = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill()) / 10 * 2;
        World world = ((BuildingAlchemist)this.building).getColony().getWorld();
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            TileEntity entity;
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos) || !((entity = world.func_175625_s(pos)) instanceof BrewingStandTileEntity)) continue;
            BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
            for (int i = 0; i < accelerationTicks; ++i) {
                if (brewingStand.field_145946_k <= 0) continue;
                brewingStand.func_73660_a();
            }
        }
        return false;
    }

    private boolean isFuelNeeded() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150382_bo) {
            return false;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((IWorld)this.world, pos)) continue;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof BrewingStandTileEntity)) {
                ((BuildingAlchemist)this.building).removeBrewingStand(pos);
                continue;
            }
            BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
            if (brewingStand.field_145946_k > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
            return this.getState() != AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return false;
    }

    private IAIState checkBrewingStandFuel() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150382_bo) {
            return this.getState();
        }
        World world = ((BuildingAlchemist)this.building).getColony().getWorld();
        if (!(InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151065_br) || InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.field_151065_br) || ((BuildingAlchemist)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class)))) {
            this.worker.getCitizenData().createRequestAsync(new Stack(new ItemStack((IItemProvider)Items.field_151065_br), 8 * ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size(), 1));
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            if (!WorldUtil.isBlockLoaded((IWorld)world, pos)) continue;
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof BrewingStandTileEntity) {
                BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
                if (brewingStand.field_145946_k > 0 || !ItemStackUtils.hasBrewableAndNoFuel(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) continue;
                if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151065_br)) {
                    if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.field_151065_br)) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.func_77973_b() == Items.field_151065_br, 8);
                        this.walkTo = null;
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    return this.getState();
                }
                this.fuelPos = pos;
                if (this.preFuelState == null) {
                    this.preFuelState = this.getState();
                }
                return AIWorkerState.ADD_FUEL_TO_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        return this.getState();
    }

    private IAIState addFuelToBrewingStand() {
        TileEntity entity;
        if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151065_br)) {
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, Items.field_151065_br)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(item -> item.func_77973_b() == Items.field_151065_br, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.preFuelState = null;
            this.fuelPos = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.fuelPos == null || this.walkToBlock(this.fuelPos)) {
            return this.getState();
        }
        if (WorldUtil.isBlockLoaded((IWorld)this.world, this.fuelPos) && (entity = this.world.func_175625_s(this.fuelPos)) instanceof BrewingStandTileEntity) {
            BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), Items.field_151065_br) && (ItemStackUtils.hasBrewableAndNoFuel(brewingStand) || ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), item -> item.func_77973_b() == Items.field_151065_br, 8, (IItemHandler)new InvWrapper((IInventory)brewingStand), 4);
                if (this.preFuelState != null && this.preFuelState != AIWorkerState.ADD_FUEL_TO_BREWINGSTAND) {
                    IAIState returnState = this.preFuelState;
                    this.preFuelState = null;
                    this.fuelPos = null;
                    return returnState;
                }
            }
        }
        this.preFuelState = null;
        this.fuelPos = null;
        return AIWorkerState.START_WORKING;
    }

    private int getMaxUsableBrewingStands() {
        int maxSkillBrewingStand = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill()) / 10 + 1;
        return Math.min(maxSkillBrewingStand, ((BuildingAlchemist)this.building).getAllBrewingStandPositions().size());
    }

    private BlockPos getPositionOfBrewingStandToRetrieveFrom() {
        if (this.currentRecipeStorage == null || this.currentRecipeStorage.getIntermediate() != Blocks.field_150382_bo) {
            return null;
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof BrewingStandTileEntity)) continue;
            BrewingStandTileEntity brewingStand = (BrewingStandTileEntity)entity;
            int countInResultSlot = 0;
            for (int slot = 0; slot < 3; ++slot) {
                if (ItemStackUtils.isEmpty(brewingStand.func_70301_a(slot)).booleanValue() || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.currentRecipeStorage.getPrimaryOutput(), brewingStand.func_70301_a(slot)).booleanValue()) continue;
                countInResultSlot = brewingStand.func_70301_a(slot).func_190916_E();
            }
            if (brewingStand.field_145946_k > 0 || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(brewingStand.func_70301_a(3)).booleanValue()) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        if (storage.getIntermediate() != Blocks.field_150382_bo) {
            return super.checkForItems(storage);
        }
        List<ItemStorage> input = storage.getCleanedInput();
        int countInBewingStand = this.getExtendedCount(storage.getPrimaryOutput());
        int outputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, storage.getPrimaryOutput()));
        for (ItemStorage inputStorage : input) {
            int inputInInv;
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, inputStorage.getItemStack()) != false;
            int inputInBrewingStand = this.getExtendedCount(inputStorage.getItemStack());
            if (countInBewingStand + inputInBrewingStand + (inputInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate)) + outputInInv < inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount() && InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, inputStorage.getAmount() * (((JobAlchemist)this.job).getMaxCraftingCount() - countInBewingStand - inputInBrewingStand));
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            int countOfInput = inputInInv + InventoryUtils.getCountFromBuilding((IBuilding)this.building, predicate) + countInBewingStand + inputInBrewingStand + outputInInv;
            if (countOfInput >= inputStorage.getAmount() * ((JobAlchemist)this.job).getMaxCraftingCount()) continue;
            ((JobAlchemist)this.job).finishRequest(false);
            this.resetValues();
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveBrewableFromBrewingStand() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof BrewingStandTileEntity)) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        this.walkTo = null;
        int preExtractCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack));
        for (int slot = 0; slot < 3; ++slot) {
            if (ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(slot)).booleanValue()) continue;
            this.extractFromBrewingStandSlot((BrewingStandTileEntity)entity, slot);
        }
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(((PublicCrafting)this.currentRequest.getRequest()).getStack(), stack)) - preExtractCount;
        if (resultCount > 0) {
            ItemStack stack2 = ((PublicCrafting)this.currentRequest.getRequest()).getStack().func_77946_l();
            stack2.func_190920_e(resultCount);
            this.currentRequest.addDelivery(stack2);
            int step = resultCount / this.currentRecipeStorage.getPrimaryOutput().getStack().func_190916_E();
            ((JobAlchemist)this.job).setCraftCounter(((JobAlchemist)this.job).getCraftCounter() + step);
            ((JobAlchemist)this.job).setProgress(((JobAlchemist)this.job).getProgress() - step);
            if (((JobAlchemist)this.job).getMaxCraftingCount() == 0) {
                ((JobAlchemist)this.job).setMaxCraftingCount(((PublicCrafting)this.currentRequest.getRequest()).getCount());
            }
            if (((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount() && ((JobAlchemist)this.job).getProgress() <= 0) {
                ((JobAlchemist)this.job).finishRequest(true);
                this.resetValues();
                this.currentRecipeStorage = null;
                this.incrementActionsDoneAndDecSaturation();
                return AIWorkerState.INVENTORY_FULL;
            }
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private IAIState retrieveUsedFuel() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
        if (this.walkTo == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof BrewingStandTileEntity) || ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(4)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromBrewingStandSlot((BrewingStandTileEntity)entity, 4);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromBrewingStandSlot(BrewingStandTileEntity brewingStand, int slot) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)brewingStand), slot, (IItemHandler)this.worker.getInventoryCitizen());
        if (slot <= 3 && slot >= 0) {
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
    }

    private IAIState checkIfAbleToSmelt() {
        int burning = this.countOfBubblingBrewingStands();
        if (burning > 0 && (burning >= this.getMaxUsableBrewingStands() || ((JobAlchemist)this.job).getCraftCounter() + ((JobAlchemist)this.job).getProgress() >= ((JobAlchemist)this.job).getMaxCraftingCount())) {
            this.setDelay(20);
            return this.getState();
        }
        for (BlockPos pos : ((BuildingAlchemist)this.building).getAllBrewingStandPositions()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof BrewingStandTileEntity) {
                if (!ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(3)).booleanValue()) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_BREWINGSTAND;
            }
            ((BuildingAlchemist)this.building).removeBrewingStand(pos);
        }
        if (burning > 0) {
            this.setDelay(20);
        }
        return this.getState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private IAIState fillUpBrewingStand() {
        block17: {
            Predicate<ItemStack> potion;
            int maxBrewingStands;
            BrewingStandTileEntity brewingStand;
            TileEntity entity;
            int burningCount;
            block18: {
                block14: {
                    int amountOfIngredientInInv;
                    int amountOfIngredientInBuilding;
                    int targetCount;
                    Predicate<ItemStack> ingredient;
                    block19: {
                        int resultInCitizenInv;
                        int resultInBrewingStand;
                        block15: {
                            int amountOfPotionInInv;
                            int amountOfPotionInBuilding;
                            int targetCount2;
                            block16: {
                                if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
                                    if (this.worker.getCitizenData() != null) {
                                        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
                                    }
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                if (this.walkTo == null || this.world.func_180495_p(this.walkTo).func_177230_c() != Blocks.field_150382_bo) {
                                    this.walkTo = null;
                                    this.setDelay(5);
                                    return AIWorkerState.START_WORKING;
                                }
                                burningCount = this.countOfBubblingBrewingStands();
                                entity = this.world.func_175625_s(this.walkTo);
                                if (!(entity instanceof BrewingStandTileEntity) || this.currentRecipeStorage == null) break block14;
                                brewingStand = (BrewingStandTileEntity)entity;
                                maxBrewingStands = this.getMaxUsableBrewingStands();
                                resultInBrewingStand = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
                                resultInCitizenInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
                                if (!ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(0)).booleanValue() && !ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(1)).booleanValue() && !ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(2)).booleanValue()) break block15;
                                ItemStack potionStack = this.currentRecipeStorage.getCleanedInput().get(1).getItemStack();
                                potion = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(potionStack, stack);
                                int potionInBrewingStand = this.getExtendedCount(potionStack);
                                targetCount2 = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().func_190916_E() - potionInBrewingStand - resultInBrewingStand - resultInCitizenInv;
                                if (targetCount2 <= 0) {
                                    return AIWorkerState.START_WORKING;
                                }
                                amountOfPotionInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, potion);
                                amountOfPotionInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion);
                                if (this.worker.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                                    this.worker.func_184611_a(Hand.MAIN_HAND, potionStack.func_77946_l());
                                }
                                if (amountOfPotionInInv <= 0) break block16;
                                if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                                break block18;
                            }
                            if (amountOfPotionInBuilding >= targetCount2 - amountOfPotionInInv && this.currentRecipeStorage.getIntermediate() == Blocks.field_150382_bo) {
                                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(potion, targetCount2);
                                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                            }
                            ((JobAlchemist)this.job).finishRequest(false);
                            this.resetValues();
                            this.walkTo = null;
                            return AIWorkerState.IDLE;
                        }
                        if (!ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(3)).booleanValue()) break block17;
                        ItemStack ingredientStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
                        ingredient = stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(ingredientStack, stack);
                        int ingredientInBrewingStand = this.getExtendedCount(ingredientStack);
                        targetCount = ((PublicCrafting)this.currentRequest.getRequest()).getCount() * this.currentRecipeStorage.getPrimaryOutput().func_190916_E() - ingredientInBrewingStand * 3 - resultInBrewingStand - resultInCitizenInv;
                        if (targetCount <= 0) {
                            return AIWorkerState.START_WORKING;
                        }
                        amountOfIngredientInBuilding = InventoryUtils.getCountFromBuilding((IBuilding)this.building, ingredient);
                        amountOfIngredientInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient);
                        if (this.worker.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                            this.worker.func_184611_a(Hand.MAIN_HAND, ingredientStack.func_77946_l());
                        }
                        if (amountOfIngredientInInv <= 0) break block19;
                        if (!ItemStackUtils.hasFuelAndNoBrewable(brewingStand) && !ItemStackUtils.hasNeitherFuelNorBrewable(brewingStand)) break block17;
                        int toTransfer = 0;
                        if (burningCount < maxBrewingStands) {
                            toTransfer = 1;
                        }
                        if (toTransfer <= 0) break block17;
                        if (this.walkToBlock(this.walkTo)) {
                            return this.getState();
                        }
                        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.walkTo);
                        InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), ingredient, toTransfer, (IItemHandler)new InvWrapper((IInventory)brewingStand), 3);
                        break block17;
                    }
                    if (amountOfIngredientInBuilding >= targetCount - amountOfIngredientInInv && this.currentRecipeStorage.getIntermediate() == Blocks.field_150382_bo) {
                        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(ingredient, targetCount);
                        return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                    }
                    ((JobAlchemist)this.job).finishRequest(false);
                    this.resetValues();
                    this.walkTo = null;
                    return AIWorkerState.IDLE;
                }
                if (this.world.func_180495_p(this.walkTo).func_177230_c() instanceof BrewingStandBlock) break block17;
                ((BuildingAlchemist)this.building).removeBrewingStand(this.walkTo);
                break block17;
            }
            for (int slot = 0; slot < 3; ++slot) {
                if (!ItemStackUtils.isEmpty(((BrewingStandTileEntity)entity).func_70301_a(slot)).booleanValue()) continue;
                int toTransfer = 0;
                if (burningCount < maxBrewingStands) {
                    toTransfer = 1;
                }
                if (toTransfer <= 0) continue;
                if (this.walkToBlock(this.walkTo)) {
                    return this.getState();
                }
                this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.walkTo);
                InventoryUtils.transferXInItemHandlerIntoSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), potion, toTransfer, (IItemHandler)new InvWrapper((IInventory)brewingStand), slot);
            }
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        if (this.currentRecipeStorage != null && this.currentRequest == null) {
            this.currentRequest = ((JobAlchemist)this.job).getCurrentTask();
        }
        if (this.currentRecipeStorage != null && this.currentRecipeStorage.getIntermediate() != Blocks.field_150382_bo) {
            return super.craft();
        }
        if (((BuildingAlchemist)this.building).getAllBrewingStandPositions().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos posOfOven = this.getPositionOfBrewingStandToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving")});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_BREWINGSTAMD;
        }
        if (this.currentRequest != null && ((JobAlchemist)this.job).getMaxCraftingCount() > 0 && ((JobAlchemist)this.job).getCraftCounter() >= ((JobAlchemist)this.job).getMaxCraftingCount()) {
            ((JobAlchemist)this.job).finishRequest(true);
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.checkIfAbleToSmelt();
    }
}

