/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAISkeleton<J extends IJob<?>>
extends Goal {
    @NotNull
    protected final J job;
    @NotNull
    protected final AbstractEntityCitizen worker;
    protected final World world;
    @NotNull
    private final ITickRateStateMachine<IAIState> stateMachine;

    protected AbstractAISkeleton(@NotNull J job) {
        if (!job.getCitizen().getEntity().isPresent()) {
            throw new IllegalArgumentException("Cannot instantiate a AI from a Job that is attached to a Citizen without entity.");
        }
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.job = job;
        this.worker = this.job.getCitizen().getEntity().get();
        this.world = CompatibilityUtils.getWorldFromCitizen(this.worker);
        this.stateMachine = new TickRateStateMachine<AIWorkerState>(AIWorkerState.INIT, this::onException);
        this.stateMachine.setTickRate((Integer)MineColonies.getConfig().getServer().updateRate.get());
    }

    public void registerTarget(TickingTransition<IAIState> target) {
        this.stateMachine.addTransition(target);
    }

    protected final void registerTargets(TickingTransition<IAIState> ... targets) {
        Arrays.asList(targets).forEach(this::registerTarget);
    }

    public final boolean func_75250_a() {
        return this.worker.getDesiredActivity() == DesiredActivity.WORK;
    }

    public final boolean func_75253_b() {
        return super.func_75253_b();
    }

    public final void func_75249_e() {
        this.worker.getCitizenStatusHandler().setStatus(Status.WORKING);
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
    }

    public final void func_75251_c() {
        this.resetAI();
        this.worker.getCitizenData().setVisibleStatus(null);
    }

    public final void func_75246_d() {
        this.stateMachine.tick();
    }

    protected void onException(RuntimeException e) {
    }

    public final void func_220684_a(EnumSet<Goal.Flag> mutexBits) {
        super.func_220684_a(mutexBits);
    }

    public final IAIState getState() {
        return (IAIState)this.stateMachine.getState();
    }

    public int getTickRate() {
        return this.stateMachine.getTickRate();
    }

    public boolean canBeInterrupted() {
        return this.getState().isOkayToEat();
    }

    public void resetAI() {
        this.stateMachine.reset();
    }

    public ITickRateStateMachine<IAIState> getStateAI() {
        return this.stateMachine;
    }

    public void onRemoval() {
        this.worker.func_184201_a(EquipmentSlotType.CHEST, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.FEET, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.LEGS, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
        this.worker.func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
    }
}

