/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public class CommandShowClaim
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        ServerWorld level = ((CommandSource)context.getSource()).func_197023_e();
        BlockPos pos = new BlockPos(((CommandSource)context.getSource()).func_197036_d());
        try {
            pos = BlockPosArgument.func_197273_a(context, (String)"location");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Chunk chunk = (Chunk)level.func_217349_x(pos);
        IColonyTagCapability cap = chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("No capability for chunk found!"));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)this.buildClaimCommandResult(cap, pos, level), true);
        return 1;
    }

    private IFormattableTextComponent buildClaimCommandResult(IColonyTagCapability cap, BlockPos pos, ServerWorld level) {
        IColony colony;
        IFormattableTextComponent text = new TranslationTextComponent("Claim data of chunk at: %sX %sZ\n", new Object[]{pos.func_177958_n(), pos.func_177952_p()}).func_240699_a_(TextFormatting.DARK_AQUA);
        if (!cap.getStaticClaimColonies().isEmpty()) {
            text.func_230529_a_((ITextComponent)new TranslationTextComponent("OwnerID:%s Direct colony claims:\n", new Object[]{cap.getOwningColony()}).func_240699_a_(TextFormatting.GOLD));
            Iterator<Object> iterator = cap.getStaticClaimColonies().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                colony = IColonyManager.getInstance().getColonyByDimension(n, (RegistryKey<World>)level.func_234923_W_());
                if (colony == null) {
                    text.func_230529_a_((ITextComponent)new TranslationTextComponent("ID: %s Name: Unkown Colony\n", new Object[]{n}));
                    continue;
                }
                text.func_230529_a_((ITextComponent)new TranslationTextComponent("ID: %s Name: %s\n", new Object[]{n, colony.getName()}));
            }
        }
        if (!cap.getAllClaimingBuildings().isEmpty()) {
            text.func_230529_a_((ITextComponent)new TranslationTextComponent("Building claims:\n").func_240699_a_(TextFormatting.GOLD));
            for (Map.Entry entry : cap.getAllClaimingBuildings().entrySet()) {
                colony = IColonyManager.getInstance().getColonyByDimension((Integer)entry.getKey(), (RegistryKey<World>)level.func_234923_W_());
                for (BlockPos buildingPos : (Set)entry.getValue()) {
                    if (colony != null) {
                        IBuilding building = colony.getBuildingManager().getBuilding(buildingPos);
                        if (building != null) {
                            text.func_230529_a_((ITextComponent)new TranslationTextComponent("ID: %s Building: %s Pos: %s\n", new Object[]{entry.getKey(), new TranslationTextComponent(building.getBuildingDisplayName()), buildingPos}));
                            continue;
                        }
                        text.func_230529_a_((ITextComponent)new TranslationTextComponent("ID: %s Building: Unknown pos: %s\n", new Object[]{entry.getKey(), buildingPos}));
                        continue;
                    }
                    text.func_230529_a_((ITextComponent)new TranslationTextComponent("ID: %s Building: Unknown Pos: %s\n", new Object[]{entry.getKey(), buildingPos}));
                }
            }
        }
        return text;
    }

    @Override
    public String getName() {
        return "claiminfo";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("location", BlockPosArgument.func_197276_a()).executes(this::checkPreConditionAndExecute))).executes(this::checkPreConditionAndExecute);
    }
}

