/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.workorders.view;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.workorders.view.AbstractWorkOrderView;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WorkOrderBuildingView
extends AbstractWorkOrderView {
    private String customBuildingName;
    private String customParentBuildingName;
    private String parentTranslationKey;

    @Override
    public ITextComponent getDisplayName() {
        TranslationTextComponent nameComponent;
        TranslationTextComponent buildingComponent;
        Object object = buildingComponent = this.customBuildingName.isEmpty() ? new TranslationTextComponent(this.getWorkOrderName()) : new StringTextComponent(this.customBuildingName);
        if (this.parentTranslationKey.isEmpty()) {
            nameComponent = buildingComponent;
        } else {
            TranslationTextComponent parentComponent = this.customParentBuildingName.isEmpty() ? new TranslationTextComponent(this.parentTranslationKey) : new StringTextComponent(this.customParentBuildingName);
            nameComponent = new TranslationTextComponent("%s / %s", new Object[]{parentComponent, buildingComponent});
        }
        return this.getOrderTypePrefix((ITextComponent)nameComponent);
    }

    private ITextComponent getOrderTypePrefix(ITextComponent nameComponent) {
        switch (this.getWorkOrderType()) {
            case BUILD: {
                return new TranslationTextComponent("com.minecolonies.coremod.action.builder.building", new Object[]{nameComponent});
            }
            case UPGRADE: {
                return new TranslationTextComponent("com.minecolonies.coremod.action.builder.upgrading", new Object[]{nameComponent, this.getCurrentLevel(), this.getTargetLevel()});
            }
            case REPAIR: {
                return new TranslationTextComponent("com.minecolonies.coremod.action.builder.repairing", new Object[]{nameComponent});
            }
            case REMOVE: {
                return new TranslationTextComponent("com.minecolonies.coremod.action.builder.removing", new Object[]{nameComponent});
            }
        }
        return nameComponent;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        this.customBuildingName = buf.func_150789_c(Short.MAX_VALUE);
        this.customParentBuildingName = buf.func_150789_c(Short.MAX_VALUE);
        this.parentTranslationKey = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public boolean shouldShowIn(IBuildingView view) {
        return view instanceof ITownHallView || view instanceof BuildingBuilder.View;
    }
}

