/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.SerializationIdentifierConstants;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StationRequestResolver;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class StationRequestResolverFactory
implements IRequestResolverFactory<StationRequestResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";

    @Override
    @NotNull
    public TypeToken<? extends StationRequestResolver> getFactoryOutputType() {
        return TypeToken.of(StationRequestResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public StationRequestResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) throws IllegalArgumentException {
        return new StationRequestResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN));
    }

    @Override
    @NotNull
    public CompoundNBT serialize(@NotNull IFactoryController controller, @NotNull StationRequestResolver StationRequestResolver2) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_TOKEN, (INBT)controller.serialize(StationRequestResolver2.getId()));
        compound.func_218657_a(NBT_LOCATION, (INBT)controller.serialize(StationRequestResolver2.getLocation()));
        return compound;
    }

    @Override
    @NotNull
    public StationRequestResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT nbt) {
        IToken token = (IToken)controller.deserialize(nbt.func_74775_l(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.func_74775_l(NBT_LOCATION));
        return new StationRequestResolver(location, token);
    }

    @Override
    public void serialize(IFactoryController controller, StationRequestResolver input, PacketBuffer packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
    }

    @Override
    @NotNull
    public StationRequestResolver deserialize(IFactoryController controller, @NotNull PacketBuffer buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        return new StationRequestResolver(location, token);
    }

    @Override
    public short getSerializationId() {
        return SerializationIdentifierConstants.STATION_REQUEST_RESOLVER_ID;
    }
}

