/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.ldtteam.structurize.management.Structures;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.client.ColonyStylesMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewWorkOrderMessage;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ColonyPackageManager
implements IColonyPackageManager {
    @NotNull
    private Set<ServerPlayerEntity> closeSubscribers = new HashSet<ServerPlayerEntity>();
    private Set<ServerPlayerEntity> importantColonyPlayers = new HashSet<ServerPlayerEntity>();
    private Set<ServerPlayerEntity> newSubscribers = new HashSet<ServerPlayerEntity>();
    private boolean isDirty = false;
    private int ticksPassed = 0;
    private int lastContactInHours = 0;
    private final Colony colony;

    public ColonyPackageManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public int getLastContactInHours() {
        return this.lastContactInHours;
    }

    @Override
    public void setLastContactInHours(int lastContactInHours) {
        this.lastContactInHours = lastContactInHours;
    }

    @Override
    public Set<ServerPlayerEntity> getCloseSubscribers() {
        return this.closeSubscribers;
    }

    @Override
    public void updateSubscribers() {
        World world = this.colony.getWorld();
        if (world == null || world.func_73046_m() == null) {
            return;
        }
        this.updateColonyViews();
    }

    @Override
    public void updateAwayTime() {
        if (this.importantColonyPlayers.isEmpty()) {
            if (this.ticksPassed >= 72000) {
                this.ticksPassed = 0;
                ++this.lastContactInHours;
                this.colony.markDirty();
            }
            this.ticksPassed += 100;
        } else if (this.lastContactInHours != 0) {
            this.lastContactInHours = 0;
            this.ticksPassed = 0;
            this.colony.markDirty();
        }
    }

    public void updateColonyViews() {
        if (!this.closeSubscribers.isEmpty() || !this.newSubscribers.isEmpty()) {
            this.sendColonyViewPackets();
            this.sendPermissionsPackets();
            this.sendWorkOrderPackets();
            this.colony.getCitizenManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getVisitorManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.colony.getBuildingManager().sendPackets(this.closeSubscribers, this.newSubscribers);
            this.sendSchematicsPackets();
        }
        if (this.newSubscribers.isEmpty()) {
            this.isDirty = false;
        }
        this.colony.getPermissions().clearDirty();
        this.colony.getBuildingManager().clearDirty();
        this.colony.getCitizenManager().clearDirty();
        this.newSubscribers = new HashSet<ServerPlayerEntity>();
    }

    @Override
    public void sendColonyViewPackets() {
        if (this.isDirty || !this.newSubscribers.isEmpty()) {
            PacketBuffer colonyPacketBuffer = new PacketBuffer(Unpooled.buffer());
            ColonyView.serializeNetworkData(this.colony, colonyPacketBuffer, !this.newSubscribers.isEmpty());
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewMessage(this.colony, colonyPacketBuffer, this.newSubscribers.contains(player)), (ServerPlayerEntity)player));
        }
        this.colony.getRequestManager().setDirty(false);
    }

    @Override
    public void sendPermissionsPackets() {
        Permissions permissions = this.colony.getPermissions();
        if (permissions.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new PermissionsMessage.View(this.colony, permissions.getRank((PlayerEntity)player)), (ServerPlayerEntity)player));
        }
    }

    @Override
    public void sendWorkOrderPackets() {
        IWorkManager workManager = this.colony.getWorkManager();
        if (workManager.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            players.addAll(this.closeSubscribers);
            players.addAll(this.newSubscribers);
            ArrayList<IWorkOrder> workOrders = new ArrayList<IWorkOrder>(workManager.getWorkOrders().values());
            players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewWorkOrderMessage(this.colony, workOrders), (ServerPlayerEntity)player));
            workManager.setDirty(false);
        }
    }

    @Override
    public void sendSchematicsPackets() {
        if (Structures.isDirty() || !this.newSubscribers.isEmpty()) {
            HashSet<ServerPlayerEntity> players = new HashSet<ServerPlayerEntity>();
            if (this.isDirty) {
                players.addAll(this.closeSubscribers);
            }
            players.addAll(this.newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyStylesMessage(), (ServerPlayerEntity)player));
        }
        Structures.clearDirty();
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    @Override
    public void addCloseSubscriber(@NotNull ServerPlayerEntity subscriber) {
        if (!this.closeSubscribers.contains(subscriber)) {
            this.closeSubscribers.add(subscriber);
            this.newSubscribers.add(subscriber);
        }
    }

    @Override
    public void removeCloseSubscriber(@NotNull ServerPlayerEntity player) {
        this.newSubscribers.remove(player);
        this.closeSubscribers.remove(player);
    }

    @Override
    public void addImportantColonyPlayer(@NotNull ServerPlayerEntity subscriber) {
        this.importantColonyPlayers.add(subscriber);
        this.newSubscribers.add(subscriber);
    }

    @Override
    public void removeImportantColonyPlayer(@NotNull ServerPlayerEntity subscriber) {
        this.importantColonyPlayers.remove(subscriber);
        this.newSubscribers.remove(subscriber);
    }

    @Override
    public Set<ServerPlayerEntity> getImportantColonyPlayers() {
        return this.importantColonyPlayers;
    }
}

