/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs.registry;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.IJobView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.Log;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JobDataManager
implements IJobDataManager {
    @Override
    @Nullable
    public IJob<?> createFrom(ICitizenData citizen, @NotNull CompoundNBT compound) {
        ResourceLocation jobType = compound.func_150296_c().contains("type") ? new ResourceLocation(compound.func_74779_i("type")) : ModJobs.PLACEHOLDER_ID;
        IJob<?> job = ((JobEntry)IJobRegistry.getInstance().getValue(jobType)).produceJob(citizen);
        if (job != null) {
            try {
                job.deserializeNBT((INBT)compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", jobType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", jobType));
        }
        return job;
    }

    @Override
    public IJobView createViewFrom(IColonyView colony, ICitizenDataView citizenDataView, PacketBuffer networkBuffer) {
        ResourceLocation jobName = new ResourceLocation(networkBuffer.func_150789_c(Short.MAX_VALUE));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(jobName);
        if (entry == null) {
            Log.getLogger().error(String.format("Unknown job type '%s'.", jobName), (Throwable)new Exception());
            return null;
        }
        IJobView view = entry.getJobViewProducer().get().apply(colony, citizenDataView);
        if (view != null) {
            view.deserialize(networkBuffer);
        }
        return view;
    }
}

