/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.blockout.Log;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.PlantationSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

public class BuildingPlantation
extends AbstractBuilding {
    public static final ISettingKey<PlantationSetting> MODE = new SettingKey<PlantationSetting>(PlantationSetting.class, new ResourceLocation("minecolonies", "mode"));
    public static final Map<Item, PlantationItem> COMBINATIONS = ImmutableMap.builder().put((Object)Items.field_222065_kN, (Object)new PlantationItem(Items.field_222065_kN, Blocks.field_196608_cF, "sugar", 3)).put((Object)Items.field_221774_cw, (Object)new PlantationItem(Items.field_221774_cw, Blocks.field_150434_aF, "cactus", 3)).put((Object)Items.field_222068_kQ, (Object)new PlantationItem(Items.field_222068_kQ, Blocks.field_222405_kQ, "bamboo", 3)).build();
    private static final String PLANTATION = "plantation";
    private final List<BlockPos> sand = new ArrayList<BlockPos>();

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        Block down;
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150354_m && ((down = world.func_180495_p(pos.func_177977_b()).func_177230_c()) == Blocks.field_150347_e || down == Blocks.field_196696_di)) {
            this.sand.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT sandPos = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.sand.add(NBTUtil.func_186861_c((CompoundNBT)sandPos.func_150305_b(i).func_74775_l("pos")));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT sandCompoundList = new ListNBT();
        for (BlockPos entry : this.sand) {
            @NotNull CompoundNBT sandCompound = new CompoundNBT();
            sandCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.func_218657_a("plantGround", (INBT)sandCompoundList);
        return compound;
    }

    public List<PlantationSoilPosition> getAllSoilPositions() {
        return this.getSoilPositions((tag, item) -> true);
    }

    private List<PlantationSoilPosition> getSoilPositions(BiPredicate<String, Item> filter) {
        ArrayList<PlantationSoilPosition> filtered = new ArrayList<PlantationSoilPosition>();
        if (this.tileEntity != null && !this.tileEntity.getPositionedTags().isEmpty()) {
            Map<String, Item> availableTags = COMBINATIONS.entrySet().stream().collect(Collectors.toMap(k -> ((PlantationItem)k.getValue()).getTag(), Map.Entry::getKey));
            for (Map.Entry<BlockPos, List<String>> entry : this.tileEntity.getPositionedTags().entrySet()) {
                Optional<String> foundTag = entry.getValue().stream().filter(availableTags::containsKey).findFirst();
                if (!foundTag.isPresent()) continue;
                Item item = availableTags.get(foundTag.get());
                if (!filter.test(foundTag.get(), item)) continue;
                filtered.add(new PlantationSoilPosition(this.getPosition().func_177971_a((Vector3i)entry.getKey()), COMBINATIONS.get(item)));
            }
        }
        return filtered;
    }

    public List<Item> getAvailablePlants() {
        String setting = this.getSetting(MODE).getValue();
        ArrayList<Item> items = new ArrayList<Item>();
        if (setting.contains(Items.field_222065_kN.func_77658_a())) {
            items.add(Items.field_222065_kN);
        }
        if (setting.contains(Items.field_221774_cw.func_77658_a())) {
            items.add(Items.field_221774_cw);
        }
        if (setting.contains(Items.field_222068_kQ.func_77658_a())) {
            items.add(Items.field_222068_kQ);
        }
        if (items.isEmpty()) {
            items.add(Items.field_222065_kN);
            Log.getLogger().log(Level.WARN, "Plantation plant setting contains none of the preconfigured plants, please report this to the developers!");
        }
        return items;
    }

    public static class PlantationItem {
        private final Item item;
        private final Block block;
        private final String tag;
        private final int minimumLength;

        private PlantationItem(Item item, Block block, String tag, int minimumLength) {
            this.item = item;
            this.block = block;
            this.tag = tag;
            this.minimumLength = minimumLength;
        }

        public Item getItem() {
            return this.item;
        }

        public Block getBlock() {
            return this.block;
        }

        public String getTag() {
            return this.tag;
        }

        public int getMinimumLength() {
            return this.minimumLength;
        }
    }

    public static class PlantationSoilPosition {
        private final BlockPos position;
        private final PlantationItem combination;

        private PlantationSoilPosition(BlockPos position, PlantationItem combination) {
            this.position = position;
            this.combination = combination;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public PlantationItem getCombination() {
            return this.combination;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingPlantation.PLANTATION).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingPlantation.PLANTATION);
            return isRecipeAllowed.orElse(false);
        }
    }
}

