/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingNetherWorker
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> CLOSE_PORTAL = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "closeportal"));
    private static final String NETHER_WORKER = "netherworker";
    private static final String TAG_CURRENT_TRIPS = "current_trips";
    private static final String TAG_CURRENT_DAY = "current_day";
    private static final int MAX_PER_PERIOD = 1;
    private static final int PERIOD_DAYS = 3;
    public static final String FOOD_EXCLUSION_LIST = "food";
    private int currentPeriodDay = 0;
    private int currentTrips = 0;
    private long snapTime;

    public BuildingNetherWorker(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(this::isAllowedFood, new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SWORD, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.func_77973_b() instanceof FlintAndSteelItem, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.FEET, new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return NETHER_WORKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public boolean shallClosePortalOnReturn() {
        return this.getSetting(CLOSE_PORTAL).getValue();
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.snapTime = this.colony.getWorld().func_72820_D();
        if (this.currentPeriodDay < BuildingNetherWorker.getPeriodDays()) {
            ++this.currentPeriodDay;
        } else {
            this.currentPeriodDay = 0;
            this.currentTrips = 0;
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b(TAG_CURRENT_TRIPS)) {
            this.currentTrips = compound.func_74762_e(TAG_CURRENT_TRIPS);
        }
        if (compound.func_74764_b(TAG_CURRENT_DAY)) {
            this.currentPeriodDay = compound.func_74762_e(TAG_CURRENT_DAY);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a(TAG_CURRENT_TRIPS, this.currentTrips);
        compound.func_74768_a(TAG_CURRENT_DAY, this.currentPeriodDay);
        return compound;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (inventory && this.getFirstModuleOccurance(MinimumStockModule.class).isStocked(stack)) {
            return stack.func_190916_E();
        }
        IRecipeStorage rs = this.getFirstModuleOccurance(CraftingModule.class).getFirstRecipe(ItemStack::func_190926_b);
        if (rs != null) {
            ItemStorage kept = new ItemStorage(stack);
            boolean containsItem = rs.getInput().contains(kept);
            int keptCount = localAlreadyKept.stream().filter(storage -> storage.equals(kept)).mapToInt(ItemStorage::getAmount).sum();
            if (containsItem && (keptCount < 64 || !inventory)) {
                if (localAlreadyKept.contains(kept)) {
                    kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
                }
                localAlreadyKept.add(kept);
                return 0;
            }
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }

    public boolean isAllowedFood(ItemStack stack) {
        ItemListModule listModule = this.getModuleMatching(ItemListModule.class, m -> m.getId().equals(FOOD_EXCLUSION_LIST));
        return ItemStackUtils.ISFOOD.test(stack) && !listModule.isItemInList(new ItemStorage(stack)) && !ItemStackUtils.ISCOOKABLE.test(stack);
    }

    public boolean isReadyForTrip() {
        if (this.snapTime == 0L) {
            this.snapTime = this.colony.getWorld().func_72820_D();
        }
        if (Math.abs(this.colony.getWorld().func_72820_D() - this.snapTime) >= 24000L) {
            ++this.currentPeriodDay;
        }
        return this.currentTrips < BuildingNetherWorker.getMaxPerPeriod();
    }

    public void recordTrip() {
        ++this.currentTrips;
    }

    public BlockPos getPortalLocation() {
        BlockPos portalLocation = this.getFirstLocationFromTag("portal");
        if (portalLocation != null) {
            return portalLocation.func_177984_a();
        }
        return null;
    }

    public BlockPos getVaultLocation() {
        return this.getFirstLocationFromTag("vault");
    }

    public static int getMaxPerPeriod() {
        return 1;
    }

    public static int getPeriodDays() {
        return 3;
    }

    public static void onResetFoodExclusionList(ItemListModule listModule) {
        listModule.clearItems();
        for (Item item : ModTags.excludedFood.func_230236_b_()) {
            listModule.addItem(new ItemStorage(new ItemStack((IItemProvider)item)));
        }
    }

    @Override
    public void onPlacement() {
        super.onPlacement();
        World world = this.colony.getWorld();
        if (WorldUtil.isNetherType(world)) {
            Block block = world.func_180495_p(this.getPosition()).func_177230_c();
            block.func_176206_d((IWorld)world, this.getPosition(), world.func_180495_p(this.getPosition()));
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

