/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ArrayListMultimap;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.util.BackUpHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyManagerCapability {
    public IColony createColony(@NotNull World var1, @NotNull BlockPos var2);

    public void deleteColony(int var1);

    @Nullable
    public IColony getColony(int var1);

    public List<IColony> getColonies();

    public void addColony(IColony var1);

    public int getTopID();

    public static class Storage
    implements Capability.IStorage<IColonyManagerCapability> {
        public INBT writeNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("colonies", (INBT)instance.getColonies().stream().map(IColony::getColonyTag).filter(Objects::nonNull).collect(NBTUtils.toListNBT()));
            CompoundNBT managerCompound = new CompoundNBT();
            IColonyManager.getInstance().write(managerCompound);
            compound.func_218657_a("colonymanager", (INBT)managerCompound);
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable Direction side, @NotNull INBT nbt) {
            IColonyManager.getInstance().setCapLoaded();
            if (nbt instanceof CompoundNBT) {
                CompoundNBT compound = (CompoundNBT)nbt;
                if (!compound.func_74764_b("colonies") || !compound.func_74764_b("colonymanager")) {
                    BackUpHelper.loadMissingColonies();
                    BackUpHelper.loadManagerBackup();
                    return;
                }
                ArrayListMultimap tempColonies = ArrayListMultimap.create();
                for (INBT tag : compound.func_150295_c("colonies", 10)) {
                    Colony colony = Colony.loadColony((CompoundNBT)tag, null);
                    if (colony == null) continue;
                    tempColonies.put((Object)colony.getCenter(), (Object)colony);
                    instance.addColony(colony);
                }
                BackUpHelper.loadMissingColonies();
                for (BlockPos pos : tempColonies.keySet()) {
                    if (tempColonies.get((Object)pos).size() <= 1) continue;
                    Log.getLogger().warn("Detected duplicate colonies which are at the same position:");
                    for (IColony colony : tempColonies.get((Object)pos)) {
                        Log.getLogger().warn("ID: " + colony.getID() + " name:" + colony.getName() + " citizens:" + colony.getCitizenManager().getCitizens().size() + " building count:" + colony.getBuildingManager().getBuildings().size());
                    }
                    Log.getLogger().warn("Check and remove all except one of the duplicated colonies above!");
                }
                if (compound.func_150296_c().contains("colonymanager")) {
                    IColonyManager.getInstance().read(compound.func_74775_l("colonymanager"));
                }
            } else {
                BackUpHelper.loadMissingColonies();
                BackUpHelper.loadManagerBackup();
            }
        }
    }

    public static class Impl
    implements IColonyManagerCapability {
        @NotNull
        private final ColonyList<IColony> colonies = new ColonyList();

        @Override
        public IColony createColony(@NotNull World w, @NotNull BlockPos pos) {
            return this.colonies.create(w, pos);
        }

        @Override
        public void deleteColony(int id) {
            this.colonies.remove(id);
        }

        @Override
        public IColony getColony(int id) {
            return this.colonies.get(id);
        }

        @Override
        public List<IColony> getColonies() {
            return this.colonies.getCopyAsList();
        }

        @Override
        public void addColony(IColony colony) {
            this.colonies.add(colony);
        }

        @Override
        public int getTopID() {
            return this.colonies.getTopID();
        }
    }
}

