/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.client.gui.WindowHireWorker;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.RecallCitizenMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class SpecialAssignmentModuleWindow
extends AbstractModuleWindow {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String LABEL_WORKERNAME = "workerName";

    public SpecialAssignmentModuleWindow(IBuildingView building, String resource) {
        super(building, resource);
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton("recall", this::recallClicked);
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenMessage(this.buildingView));
    }

    protected void hireClicked(@NotNull Button button) {
        if (this.buildingView.getBuildingLevel() == 0) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.level0", new Object[0]).sendTo(new PlayerEntity[]{Minecraft.func_71410_x().field_71439_g});
            return;
        }
        @NotNull WindowHireWorker window = new WindowHireWorker(this.buildingView.getColony(), this.buildingView.getPosition());
        window.open();
    }

    public void onOpened() {
        super.onOpened();
        final ArrayList<Tuple<String, Integer>> workers = new ArrayList<Tuple<String, Integer>>();
        for (IAssignmentModuleView module : this.buildingView.getModuleViews(IAssignmentModuleView.class)) {
            for (int worker : module.getAssignedCitizens()) {
                workers.add(new Tuple<String, Integer>(new TranslationTextComponent(module.getJobEntry().getTranslationKey()).getString(), worker));
            }
        }
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return workers.size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker = SpecialAssignmentModuleWindow.this.buildingView.getColony().getCitizen((Integer)((Tuple)workers.get(index)).getB());
                    if (worker != null) {
                        ((Text)rowPane.findPaneOfTypeByID(SpecialAssignmentModuleWindow.LABEL_WORKERNAME, Text.class)).setText(new TranslationTextComponent((String)((Tuple)workers.get(index)).getA()).getString() + ": " + worker.getName());
                    }
                }
            });
        }
    }
}

