/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.EnchanterStationsModuleView;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class EnchanterStationModuleWindow
extends AbstractModuleWindow {
    private static final String RESOURCE_STRING = ":gui/layouthuts/layoutenchanter.xml";
    private static final String LIST_WORKERS = "gatherWorkers";
    private static final String WORKER_NAME = "workerName";
    private final EnchanterStationsModuleView module;
    private ScrollingList workerList;
    private List<BlockPos> selectedBuildings;
    private List<IBuildingView> allBuildings;

    public EnchanterStationModuleWindow(IBuildingView building, EnchanterStationsModuleView module) {
        super(building, "minecolonies:gui/layouthuts/layoutenchanter.xml");
        super.registerButton("switch", this::switchClicked);
        this.module = module;
    }

    public void onOpened() {
        super.onOpened();
        this.selectedBuildings = this.module.getBuildingsToGatherFrom();
        this.allBuildings = this.buildingView.getColony().getBuildings().stream().filter(b -> b instanceof AbstractBuildingView && !b.getModuleViews(WorkerBuildingModuleView.class).isEmpty() && b.getBuildingType() != ModBuildings.enchanter).sorted((b1, b2) -> (int)(BlockPosUtil.getDistance2D(this.buildingView.getPosition(), b1.getPosition()) - BlockPosUtil.getDistance2D(this.buildingView.getPosition(), b2.getPosition()))).collect(Collectors.toList());
        this.workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
        this.workerList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return EnchanterStationModuleWindow.this.allBuildings.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                IBuildingView bView = (IBuildingView)EnchanterStationModuleWindow.this.allBuildings.get(index);
                String text = "";
                if (bView instanceof AbstractBuildingView) {
                    text = text + (bView.getCustomName().isEmpty() ? bView.getSchematicName() : bView.getCustomName());
                    text = text + " " + BlockPosUtil.getDistance2D(EnchanterStationModuleWindow.this.buildingView.getPosition(), bView.getPosition()) + "m";
                    ((Text)rowPane.findPaneOfTypeByID(EnchanterStationModuleWindow.WORKER_NAME, Text.class)).setText(text);
                    Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                    if (EnchanterStationModuleWindow.this.selectedBuildings.contains(bView.getID())) {
                        switchButton.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.retrieveon"));
                    } else {
                        switchButton.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
                    }
                }
            }
        });
    }

    private void switchClicked(@NotNull Button button) {
        String buttonText;
        int row = this.workerList.getListElementIndexByPane((Pane)button);
        String string = buttonText = button.getText() instanceof TranslationTextComponent ? ((TranslationTextComponent)button.getText()).func_150268_i() : button.getTextAsString();
        if (buttonText.equals("com.minecolonies.coremod.gui.workerhuts.retrieveoff")) {
            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.retrieveon"));
            this.module.addWorker(this.allBuildings.get(row).getID());
        } else {
            button.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
            this.module.removeWorker(this.allBuildings.get(row).getID());
        }
        this.selectedBuildings = this.module.getBuildingsToGatherFrom();
        this.workerList.refreshElementPanes();
    }
}

