/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.huts;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowModuleBuilding;
import com.minecolonies.coremod.client.gui.WindowAssignCitizen;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.RecallCitizenHutMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class WindowHutLiving
extends AbstractWindowModuleBuilding<LivingBuildingView> {
    private static final String BUTTON_ASSIGN = "assign";
    private static final String ASSIGNED_LABEL = "assignedlabel";
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowhuthome.xml";
    private static final String LIST_CITIZEN = "assignedCitizen";
    private final LivingBuildingView home;
    private ScrollingList citizen;

    public WindowHutLiving(LivingBuildingView building) {
        super(building, "minecolonies:gui/windowhuthome.xml");
        super.registerButton(BUTTON_ASSIGN, this::assignClicked);
        super.registerButton("recall", this::recallClicked);
        this.home = building;
    }

    private void recallClicked() {
        Network.getNetwork().sendToServer(new RecallCitizenHutMessage((AbstractBuildingView)this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.citizen = (ScrollingList)this.findPaneOfTypeByID(LIST_CITIZEN, ScrollingList.class);
        this.citizen.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutLiving.this.home.getResidents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizenDataView = WindowHutLiving.this.home.getColony().getCitizen(WindowHutLiving.this.home.getResidents().get(index));
                if (citizenDataView != null) {
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((citizenDataView.getJob().isEmpty() ? "" : new TranslationTextComponent(citizenDataView.getJob()).getString() + ": ") + citizenDataView.getName());
                }
            }
        });
        this.refreshView();
    }

    private void refreshView() {
        ((Text)this.findPaneOfTypeByID(ASSIGNED_LABEL, Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.home.assigned", new Object[]{((LivingBuildingView)this.building).getResidents().size(), ((LivingBuildingView)this.building).getMax()}));
        this.citizen.refreshElementPanes();
    }

    private void assignClicked() {
        if (((LivingBuildingView)this.building).getBuildingLevel() == 0) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.level0", new Object[0]).sendTo(new PlayerEntity[]{Minecraft.func_71410_x().field_71439_g});
            return;
        }
        @NotNull WindowAssignCitizen window = new WindowAssignCitizen(((LivingBuildingView)this.building).getColony(), (LivingBuildingView)this.building);
        window.open();
    }
}

