/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildPickUpMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.BuildingSetStyleMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildBuilding
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    protected TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> DONT_TOUCH_PREDICATE = (info, worldPos, handler) -> {
        BlockState worldState = handler.getWorld().func_180495_p(worldPos);
        return worldState.func_177230_c() instanceof IBuilderUndestroyable || worldState.func_177230_c() == Blocks.field_150357_h || info.getBlockInfo().getState().func_177230_c() instanceof AbstractBlockHut && handler.getWorldPos().equals(worldPos);
    };
    private final IBuildingView building;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private DropDownList stylesDropDownList;
    private DropDownList buildersDropDownList;
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    @NotNull
    private List<String> styles = new ArrayList<String>();
    @NotNull
    private List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();

    public WindowBuildBuilding(IColonyView c, IBuildingView building) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.building = building;
        this.initStyleNavigation();
        this.registerButton("build", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("deconstruct", this::deconstructBuildingClicked);
        this.registerButton("pickup", this::pickUpBuilding);
        Button buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        IBuildingView parentBuilding = c.getBuilding(building.getParent());
        if (building.getBuildingLevel() == 0) {
            buttonBuild.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.build"));
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("deconstruct", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
        } else if (building.getBuildingLevel() == building.getBuildingMaxLevel() || parentBuilding != null && building.getBuildingLevel() >= parentBuilding.getBuildingLevel()) {
            buttonBuild.hide();
        } else {
            buttonBuild.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.upgrade"));
        }
        if (building.isDeconstructed()) {
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.workerhuts.build"));
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
        }
    }

    private void pickUpBuilding() {
        Network.getNetwork().sendToServer(new BuildPickUpMessage(this.building));
        this.close();
    }

    private void deconstructBuildingClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.field_177992_a : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).func_76340_b();
        Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REMOVE, builder));
        this.cancelClicked();
    }

    private void cancelClicked() {
        this.building.openGui(false);
    }

    private void confirmClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.field_177992_a : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).func_76340_b();
        Network.getNetwork().sendToServer(new BuildingSetStyleMessage(this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex())));
        if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REPAIR, builder));
        } else {
            Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.BUILD, builder));
        }
        this.cancelClicked();
    }

    private void repairClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.field_177992_a : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).func_76340_b();
        Network.getNetwork().sendToServer(new BuildRequestMessage(this.building, BuildRequestMessage.Mode.REPAIR, builder));
        this.cancelClicked();
    }

    private void updateBuilders() {
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(new TranslationTextComponent(ModJobs.builder.getTranslationKey()).getString() + ":"), (Object)BlockPos.field_177992_a));
        this.builders.addAll(this.building.getColony().getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && build.getBuildingType() != ModBuildings.miner).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getPosition())).sorted(Comparator.comparing(item -> ((BlockPos)item.func_76340_b()).func_177951_i((Vector3i)this.building.getPosition()))).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void updateStyles() {
        if (!this.building.getParent().equals((Object)BlockPos.field_177992_a) && this.building.getColony().getBuilding(this.building.getParent()) != null) {
            this.styles = new ArrayList<String>();
            this.styles.add(this.building.getColony().getBuilding(this.building.getParent()).getStyle());
            if (!this.styles.isEmpty()) {
                this.stylesDropDownList.setSelectedIndex(0);
            }
        } else {
            if (this.building.getBuildingLevel() == 0) {
                this.styles = Structures.getStylesFor((String)this.building.getSchematicName());
            } else {
                this.styles = new ArrayList<String>();
                this.styles.add(this.building.getStyle());
            }
            if (!this.styles.isEmpty()) {
                int newIndex = this.styles.indexOf(this.building.getStyle());
                if (newIndex == -1) {
                    newIndex = 0;
                }
                this.stylesDropDownList.setSelectedIndex(newIndex);
            }
        }
        boolean enabled = !Settings.instance.isStaticSchematicMode();
        ((Button)this.findPaneOfTypeByID("previousStyle", Button.class)).setEnabled(enabled);
        ((DropDownList)this.findPaneOfTypeByID("style", DropDownList.class)).setEnabled(enabled);
        ((Button)this.findPaneOfTypeByID("nextStyle", Button.class)).setEnabled(enabled);
    }

    private void updateResources() {
        StructurePhasePlacementResult result;
        if (this.stylesDropDownList.getSelectedIndex() == -1) {
            return;
        }
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        this.resources.clear();
        IBuildingView parentBuilding = this.building.getColony().getBuilding(this.building.getParent());
        int nextLevel = this.building.getBuildingLevel();
        if (this.building.getBuildingLevel() < this.building.getBuildingMaxLevel() && (parentBuilding == null || this.building.getBuildingLevel() < parentBuilding.getBuildingLevel())) {
            nextLevel = this.building.getBuildingLevel() + 1;
        }
        TileEntity tile = world.func_175625_s(this.building.getID());
        String schematicName = this.building.getSchematicName();
        if (tile instanceof IBlueprintDataProvider && !((IBlueprintDataProvider)tile).getSchematicName().isEmpty()) {
            schematicName = ((IBlueprintDataProvider)tile).getSchematicName().replaceAll("\\d$", "");
        }
        StructureName sn = new StructureName("schematics", this.styles.get(this.stylesDropDownList.getSelectedIndex()), schematicName + nextLevel);
        LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler((World)world, this.building.getPosition(), sn.toString(), new PlacementSettings(), true);
        String md5 = Structures.getMD5((String)sn.toString());
        if (!structure.hasBluePrint() || !structure.isCorrectMD5(md5)) {
            if (!structure.hasBluePrint()) {
                Log.getLogger().info("Template structure " + sn + " missing");
            } else {
                Log.getLogger().info("structure " + sn + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + sn);
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                com.ldtteam.structurize.Network.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(sn.toString()));
                return;
            }
            Log.getLogger().error("WindowMinecoloniesBuildTool: Need to download schematic on a standalone client/server. This should never happen", (Throwable)new Exception());
        }
        if (!structure.hasBluePrint()) {
            ((Button)this.findPaneOfTypeByID("build", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("repair", Button.class)).hide();
            ((Button)this.findPaneOfTypeByID("pickup", Button.class)).show();
            return;
        }
        structure.getBluePrint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.building.getRotation()), this.building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, (World)world);
        StructurePlacer placer = new StructurePlacer((IStructureHandler)structure);
        BlockPos progressPos = AbstractBlueprintIterator.NULL_POS;
        do {
            result = placer.executeStructureStep((World)world, null, progressPos, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.and((info, pos, handler) -> false)), true);
            progressPos = result.getIteratorPos();
            for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                this.addNeededResource(stack, stack.func_190916_E());
            }
        } while (result != null && result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED);
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        String key = res.func_77977_a() + "-" + hashCode;
        ItemStorage resource = this.resources.get(key);
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(key, resource);
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = (DropDownList)this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onStyleDropDownChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildBuilding.this.styles.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.styles.size()) {
                    return (String)WindowBuildBuilding.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = (DropDownList)this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowBuildBuilding.this.builders.size();
            }

            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.builders.size()) {
                    return (String)((Tuple)WindowBuildBuilding.this.builders.get(index)).func_76341_a();
                }
                return "";
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void onStyleDropDownChanged(DropDownList list) {
        this.updateResources();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    public void onOpened() {
        this.updateStyles();
        this.updateBuilders();
        this.updateResources();
    }

    public void updateResourceList() {
        ScrollingList recourseList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().func_200301_q());
                quantityLabel.setText(Integer.toString(resource.getAmount()));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack itemIcon = new ItemStack((IItemProvider)resource.getItem(), 1);
                itemIcon.func_77982_d(resource.getItemStack().func_77978_p());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(itemIcon);
            }
        });
    }
}

