/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class NBTUtils {
    public static Stream<CompoundNBT> streamCompound(ListNBT list) {
        return NBTUtils.streamBase(list).filter(b -> b instanceof CompoundNBT).map(b -> (CompoundNBT)b);
    }

    public static Stream<INBT> streamBase(ListNBT list) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TagListIterator(list), 16), false);
    }

    public static Collector<CompoundNBT, ?, ListNBT> toListNBT() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            ListNBT tagList = new ListNBT();
            tagList.addAll((Collection)list);
            return tagList;
        });
    }

    private static class TagListIterator
    implements Iterator<INBT> {
        private final ListNBT list;
        private int currentIndex = 0;

        private TagListIterator(ListNBT list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.list.size();
        }

        @Override
        public INBT next() {
            return this.list.func_150305_b(this.currentIndex++);
        }
    }
}

