/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.FurnaceResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingFurnace
extends Container {
    private final IItemHandler furnaceInventory;
    private final PlayerInventory playerInventory;
    public final BlockPos buildingPos;
    private String moduleId;

    public static ContainerCraftingFurnace fromPacketBuffer(int windowId, PlayerInventory inv, PacketBuffer packetBuffer) {
        BlockPos tePos = packetBuffer.func_179259_c();
        String moduleId = packetBuffer.func_150789_c(Short.MAX_VALUE);
        return new ContainerCraftingFurnace(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingFurnace(int windowId, PlayerInventory inv, BlockPos pos, String moduleId) {
        super(ModContainers.craftingFurnace, windowId);
        int i;
        this.moduleId = moduleId;
        this.furnaceInventory = new IItemHandlerModifiable(){
            ItemStack input = ItemStack.field_190927_a;
            ItemStack output = ItemStack.field_190927_a;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
            }

            public int getSlots() {
                return 3;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return this.input;
                }
                return this.output;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return !IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(stack).func_190926_b();
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.func_75146_a((Slot)new SlotItemHandler(this.furnaceInventory, 0, 56, 17){

            public int func_75219_a() {
                return 1;
            }

            @NotNull
            public ItemStack func_190901_a(PlayerEntity player, @NotNull ItemStack stack) {
                return ItemStack.field_190927_a;
            }

            @NotNull
            public ItemStack func_75209_a(int par1) {
                return ItemStack.field_190927_a;
            }

            public boolean func_75214_a(ItemStack par1ItemStack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity par1PlayerEntity) {
                return false;
            }
        });
        this.func_75146_a((Slot)new SlotItemHandler(this.furnaceInventory, 1, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType mode, PlayerEntity playerIn) {
        ItemStack clickResult;
        if (slotId >= 0 && slotId < 2) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                ItemStack dropping = playerIn.field_71071_by.func_70445_o();
                clickResult = this.handleSlotClick(slot, dropping);
            } else {
                clickResult = ItemStack.field_190927_a;
            }
        } else {
            clickResult = mode == ClickType.QUICK_MOVE ? ItemStack.field_190927_a : super.func_184996_a(slotId, clickedButton, mode, this.playerInventory.field_70458_d);
        }
        this.updateFurnaceOutput();
        return clickResult;
    }

    public void setFurnaceInput(ItemStack stack) {
        this.handleSlotClick(this.func_75139_a(0), stack);
        this.updateFurnaceOutput();
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.func_190916_E() > 0) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            slot.func_75215_d(copy);
        } else if (slot.func_75211_c().func_190916_E() > 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return slot.func_75211_c().func_77946_l();
    }

    private void updateFurnaceOutput() {
        if (!this.playerInventory.field_70458_d.field_70170_p.field_72995_K) {
            ServerPlayerEntity player = (ServerPlayerEntity)this.playerInventory.field_70458_d;
            ItemStack result = IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(this.furnaceInventory.getStackInSlot(0));
            this.furnaceInventory.insertItem(1, result, false);
            player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 1, result));
        }
    }

    public boolean func_75145_c(@NotNull PlayerEntity playerIn) {
        return true;
    }

    @NotNull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (index <= 2) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStackUtils.EMPTY;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 32) {
                if (!this.func_75135_a(itemstack1, 32, 38, false)) {
                    return ItemStackUtils.EMPTY;
                }
            } else if (index < 38 && !this.func_75135_a(itemstack1, 2, 32, false) || !this.func_75135_a(itemstack1, 2, 38, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStackUtils.EMPTY);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStackUtils.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return !(slotIn instanceof FurnaceResultSlot) && super.func_94530_a(stack, slotIn);
    }

    public PlayerEntity getPlayer() {
        return this.playerInventory.field_70458_d;
    }

    public World getWorldObj() {
        return this.playerInventory.field_70458_d.field_70170_p;
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public String getModuleId() {
        return this.moduleId;
    }
}

